//! This file is auto-generated by tools/update_crc_catalog.zig.

const std = @import("std");
const testing = std.testing;
const verify = @import("../verify.zig");
const crc = @import("../crc.zig");

test "crc32 ieee regression" {
    const crc32 = crc.Crc32IsoHdlc;
    try testing.expectEqual(crc32.hash(""), 0x00000000);
    try testing.expectEqual(crc32.hash("a"), 0xe8b7be43);
    try testing.expectEqual(crc32.hash("abc"), 0x352441c2);
}

test "crc32 castagnoli regression" {
    const crc32 = crc.Crc32Iscsi;
    try testing.expectEqual(crc32.hash(""), 0x00000000);
    try testing.expectEqual(crc32.hash("a"), 0xc1d04330);
    try testing.expectEqual(crc32.hash("abc"), 0x364b3fb7);
}

test "crc32 koopman regression" {
    const crc32 = crc.Crc32Koopman;
    try testing.expectEqual(crc32.hash(""), 0x00000000);
    try testing.expectEqual(crc32.hash("a"), 0x0da2aa8a);
    try testing.expectEqual(crc32.hash("abc"), 0xba2322ac);
}

test "CRC-3/GSM" {
    const Crc3Gsm = crc.Crc3Gsm;

    try testing.expectEqual(@as(u3, 0x4), Crc3Gsm.hash("123456789"));

    var c = Crc3Gsm.init();
    c.update("1234");
    c.update("56789");
    try testing.expectEqual(@as(u3, 0x4), c.final());
}

test "CRC-3/ROHC" {
    const Crc3Rohc = crc.Crc3Rohc;

    try testing.expectEqual(@as(u3, 0x6), Crc3Rohc.hash("123456789"));

    var c = Crc3Rohc.init();
    c.update("1234");
    c.update("56789");
    try testing.expectEqual(@as(u3, 0x6), c.final());
}

test "CRC-4/G-704" {
    const Crc4G704 = crc.Crc4G704;

    try testing.expectEqual(@as(u4, 0x7), Crc4G704.hash("123456789"));

    var c = Crc4G704.init();
    c.update("1234");
    c.update("56789");
    try testing.expectEqual(@as(u4, 0x7), c.final());
}

test "CRC-4/INTERLAKEN" {
    const Crc4Interlaken = crc.Crc4Interlaken;

    try testing.expectEqual(@as(u4, 0xb), Crc4Interlaken.hash("123456789"));

    var c = Crc4Interlaken.init();
    c.update("1234");
    c.update("56789");
    try testing.expectEqual(@as(u4, 0xb), c.final());
}

test "CRC-5/EPC-C1G2" {
    const Crc5EpcC1g2 = crc.Crc5EpcC1g2;

    try testing.expectEqual(@as(u5, 0x00), Crc5EpcC1g2.hash("123456789"));

    var c = Crc5EpcC1g2.init();
    c.update("1234");
    c.update("56789");
    try testing.expectEqual(@as(u5, 0x00), c.final());
}

test "CRC-5/G-704" {
    const Crc5G704 = crc.Crc5G704;

    try testing.expectEqual(@as(u5, 0x07), Crc5G704.hash("123456789"));

    var c = Crc5G704.init();
    c.update("1234");
    c.update("56789");
    try testing.expectEqual(@as(u5, 0x07), c.final());
}

test "CRC-5/USB" {
    const Crc5Usb = crc.Crc5Usb;

    try testing.expectEqual(@as(u5, 0x19), Crc5Usb.hash("123456789"));

    var c = Crc5Usb.init();
    c.update("1234");
    c.update("56789");
    try testing.expectEqual(@as(u5, 0x19), c.final());
}

test "CRC-6/CDMA2000-A" {
    const Crc6Cdma2000A = crc.Crc6Cdma2000A;

    try testing.expectEqual(@as(u6, 0x0d), Crc6Cdma2000A.hash("123456789"));

    var c = Crc6Cdma2000A.init();
    c.update("1234");
    c.update("56789");
    try testing.expectEqual(@as(u6, 0x0d), c.final());
}

test "CRC-6/CDMA2000-B" {
    const Crc6Cdma2000B = crc.Crc6Cdma2000B;

    try testing.expectEqual(@as(u6, 0x3b), Crc6Cdma2000B.hash("123456789"));

    var c = Crc6Cdma2000B.init();
    c.update("1234");
    c.update("56789");
    try testing.expectEqual(@as(u6, 0x3b), c.final());
}

test "CRC-6/DARC" {
    const Crc6Darc = crc.Crc6Darc;

    try testing.expectEqual(@as(u6, 0x26), Crc6Darc.hash("123456789"));

    var c = Crc6Darc.init();
    c.update("1234");
    c.update("56789");
    try testing.expectEqual(@as(u6, 0x26), c.final());
}

test "CRC-6/G-704" {
    const Crc6G704 = crc.Crc6G704;

    try testing.expectEqual(@as(u6, 0x06), Crc6G704.hash("123456789"));

    var c = Crc6G704.init();
    c.update("1234");
    c.update("56789");
    try testing.expectEqual(@as(u6, 0x06), c.final());
}

test "CRC-6/GSM" {
    const Crc6Gsm = crc.Crc6Gsm;

    try testing.expectEqual(@as(u6, 0x13), Crc6Gsm.hash("123456789"));

    var c = Crc6Gsm.init();
    c.update("1234");
    c.update("56789");
    try testing.expectEqual(@as(u6, 0x13), c.final());
}

test "CRC-7/MMC" {
    const Crc7Mmc = crc.Crc7Mmc;

    try testing.expectEqual(@as(u7, 0x75), Crc7Mmc.hash("123456789"));

    var c = Crc7Mmc.init();
    c.update("1234");
    c.update("56789");
    try testing.expectEqual(@as(u7, 0x75), c.final());
}

test "CRC-7/ROHC" {
    const Crc7Rohc = crc.Crc7Rohc;

    try testing.expectEqual(@as(u7, 0x53), Crc7Rohc.hash("123456789"));

    var c = Crc7Rohc.init();
    c.update("1234");
    c.update("56789");
    try testing.expectEqual(@as(u7, 0x53), c.final());
}

test "CRC-7/UMTS" {
    const Crc7Umts = crc.Crc7Umts;

    try testing.expectEqual(@as(u7, 0x61), Crc7Umts.hash("123456789"));

    var c = Crc7Umts.init();
    c.update("1234");
    c.update("56789");
    try testing.expectEqual(@as(u7, 0x61), c.final());
}

test "CRC-8/AUTOSAR" {
    const Crc8Autosar = crc.Crc8Autosar;

    try testing.expectEqual(@as(u8, 0xdf), Crc8Autosar.hash("123456789"));

    var c = Crc8Autosar.init();
    c.update("1234");
    c.update("56789");
    try testing.expectEqual(@as(u8, 0xdf), c.final());
}

test "CRC-8/BLUETOOTH" {
    const Crc8Bluetooth = crc.Crc8Bluetooth;

    try testing.expectEqual(@as(u8, 0x26), Crc8Bluetooth.hash("123456789"));

    var c = Crc8Bluetooth.init();
    c.update("1234");
    c.update("56789");
    try testing.expectEqual(@as(u8, 0x26), c.final());
}

test "CRC-8/CDMA2000" {
    const Crc8Cdma2000 = crc.Crc8Cdma2000;

    try testing.expectEqual(@as(u8, 0xda), Crc8Cdma2000.hash("123456789"));

    var c = Crc8Cdma2000.init();
    c.update("1234");
    c.update("56789");
    try testing.expectEqual(@as(u8, 0xda), c.final());
}

test "CRC-8/DARC" {
    const Crc8Darc = crc.Crc8Darc;

    try testing.expectEqual(@as(u8, 0x15), Crc8Darc.hash("123456789"));

    var c = Crc8Darc.init();
    c.update("1234");
    c.update("56789");
    try testing.expectEqual(@as(u8, 0x15), c.final());
}

test "CRC-8/DVB-S2" {
    const Crc8DvbS2 = crc.Crc8DvbS2;

    try testing.expectEqual(@as(u8, 0xbc), Crc8DvbS2.hash("123456789"));

    var c = Crc8DvbS2.init();
    c.update("1234");
    c.update("56789");
    try testing.expectEqual(@as(u8, 0xbc), c.final());
}

test "CRC-8/GSM-A" {
    const Crc8GsmA = crc.Crc8GsmA;

    try testing.expectEqual(@as(u8, 0x37), Crc8GsmA.hash("123456789"));

    var c = Crc8GsmA.init();
    c.update("1234");
    c.update("56789");
    try testing.expectEqual(@as(u8, 0x37), c.final());
}

test "CRC-8/GSM-B" {
    const Crc8GsmB = crc.Crc8GsmB;

    try testing.expectEqual(@as(u8, 0x94), Crc8GsmB.hash("123456789"));

    var c = Crc8GsmB.init();
    c.update("1234");
    c.update("56789");
    try testing.expectEqual(@as(u8, 0x94), c.final());
}

test "CRC-8/HITAG" {
    const Crc8Hitag = crc.Crc8Hitag;

    try testing.expectEqual(@as(u8, 0xb4), Crc8Hitag.hash("123456789"));

    var c = Crc8Hitag.init();
    c.update("1234");
    c.update("56789");
    try testing.expectEqual(@as(u8, 0xb4), c.final());
}

test "CRC-8/I-432-1" {
    const Crc8I4321 = crc.Crc8I4321;

    try testing.expectEqual(@as(u8, 0xa1), Crc8I4321.hash("123456789"));

    var c = Crc8I4321.init();
    c.update("1234");
    c.update("56789");
    try testing.expectEqual(@as(u8, 0xa1), c.final());
}

test "CRC-8/I-CODE" {
    const Crc8ICode = crc.Crc8ICode;

    try testing.expectEqual(@as(u8, 0x7e), Crc8ICode.hash("123456789"));

    var c = Crc8ICode.init();
    c.update("1234");
    c.update("56789");
    try testing.expectEqual(@as(u8, 0x7e), c.final());
}

test "CRC-8/LTE" {
    const Crc8Lte = crc.Crc8Lte;

    try testing.expectEqual(@as(u8, 0xea), Crc8Lte.hash("123456789"));

    var c = Crc8Lte.init();
    c.update("1234");
    c.update("56789");
    try testing.expectEqual(@as(u8, 0xea), c.final());
}

test "CRC-8/MAXIM-DOW" {
    const Crc8MaximDow = crc.Crc8MaximDow;

    try testing.expectEqual(@as(u8, 0xa1), Crc8MaximDow.hash("123456789"));

    var c = Crc8MaximDow.init();
    c.update("1234");
    c.update("56789");
    try testing.expectEqual(@as(u8, 0xa1), c.final());
}

test "CRC-8/MIFARE-MAD" {
    const Crc8MifareMad = crc.Crc8MifareMad;

    try testing.expectEqual(@as(u8, 0x99), Crc8MifareMad.hash("123456789"));

    var c = Crc8MifareMad.init();
    c.update("1234");
    c.update("56789");
    try testing.expectEqual(@as(u8, 0x99), c.final());
}

test "CRC-8/NRSC-5" {
    const Crc8Nrsc5 = crc.Crc8Nrsc5;

    try testing.expectEqual(@as(u8, 0xf7), Crc8Nrsc5.hash("123456789"));

    var c = Crc8Nrsc5.init();
    c.update("1234");
    c.update("56789");
    try testing.expectEqual(@as(u8, 0xf7), c.final());
}

test "CRC-8/OPENSAFETY" {
    const Crc8Opensafety = crc.Crc8Opensafety;

    try testing.expectEqual(@as(u8, 0x3e), Crc8Opensafety.hash("123456789"));

    var c = Crc8Opensafety.init();
    c.update("1234");
    c.update("56789");
    try testing.expectEqual(@as(u8, 0x3e), c.final());
}

test "CRC-8/ROHC" {
    const Crc8Rohc = crc.Crc8Rohc;

    try testing.expectEqual(@as(u8, 0xd0), Crc8Rohc.hash("123456789"));

    var c = Crc8Rohc.init();
    c.update("1234");
    c.update("56789");
    try testing.expectEqual(@as(u8, 0xd0), c.final());
}

test "CRC-8/SAE-J1850" {
    const Crc8SaeJ1850 = crc.Crc8SaeJ1850;

    try testing.expectEqual(@as(u8, 0x4b), Crc8SaeJ1850.hash("123456789"));

    var c = Crc8SaeJ1850.init();
    c.update("1234");
    c.update("56789");
    try testing.expectEqual(@as(u8, 0x4b), c.final());
}

test "CRC-8/SMBUS" {
    const Crc8Smbus = crc.Crc8Smbus;

    try testing.expectEqual(@as(u8, 0xf4), Crc8Smbus.hash("123456789"));

    var c = Crc8Smbus.init();
    c.update("1234");
    c.update("56789");
    try testing.expectEqual(@as(u8, 0xf4), c.final());
}

test "CRC-8/TECH-3250" {
    const Crc8Tech3250 = crc.Crc8Tech3250;

    try testing.expectEqual(@as(u8, 0x97), Crc8Tech3250.hash("123456789"));

    var c = Crc8Tech3250.init();
    c.update("1234");
    c.update("56789");
    try testing.expectEqual(@as(u8, 0x97), c.final());
}

test "CRC-8/WCDMA" {
    const Crc8Wcdma = crc.Crc8Wcdma;

    try testing.expectEqual(@as(u8, 0x25), Crc8Wcdma.hash("123456789"));

    var c = Crc8Wcdma.init();
    c.update("1234");
    c.update("56789");
    try testing.expectEqual(@as(u8, 0x25), c.final());
}

test "CRC-10/ATM" {
    const Crc10Atm = crc.Crc10Atm;

    try testing.expectEqual(@as(u10, 0x199), Crc10Atm.hash("123456789"));

    var c = Crc10Atm.init();
    c.update("1234");
    c.update("56789");
    try testing.expectEqual(@as(u10, 0x199), c.final());
}

test "CRC-10/CDMA2000" {
    const Crc10Cdma2000 = crc.Crc10Cdma2000;

    try testing.expectEqual(@as(u10, 0x233), Crc10Cdma2000.hash("123456789"));

    var c = Crc10Cdma2000.init();
    c.update("1234");
    c.update("56789");
    try testing.expectEqual(@as(u10, 0x233), c.final());
}

test "CRC-10/GSM" {
    const Crc10Gsm = crc.Crc10Gsm;

    try testing.expectEqual(@as(u10, 0x12a), Crc10Gsm.hash("123456789"));

    var c = Crc10Gsm.init();
    c.update("1234");
    c.update("56789");
    try testing.expectEqual(@as(u10, 0x12a), c.final());
}

test "CRC-11/FLEXRAY" {
    const Crc11Flexray = crc.Crc11Flexray;

    try testing.expectEqual(@as(u11, 0x5a3), Crc11Flexray.hash("123456789"));

    var c = Crc11Flexray.init();
    c.update("1234");
    c.update("56789");
    try testing.expectEqual(@as(u11, 0x5a3), c.final());
}

test "CRC-11/UMTS" {
    const Crc11Umts = crc.Crc11Umts;

    try testing.expectEqual(@as(u11, 0x061), Crc11Umts.hash("123456789"));

    var c = Crc11Umts.init();
    c.update("1234");
    c.update("56789");
    try testing.expectEqual(@as(u11, 0x061), c.final());
}

test "CRC-12/CDMA2000" {
    const Crc12Cdma2000 = crc.Crc12Cdma2000;

    try testing.expectEqual(@as(u12, 0xd4d), Crc12Cdma2000.hash("123456789"));

    var c = Crc12Cdma2000.init();
    c.update("1234");
    c.update("56789");
    try testing.expectEqual(@as(u12, 0xd4d), c.final());
}

test "CRC-12/DECT" {
    const Crc12Dect = crc.Crc12Dect;

    try testing.expectEqual(@as(u12, 0xf5b), Crc12Dect.hash("123456789"));

    var c = Crc12Dect.init();
    c.update("1234");
    c.update("56789");
    try testing.expectEqual(@as(u12, 0xf5b), c.final());
}

test "CRC-12/GSM" {
    const Crc12Gsm = crc.Crc12Gsm;

    try testing.expectEqual(@as(u12, 0xb34), Crc12Gsm.hash("123456789"));

    var c = Crc12Gsm.init();
    c.update("1234");
    c.update("56789");
    try testing.expectEqual(@as(u12, 0xb34), c.final());
}

test "CRC-12/UMTS" {
    const Crc12Umts = crc.Crc12Umts;

    try testing.expectEqual(@as(u12, 0xdaf), Crc12Umts.hash("123456789"));

    var c = Crc12Umts.init();
    c.update("1234");
    c.update("56789");
    try testing.expectEqual(@as(u12, 0xdaf), c.final());
}

test "CRC-13/BBC" {
    const Crc13Bbc = crc.Crc13Bbc;

    try testing.expectEqual(@as(u13, 0x04fa), Crc13Bbc.hash("123456789"));

    var c = Crc13Bbc.init();
    c.update("1234");
    c.update("56789");
    try testing.expectEqual(@as(u13, 0x04fa), c.final());
}

test "CRC-14/DARC" {
    const Crc14Darc = crc.Crc14Darc;

    try testing.expectEqual(@as(u14, 0x082d), Crc14Darc.hash("123456789"));

    var c = Crc14Darc.init();
    c.update("1234");
    c.update("56789");
    try testing.expectEqual(@as(u14, 0x082d), c.final());
}

test "CRC-14/GSM" {
    const Crc14Gsm = crc.Crc14Gsm;

    try testing.expectEqual(@as(u14, 0x30ae), Crc14Gsm.hash("123456789"));

    var c = Crc14Gsm.init();
    c.update("1234");
    c.update("56789");
    try testing.expectEqual(@as(u14, 0x30ae), c.final());
}

test "CRC-15/CAN" {
    const Crc15Can = crc.Crc15Can;

    try testing.expectEqual(@as(u15, 0x059e), Crc15Can.hash("123456789"));

    var c = Crc15Can.init();
    c.update("1234");
    c.update("56789");
    try testing.expectEqual(@as(u15, 0x059e), c.final());
}

test "CRC-15/MPT1327" {
    const Crc15Mpt1327 = crc.Crc15Mpt1327;

    try testing.expectEqual(@as(u15, 0x2566), Crc15Mpt1327.hash("123456789"));

    var c = Crc15Mpt1327.init();
    c.update("1234");
    c.update("56789");
    try testing.expectEqual(@as(u15, 0x2566), c.final());
}

test "CRC-16/ARC" {
    const Crc16Arc = crc.Crc16Arc;

    try testing.expectEqual(@as(u16, 0xbb3d), Crc16Arc.hash("123456789"));

    var c = Crc16Arc.init();
    c.update("1234");
    c.update("56789");
    try testing.expectEqual(@as(u16, 0xbb3d), c.final());
}

test "CRC-16/CDMA2000" {
    const Crc16Cdma2000 = crc.Crc16Cdma2000;

    try testing.expectEqual(@as(u16, 0x4c06), Crc16Cdma2000.hash("123456789"));

    var c = Crc16Cdma2000.init();
    c.update("1234");
    c.update("56789");
    try testing.expectEqual(@as(u16, 0x4c06), c.final());
}

test "CRC-16/CMS" {
    const Crc16Cms = crc.Crc16Cms;

    try testing.expectEqual(@as(u16, 0xaee7), Crc16Cms.hash("123456789"));

    var c = Crc16Cms.init();
    c.update("1234");
    c.update("56789");
    try testing.expectEqual(@as(u16, 0xaee7), c.final());
}

test "CRC-16/DDS-110" {
    const Crc16Dds110 = crc.Crc16Dds110;

    try testing.expectEqual(@as(u16, 0x9ecf), Crc16Dds110.hash("123456789"));

    var c = Crc16Dds110.init();
    c.update("1234");
    c.update("56789");
    try testing.expectEqual(@as(u16, 0x9ecf), c.final());
}

test "CRC-16/DECT-R" {
    const Crc16DectR = crc.Crc16DectR;

    try testing.expectEqual(@as(u16, 0x007e), Crc16DectR.hash("123456789"));

    var c = Crc16DectR.init();
    c.update("1234");
    c.update("56789");
    try testing.expectEqual(@as(u16, 0x007e), c.final());
}

test "CRC-16/DECT-X" {
    const Crc16DectX = crc.Crc16DectX;

    try testing.expectEqual(@as(u16, 0x007f), Crc16DectX.hash("123456789"));

    var c = Crc16DectX.init();
    c.update("1234");
    c.update("56789");
    try testing.expectEqual(@as(u16, 0x007f), c.final());
}

test "CRC-16/DNP" {
    const Crc16Dnp = crc.Crc16Dnp;

    try testing.expectEqual(@as(u16, 0xea82), Crc16Dnp.hash("123456789"));

    var c = Crc16Dnp.init();
    c.update("1234");
    c.update("56789");
    try testing.expectEqual(@as(u16, 0xea82), c.final());
}

test "CRC-16/EN-13757" {
    const Crc16En13757 = crc.Crc16En13757;

    try testing.expectEqual(@as(u16, 0xc2b7), Crc16En13757.hash("123456789"));

    var c = Crc16En13757.init();
    c.update("1234");
    c.update("56789");
    try testing.expectEqual(@as(u16, 0xc2b7), c.final());
}

test "CRC-16/GENIBUS" {
    const Crc16Genibus = crc.Crc16Genibus;

    try testing.expectEqual(@as(u16, 0xd64e), Crc16Genibus.hash("123456789"));

    var c = Crc16Genibus.init();
    c.update("1234");
    c.update("56789");
    try testing.expectEqual(@as(u16, 0xd64e), c.final());
}

test "CRC-16/GSM" {
    const Crc16Gsm = crc.Crc16Gsm;

    try testing.expectEqual(@as(u16, 0xce3c), Crc16Gsm.hash("123456789"));

    var c = Crc16Gsm.init();
    c.update("1234");
    c.update("56789");
    try testing.expectEqual(@as(u16, 0xce3c), c.final());
}

test "CRC-16/IBM-3740" {
    const Crc16Ibm3740 = crc.Crc16Ibm3740;

    try testing.expectEqual(@as(u16, 0x29b1), Crc16Ibm3740.hash("123456789"));

    var c = Crc16Ibm3740.init();
    c.update("1234");
    c.update("56789");
    try testing.expectEqual(@as(u16, 0x29b1), c.final());
}

test "CRC-16/IBM-SDLC" {
    const Crc16IbmSdlc = crc.Crc16IbmSdlc;

    try testing.expectEqual(@as(u16, 0x906e), Crc16IbmSdlc.hash("123456789"));

    var c = Crc16IbmSdlc.init();
    c.update("1234");
    c.update("56789");
    try testing.expectEqual(@as(u16, 0x906e), c.final());
}

test "CRC-16/ISO-IEC-14443-3-A" {
    const Crc16IsoIec144433A = crc.Crc16IsoIec144433A;

    try testing.expectEqual(@as(u16, 0xbf05), Crc16IsoIec144433A.hash("123456789"));

    var c = Crc16IsoIec144433A.init();
    c.update("1234");
    c.update("56789");
    try testing.expectEqual(@as(u16, 0xbf05), c.final());
}

test "CRC-16/KERMIT" {
    const Crc16Kermit = crc.Crc16Kermit;

    try testing.expectEqual(@as(u16, 0x2189), Crc16Kermit.hash("123456789"));

    var c = Crc16Kermit.init();
    c.update("1234");
    c.update("56789");
    try testing.expectEqual(@as(u16, 0x2189), c.final());
}

test "CRC-16/LJ1200" {
    const Crc16Lj1200 = crc.Crc16Lj1200;

    try testing.expectEqual(@as(u16, 0xbdf4), Crc16Lj1200.hash("123456789"));

    var c = Crc16Lj1200.init();
    c.update("1234");
    c.update("56789");
    try testing.expectEqual(@as(u16, 0xbdf4), c.final());
}

test "CRC-16/M17" {
    const Crc16M17 = crc.Crc16M17;

    try testing.expectEqual(@as(u16, 0x772b), Crc16M17.hash("123456789"));

    var c = Crc16M17.init();
    c.update("1234");
    c.update("56789");
    try testing.expectEqual(@as(u16, 0x772b), c.final());
}

test "CRC-16/MAXIM-DOW" {
    const Crc16MaximDow = crc.Crc16MaximDow;

    try testing.expectEqual(@as(u16, 0x44c2), Crc16MaximDow.hash("123456789"));

    var c = Crc16MaximDow.init();
    c.update("1234");
    c.update("56789");
    try testing.expectEqual(@as(u16, 0x44c2), c.final());
}

test "CRC-16/MCRF4XX" {
    const Crc16Mcrf4xx = crc.Crc16Mcrf4xx;

    try testing.expectEqual(@as(u16, 0x6f91), Crc16Mcrf4xx.hash("123456789"));

    var c = Crc16Mcrf4xx.init();
    c.update("1234");
    c.update("56789");
    try testing.expectEqual(@as(u16, 0x6f91), c.final());
}

test "CRC-16/MODBUS" {
    const Crc16Modbus = crc.Crc16Modbus;

    try testing.expectEqual(@as(u16, 0x4b37), Crc16Modbus.hash("123456789"));

    var c = Crc16Modbus.init();
    c.update("1234");
    c.update("56789");
    try testing.expectEqual(@as(u16, 0x4b37), c.final());
}

test "CRC-16/NRSC-5" {
    const Crc16Nrsc5 = crc.Crc16Nrsc5;

    try testing.expectEqual(@as(u16, 0xa066), Crc16Nrsc5.hash("123456789"));

    var c = Crc16Nrsc5.init();
    c.update("1234");
    c.update("56789");
    try testing.expectEqual(@as(u16, 0xa066), c.final());
}

test "CRC-16/OPENSAFETY-A" {
    const Crc16OpensafetyA = crc.Crc16OpensafetyA;

    try testing.expectEqual(@as(u16, 0x5d38), Crc16OpensafetyA.hash("123456789"));

    var c = Crc16OpensafetyA.init();
    c.update("1234");
    c.update("56789");
    try testing.expectEqual(@as(u16, 0x5d38), c.final());
}

test "CRC-16/OPENSAFETY-B" {
    const Crc16OpensafetyB = crc.Crc16OpensafetyB;

    try testing.expectEqual(@as(u16, 0x20fe), Crc16OpensafetyB.hash("123456789"));

    var c = Crc16OpensafetyB.init();
    c.update("1234");
    c.update("56789");
    try testing.expectEqual(@as(u16, 0x20fe), c.final());
}

test "CRC-16/PROFIBUS" {
    const Crc16Profibus = crc.Crc16Profibus;

    try testing.expectEqual(@as(u16, 0xa819), Crc16Profibus.hash("123456789"));

    var c = Crc16Profibus.init();
    c.update("1234");
    c.update("56789");
    try testing.expectEqual(@as(u16, 0xa819), c.final());
}

test "CRC-16/RIELLO" {
    const Crc16Riello = crc.Crc16Riello;

    try testing.expectEqual(@as(u16, 0x63d0), Crc16Riello.hash("123456789"));

    var c = Crc16Riello.init();
    c.update("1234");
    c.update("56789");
    try testing.expectEqual(@as(u16, 0x63d0), c.final());
}

test "CRC-16/SPI-FUJITSU" {
    const Crc16SpiFujitsu = crc.Crc16SpiFujitsu;

    try testing.expectEqual(@as(u16, 0xe5cc), Crc16SpiFujitsu.hash("123456789"));

    var c = Crc16SpiFujitsu.init();
    c.update("1234");
    c.update("56789");
    try testing.expectEqual(@as(u16, 0xe5cc), c.final());
}

test "CRC-16/T10-DIF" {
    const Crc16T10Dif = crc.Crc16T10Dif;

    try testing.expectEqual(@as(u16, 0xd0db), Crc16T10Dif.hash("123456789"));

    var c = Crc16T10Dif.init();
    c.update("1234");
    c.update("56789");
    try testing.expectEqual(@as(u16, 0xd0db), c.final());
}

test "CRC-16/TELEDISK" {
    const Crc16Teledisk = crc.Crc16Teledisk;

    try testing.expectEqual(@as(u16, 0x0fb3), Crc16Teledisk.hash("123456789"));

    var c = Crc16Teledisk.init();
    c.update("1234");
    c.update("56789");
    try testing.expectEqual(@as(u16, 0x0fb3), c.final());
}

test "CRC-16/TMS37157" {
    const Crc16Tms37157 = crc.Crc16Tms37157;

    try testing.expectEqual(@as(u16, 0x26b1), Crc16Tms37157.hash("123456789"));

    var c = Crc16Tms37157.init();
    c.update("1234");
    c.update("56789");
    try testing.expectEqual(@as(u16, 0x26b1), c.final());
}

test "CRC-16/UMTS" {
    const Crc16Umts = crc.Crc16Umts;

    try testing.expectEqual(@as(u16, 0xfee8), Crc16Umts.hash("123456789"));

    var c = Crc16Umts.init();
    c.update("1234");
    c.update("56789");
    try testing.expectEqual(@as(u16, 0xfee8), c.final());
}

test "CRC-16/USB" {
    const Crc16Usb = crc.Crc16Usb;

    try testing.expectEqual(@as(u16, 0xb4c8), Crc16Usb.hash("123456789"));

    var c = Crc16Usb.init();
    c.update("1234");
    c.update("56789");
    try testing.expectEqual(@as(u16, 0xb4c8), c.final());
}

test "CRC-16/XMODEM" {
    const Crc16Xmodem = crc.Crc16Xmodem;

    try testing.expectEqual(@as(u16, 0x31c3), Crc16Xmodem.hash("123456789"));

    var c = Crc16Xmodem.init();
    c.update("1234");
    c.update("56789");
    try testing.expectEqual(@as(u16, 0x31c3), c.final());
}

test "CRC-17/CAN-FD" {
    const Crc17CanFd = crc.Crc17CanFd;

    try testing.expectEqual(@as(u17, 0x04f03), Crc17CanFd.hash("123456789"));

    var c = Crc17CanFd.init();
    c.update("1234");
    c.update("56789");
    try testing.expectEqual(@as(u17, 0x04f03), c.final());
}

test "CRC-21/CAN-FD" {
    const Crc21CanFd = crc.Crc21CanFd;

    try testing.expectEqual(@as(u21, 0x0ed841), Crc21CanFd.hash("123456789"));

    var c = Crc21CanFd.init();
    c.update("1234");
    c.update("56789");
    try testing.expectEqual(@as(u21, 0x0ed841), c.final());
}

test "CRC-24/BLE" {
    const Crc24Ble = crc.Crc24Ble;

    try testing.expectEqual(@as(u24, 0xc25a56), Crc24Ble.hash("123456789"));

    var c = Crc24Ble.init();
    c.update("1234");
    c.update("56789");
    try testing.expectEqual(@as(u24, 0xc25a56), c.final());
}

test "CRC-24/FLEXRAY-A" {
    const Crc24FlexrayA = crc.Crc24FlexrayA;

    try testing.expectEqual(@as(u24, 0x7979bd), Crc24FlexrayA.hash("123456789"));

    var c = Crc24FlexrayA.init();
    c.update("1234");
    c.update("56789");
    try testing.expectEqual(@as(u24, 0x7979bd), c.final());
}

test "CRC-24/FLEXRAY-B" {
    const Crc24FlexrayB = crc.Crc24FlexrayB;

    try testing.expectEqual(@as(u24, 0x1f23b8), Crc24FlexrayB.hash("123456789"));

    var c = Crc24FlexrayB.init();
    c.update("1234");
    c.update("56789");
    try testing.expectEqual(@as(u24, 0x1f23b8), c.final());
}

test "CRC-24/INTERLAKEN" {
    const Crc24Interlaken = crc.Crc24Interlaken;

    try testing.expectEqual(@as(u24, 0xb4f3e6), Crc24Interlaken.hash("123456789"));

    var c = Crc24Interlaken.init();
    c.update("1234");
    c.update("56789");
    try testing.expectEqual(@as(u24, 0xb4f3e6), c.final());
}

test "CRC-24/LTE-A" {
    const Crc24LteA = crc.Crc24LteA;

    try testing.expectEqual(@as(u24, 0xcde703), Crc24LteA.hash("123456789"));

    var c = Crc24LteA.init();
    c.update("1234");
    c.update("56789");
    try testing.expectEqual(@as(u24, 0xcde703), c.final());
}

test "CRC-24/LTE-B" {
    const Crc24LteB = crc.Crc24LteB;

    try testing.expectEqual(@as(u24, 0x23ef52), Crc24LteB.hash("123456789"));

    var c = Crc24LteB.init();
    c.update("1234");
    c.update("56789");
    try testing.expectEqual(@as(u24, 0x23ef52), c.final());
}

test "CRC-24/OPENPGP" {
    const Crc24Openpgp = crc.Crc24Openpgp;

    try testing.expectEqual(@as(u24, 0x21cf02), Crc24Openpgp.hash("123456789"));

    var c = Crc24Openpgp.init();
    c.update("1234");
    c.update("56789");
    try testing.expectEqual(@as(u24, 0x21cf02), c.final());
}

test "CRC-24/OS-9" {
    const Crc24Os9 = crc.Crc24Os9;

    try testing.expectEqual(@as(u24, 0x200fa5), Crc24Os9.hash("123456789"));

    var c = Crc24Os9.init();
    c.update("1234");
    c.update("56789");
    try testing.expectEqual(@as(u24, 0x200fa5), c.final());
}

test "CRC-30/CDMA" {
    const Crc30Cdma = crc.Crc30Cdma;

    try testing.expectEqual(@as(u30, 0x04c34abf), Crc30Cdma.hash("123456789"));

    var c = Crc30Cdma.init();
    c.update("1234");
    c.update("56789");
    try testing.expectEqual(@as(u30, 0x04c34abf), c.final());
}

test "CRC-31/PHILIPS" {
    const Crc31Philips = crc.Crc31Philips;

    try testing.expectEqual(@as(u31, 0x0ce9e46c), Crc31Philips.hash("123456789"));

    var c = Crc31Philips.init();
    c.update("1234");
    c.update("56789");
    try testing.expectEqual(@as(u31, 0x0ce9e46c), c.final());
}

test "CRC-32/AIXM" {
    const Crc32Aixm = crc.Crc32Aixm;

    try testing.expectEqual(@as(u32, 0x3010bf7f), Crc32Aixm.hash("123456789"));

    var c = Crc32Aixm.init();
    c.update("1234");
    c.update("56789");
    try testing.expectEqual(@as(u32, 0x3010bf7f), c.final());
}

test "CRC-32/AUTOSAR" {
    const Crc32Autosar = crc.Crc32Autosar;

    try testing.expectEqual(@as(u32, 0x1697d06a), Crc32Autosar.hash("123456789"));

    var c = Crc32Autosar.init();
    c.update("1234");
    c.update("56789");
    try testing.expectEqual(@as(u32, 0x1697d06a), c.final());
}

test "CRC-32/BASE91-D" {
    const Crc32Base91D = crc.Crc32Base91D;

    try testing.expectEqual(@as(u32, 0x87315576), Crc32Base91D.hash("123456789"));

    var c = Crc32Base91D.init();
    c.update("1234");
    c.update("56789");
    try testing.expectEqual(@as(u32, 0x87315576), c.final());
}

test "CRC-32/BZIP2" {
    const Crc32Bzip2 = crc.Crc32Bzip2;

    try testing.expectEqual(@as(u32, 0xfc891918), Crc32Bzip2.hash("123456789"));

    var c = Crc32Bzip2.init();
    c.update("1234");
    c.update("56789");
    try testing.expectEqual(@as(u32, 0xfc891918), c.final());
}

test "CRC-32/CD-ROM-EDC" {
    const Crc32CdRomEdc = crc.Crc32CdRomEdc;

    try testing.expectEqual(@as(u32, 0x6ec2edc4), Crc32CdRomEdc.hash("123456789"));

    var c = Crc32CdRomEdc.init();
    c.update("1234");
    c.update("56789");
    try testing.expectEqual(@as(u32, 0x6ec2edc4), c.final());
}

test "CRC-32/CKSUM" {
    const Crc32Cksum = crc.Crc32Cksum;

    try testing.expectEqual(@as(u32, 0x765e7680), Crc32Cksum.hash("123456789"));

    var c = Crc32Cksum.init();
    c.update("1234");
    c.update("56789");
    try testing.expectEqual(@as(u32, 0x765e7680), c.final());
}

test "CRC-32/ISCSI" {
    const Crc32Iscsi = crc.Crc32Iscsi;

    try testing.expectEqual(@as(u32, 0xe3069283), Crc32Iscsi.hash("123456789"));

    var c = Crc32Iscsi.init();
    c.update("1234");
    c.update("56789");
    try testing.expectEqual(@as(u32, 0xe3069283), c.final());
}

test "CRC-32/ISO-HDLC" {
    const Crc32IsoHdlc = crc.Crc32IsoHdlc;

    try testing.expectEqual(@as(u32, 0xcbf43926), Crc32IsoHdlc.hash("123456789"));

    var c = Crc32IsoHdlc.init();
    c.update("1234");
    c.update("56789");
    try testing.expectEqual(@as(u32, 0xcbf43926), c.final());
}

test "CRC-32/JAMCRC" {
    const Crc32Jamcrc = crc.Crc32Jamcrc;

    try testing.expectEqual(@as(u32, 0x340bc6d9), Crc32Jamcrc.hash("123456789"));

    var c = Crc32Jamcrc.init();
    c.update("1234");
    c.update("56789");
    try testing.expectEqual(@as(u32, 0x340bc6d9), c.final());
}

test "CRC-32/KOOPMAN" {
    const Crc32Koopman = crc.Crc32Koopman;

    try testing.expectEqual(@as(u32, 0x2d3dd0ae), Crc32Koopman.hash("123456789"));

    var c = Crc32Koopman.init();
    c.update("1234");
    c.update("56789");
    try testing.expectEqual(@as(u32, 0x2d3dd0ae), c.final());
}

test "CRC-32/MEF" {
    const Crc32Mef = crc.Crc32Mef;

    try testing.expectEqual(@as(u32, 0xd2c22f51), Crc32Mef.hash("123456789"));

    var c = Crc32Mef.init();
    c.update("1234");
    c.update("56789");
    try testing.expectEqual(@as(u32, 0xd2c22f51), c.final());
}

test "CRC-32/MPEG-2" {
    const Crc32Mpeg2 = crc.Crc32Mpeg2;

    try testing.expectEqual(@as(u32, 0x0376e6e7), Crc32Mpeg2.hash("123456789"));

    var c = Crc32Mpeg2.init();
    c.update("1234");
    c.update("56789");
    try testing.expectEqual(@as(u32, 0x0376e6e7), c.final());
}

test "CRC-32/XFER" {
    const Crc32Xfer = crc.Crc32Xfer;

    try testing.expectEqual(@as(u32, 0xbd0be338), Crc32Xfer.hash("123456789"));

    var c = Crc32Xfer.init();
    c.update("1234");
    c.update("56789");
    try testing.expectEqual(@as(u32, 0xbd0be338), c.final());
}

test "CRC-40/GSM" {
    const Crc40Gsm = crc.Crc40Gsm;

    try testing.expectEqual(@as(u40, 0xd4164fc646), Crc40Gsm.hash("123456789"));

    var c = Crc40Gsm.init();
    c.update("1234");
    c.update("56789");
    try testing.expectEqual(@as(u40, 0xd4164fc646), c.final());
}

test "CRC-64/ECMA-182" {
    const Crc64Ecma182 = crc.Crc64Ecma182;

    try testing.expectEqual(@as(u64, 0x6c40df5f0b497347), Crc64Ecma182.hash("123456789"));

    var c = Crc64Ecma182.init();
    c.update("1234");
    c.update("56789");
    try testing.expectEqual(@as(u64, 0x6c40df5f0b497347), c.final());
}

test "CRC-64/GO-ISO" {
    const Crc64GoIso = crc.Crc64GoIso;

    try testing.expectEqual(@as(u64, 0xb90956c775a41001), Crc64GoIso.hash("123456789"));

    var c = Crc64GoIso.init();
    c.update("1234");
    c.update("56789");
    try testing.expectEqual(@as(u64, 0xb90956c775a41001), c.final());
}

test "CRC-64/MS" {
    const Crc64Ms = crc.Crc64Ms;

    try testing.expectEqual(@as(u64, 0x75d4b74f024eceea), Crc64Ms.hash("123456789"));

    var c = Crc64Ms.init();
    c.update("1234");
    c.update("56789");
    try testing.expectEqual(@as(u64, 0x75d4b74f024eceea), c.final());
}

test "CRC-64/REDIS" {
    const Crc64Redis = crc.Crc64Redis;

    try testing.expectEqual(@as(u64, 0xe9c6d914c4b8d9ca), Crc64Redis.hash("123456789"));

    var c = Crc64Redis.init();
    c.update("1234");
    c.update("56789");
    try testing.expectEqual(@as(u64, 0xe9c6d914c4b8d9ca), c.final());
}

test "CRC-64/WE" {
    const Crc64We = crc.Crc64We;

    try testing.expectEqual(@as(u64, 0x62ec59e3f1a4f00a), Crc64We.hash("123456789"));

    var c = Crc64We.init();
    c.update("1234");
    c.update("56789");
    try testing.expectEqual(@as(u64, 0x62ec59e3f1a4f00a), c.final());
}

test "CRC-64/XZ" {
    const Crc64Xz = crc.Crc64Xz;

    try testing.expectEqual(@as(u64, 0x995dc9bbdf1939fa), Crc64Xz.hash("123456789"));

    var c = Crc64Xz.init();
    c.update("1234");
    c.update("56789");
    try testing.expectEqual(@as(u64, 0x995dc9bbdf1939fa), c.final());
}

test "CRC-82/DARC" {
    const Crc82Darc = crc.Crc82Darc;

    try testing.expectEqual(@as(u82, 0x09ea83f625023801fd612), Crc82Darc.hash("123456789"));

    var c = Crc82Darc.init();
    c.update("1234");
    c.update("56789");
    try testing.expectEqual(@as(u82, 0x09ea83f625023801fd612), c.final());
}
