/*
 * Decompiled with CFR 0.152.
 */
package spec.reporter;

import java.util.Enumeration;
import java.util.Vector;
import spec.reporter.TextBlock;

public class TextColumn {
    static final String COPYRIGHT = "SPECjbb2005,Copyright (c) 2000-2005 Standard Performance Evaluation Corporation (SPEC),All rights reserved,Copyright (c) 2000-2005 Hewlett-Packard,All rights reserved,Copyright (c) 1997-2005 Sun Microsystems, Inc.All rights reserved,Licensed Materials - Property of SPEC";
    private static final char NL = '\r';
    private static final String columnSeparator = " | ";
    private Vector<TextBlock> blocks = new Vector();
    private int width;

    public TextColumn(int n) {
        this.width = n;
    }

    public TextColumn(int n, String string) {
        this(n);
        this.add(string);
    }

    public static void main(String[] stringArray) {
        int n = 40;
        if (stringArray.length > 0) {
            try {
                n = Integer.parseInt(stringArray[0]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        TextColumn textColumn = new TextColumn(n);
        textColumn.add("Now is the time for all good men to come to the aid of their country");
        textColumn.add("Mary had a little lamb. Its fleece was white as snow.");
        textColumn.add("A veryverylongwordalmomstlikeaGermanwordinlength added here");
        System.out.println("*** left");
        System.out.println(textColumn.toString());
        TextColumn textColumn2 = new TextColumn(20);
        textColumn2.add("The quick brown fox jumped over the lazy white dog.");
        textColumn2.add("She sells sea shells by the sea shore.");
        System.out.println("*** right");
        System.out.println(textColumn2.toString());
        TextColumn textColumn3 = textColumn.join(textColumn2);
        System.out.println("*** together");
        System.out.println(textColumn3.toString());
    }

    public void add(String string) {
        this.blocks.addElement(new TextBlock(this.width, string));
    }

    public TextColumn join(TextColumn textColumn) {
        return this.join(textColumn, columnSeparator);
    }

    public TextColumn join(TextColumn textColumn, String string) {
        int n = this.size();
        int n2 = textColumn.size();
        int n3 = Math.min(n, n2);
        TextColumn textColumn2 = new TextColumn(this.width + string.length() + textColumn.width);
        for (int i = 0; i < n3; ++i) {
            textColumn2.blocks.addElement(this.blocks.elementAt(i).join(textColumn.blocks.elementAt(i), string));
        }
        if (n < n2) {
            TextBlock textBlock = new TextBlock(this.width);
            for (int i = n3; i < n2; ++i) {
                textColumn2.blocks.addElement(textBlock.join(textColumn.blocks.elementAt(i), string));
            }
        } else {
            TextBlock textBlock = new TextBlock(textColumn.width);
            for (int i = n3; i < n; ++i) {
                textColumn2.blocks.addElement(this.blocks.elementAt(i).join(textBlock, string));
            }
        }
        return textColumn2;
    }

    public TextBlock merge() {
        TextBlock textBlock = new TextBlock(this.width);
        Enumeration<TextBlock> enumeration = this.blocks.elements();
        while (enumeration.hasMoreElements()) {
            textBlock.add(enumeration.nextElement());
        }
        return textBlock;
    }

    public int size() {
        return this.blocks.size();
    }

    public String toString() {
        return this.merge().toString();
    }
}

