---
myst:
  html_meta:
    keywords: LaTeX, domaines spécialisés, mathématiques, structures, 
              opérateurs, faire disparaître un opérateur, 
              simplifier une équation, \phantom et espacement, 
              \phantom et alignement, classes de symboles mathématiques
---

# Comment masquer un opérateur dans une expression mathématique ?

La commande `\phantom` permet de masquer du texte, tout en disposant le reste
du document comme si le texte masqué occupait normalement sa place 
(les traits rouges aident à visualiser les alignements) :

```
\documentclass[12pt]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{tikz}

\begin{document}
Le chat\tikz[overlay]\draw[red] (0pt,1.5ex) -- ++(0ex,-5ex); du 
Cheshire \tikz[overlay]\draw[red] (0pt,1.5ex) -- ++(0ex,-5ex);est 
dans l'arbre.

Le chat \phantom{du Cheshire} est dans l'arbre.
\end{document}
```

La question "[](/3_composition/texte/boites/exploiter_les_fantomes)" détaille
un peu plus ce sujet.


## Cas des opérateurs mathématiques

Cependant, si vous essayez cette technique avec des opérateurs mathématiques,
vous obtiendrez un résultat décevant :

```
\documentclass[12pt]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page

\begin{document}
  $ aa = bb $

  $ aa \phantom{=} bb $

\medskip
ou
\medskip

  $ x = a + b $

  $ x = a \phantom{=} b $
\end{document}
```

En effet, à l'intérieur de `\phantom`, les opérateurs `=` et `+` n'ont pas 
leurs propriétés de "relation" ou d’"opérateur binaire" (respectivement).
Vous pouvez les leur restaurer de deux façons :


### Avec les commandes `\mathrel` et `\mathbin`

Cette première méthode utilise `\mathrel` et `\mathbin` pour forcer la classe 
des opérateurs :

```
\documentclass[12pt]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{tikz}

\begin{document}
$ aa = bb $

$ aa\tikz[overlay]\draw[red] (0pt,4.5ex) -- ++(0ex,-5ex); %
\mathrel{\phantom{=}} \tikz[overlay]\draw[red] (0pt,4.5ex) -- ++(0ex,-5ex);%
bb $

\bigskip

$ x = a + b $

$ x = a\tikz[overlay]\draw[red] (0pt,4.5ex) -- ++(0ex,-5ex); %
\mathbin{\phantom{+}} \tikz[overlay]\draw[red] (0pt,4.5ex) -- ++(0ex,-5ex);b $
\end{document}
```


### Avec un forçage manuel

Vous pouvez forcer manuellement un contexte de relation ou d'opérateur binaire
avec des termes vides, `{}`, pour que LaTeX identifie correctement la classe 
des symboles en question :

```
\documentclass[12pt]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{tikz}

\begin{document}
$ aa = bb $

$ aa\tikz[overlay]\draw[red] (0pt,4.5ex) -- ++(0ex,-5ex); %
\phantom{{}={}} \tikz[overlay]\draw[red] (0pt,4.5ex) -- ++(0ex,-5ex);bb $

\bigskip

$ x = a + b $

$ x = a\tikz[overlay]\draw[red] (0pt,4.5ex) -- ++(0ex,-5ex); %
\phantom{{}+{}} \tikz[overlay]\draw[red] (0pt,4.5ex) -- ++(0ex,-5ex);b $
\end{document}
```


:::{seealso}
La question 
"[](/4_domaines_specialises/mathematiques/structures/delimiteurs/masquer_des_parentheses)"
illustre un autre cas courant en mathématiques.
:::


:::{sources}
- [\[gut\] `\phantom{=}` en mode mathématique](https://groups.google.com/g/gut_fr/c/jyZGu8OECMQ/m/HLodbWoQAgAJ)
- [Phantom width of binary operator](https://tex.stackexchange.com/q/28075),
  sur [Tex Stack Exchange](https://tex.stackexchange.com/)
:::