---
myst:
  html_meta:
    keywords: LaTeX, composition, texte, renvois, références croisées
---

# Comment obtenir un renvoi à une page ?

## Avec les commandes de base

La commande `\pageref{⟨nom⟩}` permet de renvoyer à la page 
où a été exécutée la commande `\label{⟨nom⟩}` contenant l'étiquette `⟨nom⟩` correspondante.


## Avec l'extension <ctanpkg:varioref>

L'extension <ctanpkg:varioref> permet, lorsqu'on fait référence à la page courante ou à une de ses voisines, 
de modifier le style de citation, pour obtenir, par exemple, "à la page suivante". 
Il faut préciser la langue voulue (par exemple, `[french]`) en argument optionnel de `\usepackage`, 
au moment de charger <ctanpkg:varioref> 
(ou, comme dans l'exemple suivant, dans l'argument optionnel de la classe). 
En voici un exemple :

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{varioref}

\begin{document}
Remplir la table~\ref{tbl-add}~\vpageref{tbl-add}
\begin{table}[htbp]
  \centering
  \begin{tabular}{c|c}
    \hline
    Question & Réponse  \\
    \hline
    1 + 12 & \\
    45 + 76 & \\
  \end{tabular}
  \caption{Additions. \label{tbl-add}}
\end{table}
\end{document}
```