"""This module contains prewritten code for the computation
of the geometry mapping to the reference cell."""

# Copyright (C) 2007 Martin Sandve Alnes and Simula Resarch Laboratory
#
# This file is part of SyFi.
#
# SyFi is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 2 of the License, or
# (at your option) any later version.
#
# SyFi is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with SyFi. If not, see <http://www.gnu.org/licenses/>.
#
# First added:  2007-05-28
# Last changed: 2007-05-28

geometry_string1d = """\
// coordinates
double x0 = c.coordinates[0][0]; 
double x1 = c.coordinates[1][0];

// affine map
double G00 = x1 - x0;
"""

detG_string1d = """\
double detG_tmp = G00;
double detG = fabs(detG_tmp);
"""

GinvT_string1d = """\
double GinvT00 =  1.0 / G00;  
"""



geometry_string2d = """\
// coordinates
double x0 = c.coordinates[0][0]; double y0 = c.coordinates[0][1];
double x1 = c.coordinates[1][0]; double y1 = c.coordinates[1][1];
double x2 = c.coordinates[2][0]; double y2 = c.coordinates[2][1];

// affine map
double G00 = x1 - x0;
double G01 = x2 - x0;

double G10 = y1 - y0;
double G11 = y2 - y0;
"""

detG_string2d = """\
double detG_tmp = G00*G11-G01*G10;
double detG = fabs(detG_tmp);
"""

GinvT_string2d = """\
double GinvT00 =  G11 / detG_tmp;
double GinvT01 = -G10 / detG_tmp;
double GinvT10 = -G01 / detG_tmp;
double GinvT11 =  G00 / detG_tmp;
"""


geometry_string3d = """\
// coordinates
double x0 = c.coordinates[0][0]; double y0 = c.coordinates[0][1]; double z0 = c.coordinates[0][2];
double x1 = c.coordinates[1][0]; double y1 = c.coordinates[1][1]; double z1 = c.coordinates[1][2];
double x2 = c.coordinates[2][0]; double y2 = c.coordinates[2][1]; double z2 = c.coordinates[2][2];
double x3 = c.coordinates[3][0]; double y3 = c.coordinates[3][1]; double z3 = c.coordinates[3][2];

// affine map
double G00 = x1 - x0;
double G10 = y1 - y0;
double G20 = z1 - z0;

double G01 = x2 - x0;
double G11 = y2 - y0;
double G21 = z2 - z0;

double G02 = x3 - x0;
double G12 = y3 - y0;
double G22 = z3 - z0;
"""

detG_string3d = """\
double detG_tmp =    G00*(G11*G22-G21*G12)
                   - G01*(G10*G22-G20*G12)
                   + G02*(G10*G21-G20*G11);
double detG = fabs(detG_tmp);
"""

# TODO: this can be optimized further, f.ex. G11*G22 occurs both below and in detG
# TODO: write this in symbolic form
GinvT_string3d = """\
double GinvT00 = ( G11*G22-G12*G21) / detG_tmp;
double GinvT01 = (-G22*G10+G12*G20) / detG_tmp;
double GinvT02 = (-G11*G20+G10*G21) / detG_tmp;
double GinvT10 = ( G02*G21-G22*G01) / detG_tmp;
double GinvT11 = ( G22*G00-G02*G20) / detG_tmp;
double GinvT12 = (-G21*G00+G20*G01) / detG_tmp;
double GinvT20 = ( G12*G01-G11*G02) / detG_tmp;
double GinvT21 = ( G10*G02-G12*G00) / detG_tmp;
double GinvT22 = ( G11*G00-G10*G01) / detG_tmp;
"""

def gen_geometry_code(nsd, detG=True, GinvT=False):
    if nsd != 1 and nsd != 2 and nsd != 3:
        raise RuntimeError("gen_geometry_code not implemented for nsd != 1, 2 or 3")
    code = eval("geometry_string%dd" % nsd)
    if GinvT or detG:
        code += "\n" + eval("detG_string%dd" % nsd)
    if GinvT:
        code += "\n" + eval("GinvT_string%dd" % nsd) # TODO: use GinvT_string(nsd) instead after verification
    return code + "\n"



def GinvT_string(nsd): # TODO: verify and use this above
    from sfc.CodeFormatter import gen_token_assignments
    from sfc.symbol_factory import symbolic_matrix
    G_sym     = symbolic_matrix(nsd, nsd, "G")
    GinvT_sym = symbolic_matrix(nsd, nsd, "GinvT")
    GinvT     = G_sym.inverse().transpose()
    code      = gen_token_assignments( [( GinvT_sym[i], GinvT[i] ) for i in range(nsd**2) ] )
    return code



if __name__ == '__main__':
    print GinvT_string(2)
    print "\n\n"
    print gen_geometry_code(2, True, True)

