/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 2.0.11
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.simgrid.surf;

/**
  * A component (e.g., Cpu, Network, Storage, ...) is composed of three classes:
  * <ul>
  *  <li> Model: It handle the interactions between resoucses and actions</li>
  *  <li> Resource: A resource used by the model (e.g., a cpu, a network link)</li>
  *  <li> Action: An action generated by the resources (e.g., execution, communication)</li>
  * </ul>
  * @see Resource
  * @see Action
  */
public class Model {
  private long swigCPtr;
  protected boolean swigCMemOwn;

  protected Model(long cPtr, boolean cMemoryOwn) {
    swigCMemOwn = cMemoryOwn;
    swigCPtr = cPtr;
  }

  protected static long getCPtr(Model obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected void finalize() {
    delete();
  }

  public synchronized void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SurfJNI.delete_Model(swigCPtr);
      }
      swigCPtr = 0;
    }
  }

  
  /**
    * @return The name of the model
    */
  public String getName() {
    return SurfJNI.Model_getName(swigCPtr, this);
  }

  
  /**
    * Share the resources between the actions
    * @param now the current time
    * @return the date of the next action of the model will finish
    */
  public double shareResources(double now) {
    return SurfJNI.Model_shareResources(swigCPtr, this, now);
  }

  public double shareResourcesLazy(double now) {
    return SurfJNI.Model_shareResourcesLazy(swigCPtr, this, now);
  }

  public double shareResourcesFull(double now) {
    return SurfJNI.Model_shareResourcesFull(swigCPtr, this, now);
  }

  
  /**
    * Update time of actions and eventually their states
    * @param now the new current time
    * @param delta the delta between previous and new current time
    */
  public void updateActionsState(double now, double delta) {
    SurfJNI.Model_updateActionsState(swigCPtr, this, now, delta);
  }

  public void updateActionsStateLazy(double now, double delta) {
    SurfJNI.Model_updateActionsStateLazy(swigCPtr, this, now, delta);
  }

  public void updateActionsStateFull(double now, double delta) {
    SurfJNI.Model_updateActionsStateFull(swigCPtr, this, now, delta);
  }

  
  /**
    * Get the List of running Actions
    */
  public ActionList getRunningActionSet() {
    long cPtr = SurfJNI.Model_getRunningActionSet(swigCPtr, this);
    return (cPtr == 0) ? null : new ActionList(cPtr, false);
  }

  public void addTraces() {
    SurfJNI.Model_addTraces(swigCPtr, this);
  }

}
