#!/bin/bash
# bbou@ac-toulouse.fr
# 2007-05-22 16:30:22 
# _test-dns.sh

### P A R A M S

MYVERBOSE=
if [ "$1" = "-v" ]; then
	MYVERBOSE="True"
	shift
fi
MYDNS="$1"
MYDC="$2"

### I N C L U D E

. ./_include.sh

### S T A R T

function resolveDns()
{
	output=`host "$1" 2> /dev/null | grep -v '^;;' | grep -v 'not found'`
	if [ "${output}" != "" ];then
		echo ${output}
		return 0
	fi
	return 1
}

function resolveResource()
{
	result=`host -t srv "$1." 2> /dev/null| grep -v '^;;' | grep -v 'not found'`
	if [ "${result}" != "" ];then
		echo ${result}
		return 0
	fi
	return 1
}

echo "--------------------------------------------------------------------------------"
echo "DNS TEST"
echo "--------------------------------------------------------------------------------"

echo "+CHECK DOMAIN CONTROLLER IS DNS-RESOLVABLE"
echo "+fqdn"
fqdn=`hostname -f`
echo ${fqdn}
dn=`echo ${fqdn} | sed 's/^[^\.]*\.//'`
if [ "${dn}" != "${MYDNS}" ]; then
	echo "dns: hostname ${fqdn} not in domain ${MYDNS}" >&2
fi
echo "+resolve ${MYDC}"
resolveDns ${MYDC}
if [ "$?" != "0" ]; then
	echo "dns: unresolved host ${MYDC} through dns" >&2
	result=1
fi
echo "+resolve ${MYDC}.${MYDNS} through dns"
resolveDns ${MYDC}.${MYDNS}
if [ "$?" != "0" ]; then
	echo "dns: unresolved host ${MYDC}.${MYDNS}" >&2
	result=1
fi

echo "+QUERY DNS FOR ${MYDNS} RESOURCES"
if [ "${MYDNS}" == "" ]; then
	echo "no dns domain"
	exit 1
fi

services="\
_kerberos._tcp \
_kpasswd._tcp \
_kerberos._udp \
_kpasswd._udp \
_kerberos._tcp.dc._msdcs \
_ldap._tcp.dc._msdcs \
_ldap._tcp.pdc._msdcs \
_ldap._tcp.gc._msdcs \
_ldap._tcp \
_gc._tcp"

for i in ${services}; do
	echo "+get ${i}.${MYDNS}"
	resolveResource "${i}.${MYDNS}"
	if [ "$?" != "0" ]; then
		echo "failed to get resource ${i}.${MYDNS}" >&2
	else
		echo "ok"
	fi
done

echo "WARNING :avahi daemon may interfere with name resolution."
echo "         It is advisable to shut it down, if tests fail."
echo "         avahi-daemon will be disabled."

