#!/bin/bash
# bbou@ac-toulouse.fr
# 2007-05-22 16:30:10 
# _check-conf.sh

### P A R A M S

if [ "$1" = "-v" ]; then
	MYVERBOSE="True"
	shift
fi
MYREALM="$1"

### I N C L U D E

. ./_include.sh

### C H E C K E D   F I L E S

krb5conffile="krb5.conf"
pamfiles="${PAMSERVICES}"

### S T A R T 

# Kerberos
echo "+KRB CONF"
conffiles="${krb5conffile}"
for f in ${conffiles}; do
	if [ -f ${ETCDIR}/${f} ]; then
		[ -z "${MYVERBOSE}" ] || echo "${ETCDIR}/${f} OK (exists)"
	else
		echo "![FAIL] ${ETCDIR}/${f} does not exist" >&2
	fi
done

krbconf=`cat ${ETCDIR}/${krb5conffile}`
# match realm within [realms] section = before next opening [
if expr match "${krbconf}" ".*\[realms\][^[]*${MYREALM}.*" > /dev/null; then
	[ -z "${MYVERBOSE}" ] || echo "${ETCDIR}/${krb5conffile} refers to realm ${MYREALM}"
else
	echo "![FAIL] ${ETCDIR}/${krb5conffile} does not refer to realm ${MYREALM}" >&2
fi

# NSS
echo "+NSS CONF"
grep -s winbind ${ETCDIR}/nsswitch.conf > /dev/null
if [ "$?" == "0" ]; then
	[ -z "${MYVERBOSE}" ] || echo "${ETCDIR}/nsswitch.conf OK (refers to winbind)"
else
	echo "![FAIL] ${ETCDIR}/nsswitch.conf does not refer to winbind" >&2
fi

# PAM
echo "+PAM"
conffiles="${pamfiles}"
for f in ${conffiles}; do
	if [ -f "${PAMDIR}/${f}" ]; then
		[ -z "${MYVERBOSE}" ] || echo "${PAMDIR}/${f} OK (exists)"
	else
		echo "![FAIL-PAM ONLY] ${PAMDIR}/${f} does not exist"
	fi
done
case ${DISTRIBUTION} in
	Redhat|Fedora|Mandriva|Suse)
		for f in ${conffiles}; do
			if [ ! -f "${PAMDIR}/${f}" ]; then
				continue
			fi
			for m in winbind mount mkhomedir; do
				grep -s "${m}" "${PAMDIR}/${f}" > /dev/null
				if [ "$?" == "0" ]; then
				[ -z "${MYVERBOSE}" ] || echo "${PAMDIR}/${f} OK (refers to pam_${m})"
				else
					echo "![FAIL-PAM ONLY] ${PAMDIR}/${f} does not refer to pam_${m}"
				fi
			done
		done
		;;
	Debian|Ubuntu)
		for f in ${conffiles}; do
			if [ ! -f "${PAMDIR}/${f}" ]; then
				continue
			fi
			case "${f}" in
				"common-auth")
					for m in winbind mount; do
						grep -s "${m}" "${PAMDIR}/${f}" > /dev/null
						if [ "$?" == "0" ]; then
							[ -z "${MYVERBOSE}" ] || echo "${PAMDIR}/${f} OK (refers to pam_${m})"
						else
							echo "![FAIL-PAM ONLY] ${PAMDIR}/${f} does not refer to pam_${m}"
						fi
					done
					;;
				"common-account")
					for m in winbind; do
						grep -s "${m}" "${PAMDIR}/${f}" > /dev/null
						if [ "$?" == "0" ]; then
							[ -z "${MYVERBOSE}" ] || echo "${PAMDIR}/${f} OK (refers to pam_${m})"
						else
							echo "![FAIL-PAM ONLY] ${PAMDIR}/${f} does not refer to pam_${m}"
						fi
					done
					;;
				"common-password")
					for m in winbind; do
						grep -s "${m}" "${PAMDIR}/${f}" > /dev/null
						if [ "$?" == "0" ]; then
							[ -z "${MYVERBOSE}" ] || echo "${PAMDIR}/${f} OK (refers to pam_${m})"
						else
							echo "![FAIL-PAM ONLY] ${PAMDIR}/${f} does not refer to pam_${m}"
						fi
					done
					;;
				"common-session")
					for m in mount mkhomedir; do
						grep -s "${m}" "${PAMDIR}/${f}" > /dev/null
						if [ "$?" == "0" ]; then
							[ -z "${MYVERBOSE}" ] || echo "${PAMDIR}/${f} OK (refers to pam_${m})"
						else
							echo "![FAIL-PAM ONLY] ${PAMDIR}/${f} does not refer to pam_${m}"
						fi
					done
					;;
			esac
		done
		;;
	*)
		echo "Unsupported distribution" >&2
		exit 1
esac
