# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.security.aio import SecurityCenter

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestSecurityCenterAPICollectionsOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(SecurityCenter, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_api_collections_list_by_subscription(self, resource_group):
        response = self.client.api_collections.list_by_subscription(
            api_version="2023-11-15",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_api_collections_list_by_resource_group(self, resource_group):
        response = self.client.api_collections.list_by_resource_group(
            resource_group_name=resource_group.name,
            api_version="2023-11-15",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_api_collections_list_by_azure_api_management_service(self, resource_group):
        response = self.client.api_collections.list_by_azure_api_management_service(
            resource_group_name=resource_group.name,
            service_name="str",
            api_version="2023-11-15",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_api_collections_get_by_azure_api_management_service(self, resource_group):
        response = await self.client.api_collections.get_by_azure_api_management_service(
            resource_group_name=resource_group.name,
            service_name="str",
            api_id="str",
            api_version="2023-11-15",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_api_collections_begin_onboard_azure_api_management_api(self, resource_group):
        response = await (
            await self.client.api_collections.begin_onboard_azure_api_management_api(
                resource_group_name=resource_group.name,
                service_name="str",
                api_id="str",
                api_version="2023-11-15",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_api_collections_offboard_azure_api_management_api(self, resource_group):
        response = await self.client.api_collections.offboard_azure_api_management_api(
            resource_group_name=resource_group.name,
            service_name="str",
            api_id="str",
            api_version="2023-11-15",
        )

        # please add some check logic here by yourself
        # ...
