/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef FamilyObject_H
#define FamilyObject_H

#include "StandardObject.h"

#include <map>
#include <string>
using std::map;
using std::string;

class FamilyScanner;

class FamilyObject : public StandardObject
{
public:
    FamilyObject(Folder* parent, const IconClass& kind, const string& name,
                 IconInfo* info);
    virtual ~FamilyObject();

private:
    // No copy allowed
    FamilyObject(const FamilyObject&);
    FamilyObject& operator=(const FamilyObject&);

    FamilyScanner& scanner_;

    Request first() const;
    Request second() const;
    string keyword() const;

    virtual Request request() const;
    virtual void request(const Request&);
    virtual Request requestForVerb(const string&) const;

    virtual const IconClass& editorClass() const;
    virtual const IconClass& iconClass() const;
};

inline void destroy(FamilyObject**) {}

#endif
