//===-- lldb-loongarch-register-enums.h -------------------------*- C++ -*-===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef LLDB_SOURCE_PLUGINS_PROCESS_UTILITY_LLDB_LOONGARCH_REGISTER_ENUMS_H
#define LLDB_SOURCE_PLUGINS_PROCESS_UTILITY_LLDB_LOONGARCH_REGISTER_ENUMS_H

// LLDB register codes (e.g. RegisterKind == eRegisterKindLLDB)

// Internal codes for all loongarch registers.
enum {
  // The same order as user_regs_struct in <asm/ptrace.h>
  // note: these enum values are used as byte_offset
  gpr_first_loongarch = 0,
  gpr_r0_loongarch = gpr_first_loongarch,
  gpr_r1_loongarch,
  gpr_r2_loongarch,
  gpr_r3_loongarch,
  gpr_r4_loongarch,
  gpr_r5_loongarch,
  gpr_r6_loongarch,
  gpr_r7_loongarch,
  gpr_r8_loongarch,
  gpr_r9_loongarch,
  gpr_r10_loongarch,
  gpr_r11_loongarch,
  gpr_r12_loongarch,
  gpr_r13_loongarch,
  gpr_r14_loongarch,
  gpr_r15_loongarch,
  gpr_r16_loongarch,
  gpr_r17_loongarch,
  gpr_r18_loongarch,
  gpr_r19_loongarch,
  gpr_r20_loongarch,
  gpr_r21_loongarch,
  gpr_r22_loongarch,
  gpr_r23_loongarch,
  gpr_r24_loongarch,
  gpr_r25_loongarch,
  gpr_r26_loongarch,
  gpr_r27_loongarch,
  gpr_r28_loongarch,
  gpr_r29_loongarch,
  gpr_r30_loongarch,
  gpr_r31_loongarch,
  gpr_orig_a0_loongarch,
  gpr_pc_loongarch,
  gpr_badv_loongarch,
  gpr_reserved0_loongarch,
  gpr_reserved1_loongarch,
  gpr_reserved2_loongarch,
  gpr_reserved3_loongarch,
  gpr_reserved4_loongarch,
  gpr_reserved5_loongarch,
  gpr_reserved6_loongarch,
  gpr_reserved7_loongarch,
  gpr_reserved8_loongarch,
  gpr_reserved9_loongarch,
  gpr_last_loongarch = 44,

  gpr_zero_loongarch = gpr_r0_loongarch,
  gpr_ra_loongarch = gpr_r1_loongarch,
  gpr_tp_loongarch = gpr_r2_loongarch,
  gpr_sp_loongarch = gpr_r3_loongarch,
  gpr_a0_loongarch = gpr_r4_loongarch,
  gpr_a1_loongarch = gpr_r5_loongarch,
  gpr_a2_loongarch = gpr_r6_loongarch,
  gpr_a3_loongarch = gpr_r7_loongarch,
  gpr_a4_loongarch = gpr_r8_loongarch,
  gpr_a5_loongarch = gpr_r9_loongarch,
  gpr_a6_loongarch = gpr_r10_loongarch,
  gpr_a7_loongarch = gpr_r11_loongarch,
  gpr_t0_loongarch = gpr_r12_loongarch,
  gpr_t1_loongarch = gpr_r13_loongarch,
  gpr_t2_loongarch = gpr_r14_loongarch,
  gpr_t3_loongarch = gpr_r15_loongarch,
  gpr_t4_loongarch = gpr_r16_loongarch,
  gpr_t5_loongarch = gpr_r17_loongarch,
  gpr_t6_loongarch = gpr_r18_loongarch,
  gpr_t7_loongarch = gpr_r19_loongarch,
  gpr_t8_loongarch = gpr_r20_loongarch,
  gpr_fp_loongarch = gpr_r22_loongarch,
  gpr_s0_loongarch = gpr_r23_loongarch,
  gpr_s1_loongarch = gpr_r24_loongarch,
  gpr_s2_loongarch = gpr_r25_loongarch,
  gpr_s3_loongarch = gpr_r26_loongarch,
  gpr_s4_loongarch = gpr_r27_loongarch,
  gpr_s5_loongarch = gpr_r28_loongarch,
  gpr_s6_loongarch = gpr_r29_loongarch,
  gpr_s7_loongarch = gpr_r30_loongarch,
  gpr_s8_loongarch = gpr_r31_loongarch,

  fpr_first_loongarch = 45,
  fpr_f0_loongarch = fpr_first_loongarch,
  fpr_f1_loongarch,
  fpr_f2_loongarch,
  fpr_f3_loongarch,
  fpr_f4_loongarch,
  fpr_f5_loongarch,
  fpr_f6_loongarch,
  fpr_f7_loongarch,
  fpr_f8_loongarch,
  fpr_f9_loongarch,
  fpr_f10_loongarch,
  fpr_f11_loongarch,
  fpr_f12_loongarch,
  fpr_f13_loongarch,
  fpr_f14_loongarch,
  fpr_f15_loongarch,
  fpr_f16_loongarch,
  fpr_f17_loongarch,
  fpr_f18_loongarch,
  fpr_f19_loongarch,
  fpr_f20_loongarch,
  fpr_f21_loongarch,
  fpr_f22_loongarch,
  fpr_f23_loongarch,
  fpr_f24_loongarch,
  fpr_f25_loongarch,
  fpr_f26_loongarch,
  fpr_f27_loongarch,
  fpr_f28_loongarch,
  fpr_f29_loongarch,
  fpr_f30_loongarch,
  fpr_f31_loongarch,
  fpr_fcc0_loongarch,
  fpr_fcc1_loongarch,
  fpr_fcc2_loongarch,
  fpr_fcc3_loongarch,
  fpr_fcc4_loongarch,
  fpr_fcc5_loongarch,
  fpr_fcc6_loongarch,
  fpr_fcc7_loongarch,
  fpr_fcsr_loongarch,
  fpr_last_loongarch = fpr_fcsr_loongarch,

  fpr_fa0_loongarch = fpr_f0_loongarch,
  fpr_fa1_loongarch = fpr_f1_loongarch,
  fpr_fa2_loongarch = fpr_f2_loongarch,
  fpr_fa3_loongarch = fpr_f3_loongarch,
  fpr_fa4_loongarch = fpr_f4_loongarch,
  fpr_fa5_loongarch = fpr_f5_loongarch,
  fpr_fa6_loongarch = fpr_f6_loongarch,
  fpr_fa7_loongarch = fpr_f7_loongarch,
  fpr_ft0_loongarch = fpr_f8_loongarch,
  fpr_ft1_loongarch = fpr_f9_loongarch,
  fpr_ft2_loongarch = fpr_f10_loongarch,
  fpr_ft3_loongarch = fpr_f11_loongarch,
  fpr_ft4_loongarch = fpr_f12_loongarch,
  fpr_ft5_loongarch = fpr_f13_loongarch,
  fpr_ft6_loongarch = fpr_f14_loongarch,
  fpr_ft7_loongarch = fpr_f15_loongarch,
  fpr_ft8_loongarch = fpr_f16_loongarch,
  fpr_ft9_loongarch = fpr_f17_loongarch,
  fpr_ft10_loongarch = fpr_f18_loongarch,
  fpr_ft11_loongarch = fpr_f19_loongarch,
  fpr_ft12_loongarch = fpr_f20_loongarch,
  fpr_ft13_loongarch = fpr_f21_loongarch,
  fpr_ft14_loongarch = fpr_f22_loongarch,
  fpr_ft15_loongarch = fpr_f23_loongarch,
  fpr_fs0_loongarch = fpr_f24_loongarch,
  fpr_fs1_loongarch = fpr_f25_loongarch,
  fpr_fs2_loongarch = fpr_f26_loongarch,
  fpr_fs3_loongarch = fpr_f27_loongarch,
  fpr_fs4_loongarch = fpr_f28_loongarch,
  fpr_fs5_loongarch = fpr_f29_loongarch,
  fpr_fs6_loongarch = fpr_f30_loongarch,
  fpr_fs7_loongarch = fpr_f31_loongarch,

  lsx_first_loongarch = fpr_last_loongarch + 1,
  lsx_vr0_loongarch = lsx_first_loongarch,
  lsx_vr1_loongarch,
  lsx_vr2_loongarch,
  lsx_vr3_loongarch,
  lsx_vr4_loongarch,
  lsx_vr5_loongarch,
  lsx_vr6_loongarch,
  lsx_vr7_loongarch,
  lsx_vr8_loongarch,
  lsx_vr9_loongarch,
  lsx_vr10_loongarch,
  lsx_vr11_loongarch,
  lsx_vr12_loongarch,
  lsx_vr13_loongarch,
  lsx_vr14_loongarch,
  lsx_vr15_loongarch,
  lsx_vr16_loongarch,
  lsx_vr17_loongarch,
  lsx_vr18_loongarch,
  lsx_vr19_loongarch,
  lsx_vr20_loongarch,
  lsx_vr21_loongarch,
  lsx_vr22_loongarch,
  lsx_vr23_loongarch,
  lsx_vr24_loongarch,
  lsx_vr25_loongarch,
  lsx_vr26_loongarch,
  lsx_vr27_loongarch,
  lsx_vr28_loongarch,
  lsx_vr29_loongarch,
  lsx_vr30_loongarch,
  lsx_vr31_loongarch,
  lsx_last_loongarch = lsx_vr31_loongarch,

  lasx_first_loongarch = lsx_last_loongarch + 1,
  lasx_xr0_loongarch = lasx_first_loongarch,
  lasx_xr1_loongarch,
  lasx_xr2_loongarch,
  lasx_xr3_loongarch,
  lasx_xr4_loongarch,
  lasx_xr5_loongarch,
  lasx_xr6_loongarch,
  lasx_xr7_loongarch,
  lasx_xr8_loongarch,
  lasx_xr9_loongarch,
  lasx_xr10_loongarch,
  lasx_xr11_loongarch,
  lasx_xr12_loongarch,
  lasx_xr13_loongarch,
  lasx_xr14_loongarch,
  lasx_xr15_loongarch,
  lasx_xr16_loongarch,
  lasx_xr17_loongarch,
  lasx_xr18_loongarch,
  lasx_xr19_loongarch,
  lasx_xr20_loongarch,
  lasx_xr21_loongarch,
  lasx_xr22_loongarch,
  lasx_xr23_loongarch,
  lasx_xr24_loongarch,
  lasx_xr25_loongarch,
  lasx_xr26_loongarch,
  lasx_xr27_loongarch,
  lasx_xr28_loongarch,
  lasx_xr29_loongarch,
  lasx_xr30_loongarch,
  lasx_xr31_loongarch,
  lasx_last_loongarch = lasx_xr31_loongarch,

  k_num_registers_loongarch
};

#endif // LLDB_SOURCE_PLUGINS_PROCESS_UTILITY_LLDB_LOONGARCH_REGISTER_ENUMS_H
