; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --check-attributes --include-generated-funcs --version 2
; RUN: opt -S -passes=lowertypetests -mtriple=aarch64-unknown-linux-gnu %s | FileCheck --check-prefixes=AARCH64 %s

; Test for the jump table generation with branch protection on AArch64

target datalayout = "e-p:64:64"

@0 = private unnamed_addr constant [2 x ptr] [ptr @f, ptr @g], align 16


define void @f() !type !0 {
  ret void
}

define internal void @g() !type !0 {
  ret void
}

!0 = !{i32 0, !"typeid1"}

declare i1 @llvm.type.test(ptr %ptr, metadata %bitset) nounwind readnone

define i1 @foo(ptr %p) {
  %x = call i1 @llvm.type.test(ptr %p, metadata !"typeid1")
  ret i1 %x
}

!llvm.module.flags = !{!1}

!1 = !{i32 4, !"branch-target-enforcement", i32 1}


; AARCH64-LABEL: define hidden void @f.cfi() !type !1 {
; AARCH64-NEXT:    ret void
;
;
; AARCH64-LABEL: define internal void @g.cfi() !type !1 {
; AARCH64-NEXT:    ret void
;
;
; AARCH64-LABEL: define i1 @foo
; AARCH64-SAME: (ptr [[P:%.*]]) {
; AARCH64-NEXT:    [[TMP1:%.*]] = ptrtoint ptr [[P]] to i64
; AARCH64-NEXT:    [[TMP2:%.*]] = sub i64 [[TMP1]], ptrtoint (ptr @.cfi.jumptable to i64)
; AARCH64-NEXT:    [[TMP3:%.*]] = lshr i64 [[TMP2]], 3
; AARCH64-NEXT:    [[TMP4:%.*]] = shl i64 [[TMP2]], 61
; AARCH64-NEXT:    [[TMP5:%.*]] = or i64 [[TMP3]], [[TMP4]]
; AARCH64-NEXT:    [[TMP6:%.*]] = icmp ule i64 [[TMP5]], 1
; AARCH64-NEXT:    ret i1 [[TMP6]]
;
;
; AARCH64: Function Attrs: naked noinline
; AARCH64-LABEL: define private void @.cfi.jumptable
; AARCH64-SAME: () #[[ATTR1:[0-9]+]] align 8 {
; AARCH64-NEXT:  entry:
; AARCH64-NEXT:    call void asm sideeffect "bti c\0Ab $0\0Abti c\0Ab $1\0A", "s,s"(ptr @f.cfi, ptr @g.cfi)
; AARCH64-NEXT:    unreachable
;
