#!/bin/sh -e

# called by uscan with '--upstream-version' <version> <file>

TAR=../dfo_$1.orig.tar.gz
DIR=dfo-$1
REVISION=`echo $1 | sed -e 's/.*svn//'`
 
# checkout sources from svn
svn export -r $REVISION http://dfo.googlecode.com/svn/trunk $DIR

# clean up the upstream tarball
tar -c -z -f $TAR --exclude *.dll $DIR
rm -rf $DIR

# move to directory 'tarballs'
if [ -r .svn/deb-layout ]; then
  . .svn/deb-layout
  mv $TAR $origDir
  echo "moved $TAR to $origDir"
fi

exit 0
