from __future__ import absolute_import, division, print_function

import iotbx.pdb
import mmtbx.model
from mmtbx.building.cablam_idealization import cablam_idealization, master_phil
import sys
import libtbx.load_env

ss_1aon = """\
SHEET    1   D 3 MET A 193  PHE A 195  0
SHEET    2   D 3 THR A 330  ILE A 332 -1  N  ILE A 332   O  MET A 193
SHEET    3   D 3 VAL A 323  ILE A 325 -1  N  VAL A 324   O  THR A 331
"""

ss_phenix = """\
SHEET    1   C 2 VAL A 323  ASN A 326  0
SHEET    2   C 2 THR A 329  ILE A 332 -1  O  THR A 331   N  VAL A 324
"""

pdb_str = """\
CRYST1  100.000  100.000  100.000  90.00  90.00  90.00 P 1
ATOM   1361  N   VAL A 190     180.789 103.980  72.202  1.00121.81           N
ATOM   1362  CA  VAL A 190     179.994 104.660  71.186  1.00133.83           C
ATOM   1363  C   VAL A 190     180.110 106.158  71.432  1.00156.81           C
ATOM   1364  O   VAL A 190     180.495 106.598  72.517  1.00196.34           O
ATOM   1365  CB  VAL A 190     178.524 104.204  71.198  1.00 96.01           C
ATOM   1366  CG1 VAL A 190     177.849 104.682  72.446  1.00118.41           C
ATOM   1367  CG2 VAL A 190     177.794 104.682  69.960  1.00 96.01           C
ATOM   1368  N   GLU A 191     179.779 106.947  70.414  1.00168.27           N
ATOM   1369  CA  GLU A 191     180.167 108.351  70.413  1.00180.29           C
ATOM   1370  C   GLU A 191     179.043 109.249  70.910  1.00152.32           C
ATOM   1371  O   GLU A 191     178.000 109.369  70.267  1.00152.32           O
ATOM   1372  CB  GLU A 191     180.583 108.775  69.010  1.00214.56           C
ATOM   1373  CG  GLU A 191     181.784 108.024  68.439  1.00248.72           C
ATOM   1374  CD  GLU A 191     183.031 108.128  69.299  1.00239.34           C
ATOM   1375  OE1 GLU A 191     183.268 109.204  69.893  1.00224.38           O
ATOM   1376  OE2 GLU A 191     183.785 107.132  69.366  1.00218.48           O
ATOM   1377  N   GLY A 192     179.283 109.909  72.039  1.00190.08           N
ATOM   1378  CA  GLY A 192     178.378 110.877  72.631  1.00151.92           C
ATOM   1379  C   GLY A 192     179.177 111.867  73.451  1.00151.92           C
ATOM   1380  O   GLY A 192     180.405 111.763  73.491  1.00173.70           O
ATOM   1381  N   MET A 193     178.533 112.823  74.114  1.00141.34           N
ATOM   1382  CA  MET A 193     179.325 113.903  74.691  1.00144.10           C
ATOM   1383  C   MET A 193     179.366 113.927  76.210  1.00173.20           C
ATOM   1384  O   MET A 193     180.456 113.878  76.786  1.00176.78           O
ATOM   1385  CB  MET A 193     178.856 115.262  74.186  1.00193.39           C
ATOM   1386  CG  MET A 193     179.696 116.389  74.760  1.00195.75           C
ATOM   1387  SD  MET A 193     179.453 117.985  73.974  1.00281.89           S
ATOM   1388  CE  MET A 193     180.418 117.738  72.488  1.00157.97           C
ATOM   1389  N   GLN A 194     178.210 114.050  76.862  1.00187.33           N
ATOM   1390  CA  GLN A 194     178.165 114.307  78.300  1.00191.17           C
ATOM   1391  C   GLN A 194     178.790 115.645  78.661  1.00149.29           C
ATOM   1392  O   GLN A 194     179.935 115.711  79.113  1.00149.29           O
ATOM   1393  CB  GLN A 194     178.859 113.193  79.090  1.00211.88           C
ATOM   1394  CG  GLN A 194     178.874 113.421  80.594  1.00205.55           C
ATOM   1395  CD  GLN A 194     177.506 113.379  81.191  1.00174.59           C
ATOM   1396  OE1 GLN A 194     176.865 112.339  81.197  1.00132.86           O
ATOM   1397  NE2 GLN A 194     177.023 114.523  81.652  1.00189.30           N
ATOM   1398  N   PHE A 195     178.085 116.719  78.386  1.00125.89           N
ATOM   1399  CA  PHE A 195     178.445 118.003  78.948  1.00125.89           C
ATOM   1400  C   PHE A 195     177.667 118.197  80.242  1.00150.60           C
ATOM   1401  O   PHE A 195     177.061 117.259  80.764  1.00125.89           O
ATOM   1402  CB  PHE A 195     178.191 119.117  77.943  1.00158.30           C
ATOM   1403  CG  PHE A 195     176.761 119.286  77.577  1.00181.66           C
ATOM   1404  CD1 PHE A 195     175.980 120.214  78.231  1.00179.67           C
ATOM   1405  CD2 PHE A 195     176.191 118.520  76.582  1.00194.09           C
ATOM   1406  CE1 PHE A 195     174.663 120.388  77.890  1.00157.65           C
ATOM   1407  CE2 PHE A 195     174.866 118.685  76.241  1.00181.78           C
ATOM   1408  CZ  PHE A 195     174.101 119.618  76.897  1.00151.70           C
ATOM   1409  N   ASP A 196     177.704 119.420  80.776  1.00190.62           N
ATOM   1410  CA  ASP A 196     177.127 119.719  82.087  1.00171.67           C
ATOM   1411  C   ASP A 196     176.050 120.788  82.002  1.00158.10           C
ATOM   1412  O   ASP A 196     176.309 121.922  81.594  1.00155.93           O
ATOM   1413  CB  ASP A 196     178.182 120.170  83.080  1.00219.72           C
ATOM   1414  CG  ASP A 196     177.591 120.440  84.449  1.00192.59           C
ATOM   1415  OD1 ASP A 196     176.393 120.147  84.661  1.00175.54           O
ATOM   1416  OD2 ASP A 196     178.320 120.964  85.312  1.00205.97           O
ATOM   1417  N   ARG A 197     174.860 120.418  82.445  1.00165.07           N
ATOM   1418  CA  ARG A 197     173.754 121.323  82.706  1.00155.71           C
ATOM   1419  C   ARG A 197     172.696 120.470  83.385  1.00155.71           C
ATOM   1420  O   ARG A 197     172.934 119.301  83.688  1.00186.86           O
ATOM   1421  CB  ARG A 197     173.262 121.990  81.422  1.00126.62           C
ATOM   1422  CG  ARG A 197     172.280 123.113  81.630  1.00162.31           C
ATOM   1423  CD  ARG A 197     172.919 124.202  82.445  1.00126.62           C
ATOM   1424  NE  ARG A 197     174.099 124.734  81.779  1.00130.61           N
ATOM   1425  CZ  ARG A 197     174.882 125.674  82.293  1.00150.12           C
ATOM   1426  NH1 ARG A 197     174.599 126.197  83.475  1.00193.70           N
ATOM   1427  NH2 ARG A 197     175.941 126.099  81.621  1.00132.73           N
ATOM   2327  N   GLY A 318     169.195 115.930  63.690  1.00216.32           N
ATOM   2328  CA  GLY A 318     169.975 114.907  64.348  1.00193.16           C
ATOM   2329  C   GLY A 318     169.246 113.598  64.539  1.00197.19           C
ATOM   2330  O   GLY A 318     168.148 113.399  64.016  1.00193.16           O
ATOM   2331  N   GLN A 319     169.849 112.700  65.308  1.00184.03           N
ATOM   2332  CA  GLN A 319     169.232 111.415  65.589  1.00195.95           C
ATOM   2333  C   GLN A 319     169.246 111.137  67.080  1.00193.64           C
ATOM   2334  O   GLN A 319     168.185 111.047  67.708  1.00229.34           O
ATOM   2335  CB  GLN A 319     169.941 110.308  64.822  1.00201.09           C
ATOM   2336  CG  GLN A 319     169.719 110.407  63.336  1.00236.37           C
ATOM   2337  CD  GLN A 319     168.255 110.312  62.966  1.00254.36           C
ATOM   2338  OE1 GLN A 319     167.506 109.520  63.536  1.00280.71           O
ATOM   2339  NE2 GLN A 319     167.836 111.126  62.007  1.00220.80           N
ATOM   2340  N   ALA A 320     170.446 111.006  67.646  1.00140.99           N
ATOM   2341  CA  ALA A 320     170.595 110.942  69.090  1.00197.51           C
ATOM   2342  C   ALA A 320     169.906 109.734  69.704  1.00203.65           C
ATOM   2343  O   ALA A 320     168.789 109.863  70.203  1.00242.54           O
ATOM   2344  CB  ALA A 320     170.069 112.226  69.727  1.00240.45           C
ATOM   2345  N   LYS A 321     170.554 108.566  69.662  1.00164.18           N
ATOM   2346  CA  LYS A 321     169.963 107.306  70.104  1.00134.95           C
ATOM   2347  C   LYS A 321     169.103 107.477  71.344  1.00134.95           C
ATOM   2348  O   LYS A 321     167.904 107.194  71.302  1.00134.95           O
ATOM   2349  CB  LYS A 321     171.040 106.265  70.421  1.00145.47           C
ATOM   2350  CG  LYS A 321     171.950 105.868  69.279  1.00164.10           C
ATOM   2351  CD  LYS A 321     171.197 105.229  68.138  1.00145.47           C
ATOM   2352  CE  LYS A 321     172.173 104.777  67.070  1.00145.80           C
ATOM   2353  NZ  LYS A 321     171.487 104.149  65.918  1.00145.93           N
ATOM   2354  N   ARG A 322     169.682 107.900  72.454  1.00185.62           N
ATOM   2355  CA  ARG A 322     168.888 108.089  73.652  1.00142.57           C
ATOM   2356  C   ARG A 322     169.546 109.124  74.551  1.00128.56           C
ATOM   2357  O   ARG A 322     170.758 109.341  74.474  1.00128.56           O
ATOM   2358  CB  ARG A 322     168.719 106.769  74.369  1.00115.16           C
ATOM   2359  CG  ARG A 322     167.669 106.817  75.430  1.00133.21           C
ATOM   2360  CD  ARG A 322     167.578 105.605  76.270  1.00149.50           C
ATOM   2361  NE  ARG A 322     168.665 105.482  77.219  1.00115.16           N
ATOM   2362  CZ  ARG A 322     168.912 104.370  77.883  1.00115.16           C
ATOM   2363  NH1 ARG A 322     168.133 103.302  77.715  1.00116.90           N
ATOM   2364  NH2 ARG A 322     169.915 104.340  78.745  1.00115.16           N
ATOM   2365  N   VAL A 323     168.740 109.783  75.382  1.00121.29           N
ATOM   2366  CA  VAL A 323     169.198 110.884  76.220  1.00121.29           C
ATOM   2367  C   VAL A 323     168.668 110.712  77.632  1.00139.86           C
ATOM   2368  O   VAL A 323     167.480 110.430  77.835  1.00121.29           O
ATOM   2369  CB  VAL A 323     168.795 112.246  75.654  1.00117.56           C
ATOM   2370  CG1 VAL A 323     168.912 113.310  76.710  1.00151.93           C
ATOM   2371  CG2 VAL A 323     169.721 112.603  74.534  1.00121.07           C
ATOM   2372  N   VAL A 324     169.553 110.915  78.601  1.00186.06           N
ATOM   2373  CA  VAL A 324     169.257 110.860  80.023  1.00145.81           C
ATOM   2374  C   VAL A 324     169.680 112.181  80.632  1.00137.41           C
ATOM   2375  O   VAL A 324     170.842 112.582  80.510  1.00178.72           O
ATOM   2376  CB  VAL A 324     169.998 109.700  80.699  1.00111.15           C
ATOM   2377  CG1 VAL A 324     169.991 109.869  82.194  1.00111.15           C
ATOM   2378  CG2 VAL A 324     169.361 108.392  80.320  1.00174.59           C
ATOM   2379  N   ILE A 325     168.750 112.858  81.291  1.00135.50           N
ATOM   2380  CA  ILE A 325     169.053 114.082  82.010  1.00135.50           C
ATOM   2381  C   ILE A 325     168.433 113.999  83.385  1.00169.00           C
ATOM   2382  O   ILE A 325     167.250 113.672  83.524  1.00221.23           O
ATOM   2383  CB  ILE A 325     168.540 115.326  81.277  1.00128.37           C
ATOM   2384  CG1 ILE A 325     169.308 115.511  79.987  1.00157.49           C
ATOM   2385  CG2 ILE A 325     168.652 116.540  82.152  1.00128.37           C
ATOM   2386  CD1 ILE A 325     168.664 116.495  79.084  1.00250.18           C
ATOM   2387  N   ASN A 326     169.238 114.283  84.395  1.00199.74           N
ATOM   2388  CA  ASN A 326     168.756 114.523  85.740  1.00188.01           C
ATOM   2389  C   ASN A 326     168.984 115.989  86.024  1.00186.66           C
ATOM   2390  O   ASN A 326     169.421 116.729  85.142  1.00228.60           O
ATOM   2391  CB  ASN A 326     169.515 113.691  86.752  1.00191.53           C
ATOM   2392  CG  ASN A 326     170.974 114.019  86.751  1.00177.51           C
ATOM   2393  OD1 ASN A 326     171.477 114.588  85.789  1.00181.89           O
ATOM   2394  ND2 ASN A 326     171.662 113.699  87.832  1.00177.51           N
ATOM   2395  N   LYS A 327     168.723 116.428  87.237  1.00150.02           N
ATOM   2396  CA  LYS A 327     169.141 117.765  87.589  1.00152.41           C
ATOM   2397  C   LYS A 327     170.660 117.829  87.576  1.00183.89           C
ATOM   2398  O   LYS A 327     171.338 116.972  88.151  1.00182.77           O
ATOM   2399  CB  LYS A 327     168.573 118.168  88.941  1.00149.83           C
ATOM   2400  CG  LYS A 327     168.941 117.264  90.077  1.00149.83           C
ATOM   2401  CD  LYS A 327     168.258 117.747  91.336  1.00157.59           C
ATOM   2402  CE  LYS A 327     168.760 119.125  91.726  1.00149.83           C
ATOM   2403  NZ  LYS A 327     168.070 119.626  92.943  1.00160.60           N
ATOM   2404  N   ASP A 328     171.184 118.819  86.857  1.00218.03           N
ATOM   2405  CA  ASP A 328     172.591 119.218  86.870  1.00213.19           C
ATOM   2406  C   ASP A 328     173.533 118.188  86.255  1.00226.70           C
ATOM   2407  O   ASP A 328     174.694 118.091  86.655  1.00223.51           O
ATOM   2408  CB  ASP A 328     173.025 119.554  88.294  1.00211.95           C
ATOM   2409  CG  ASP A 328     172.325 120.779  88.820  1.00217.32           C
ATOM   2410  OD1 ASP A 328     171.820 121.567  87.993  1.00181.79           O
ATOM   2411  OD2 ASP A 328     172.246 120.937  90.055  1.00264.08           O
ATOM   2412  N   THR A 329     173.062 117.425  85.275  1.00238.65           N
ATOM   2413  CA  THR A 329     173.929 116.603  84.444  1.00191.16           C
ATOM   2414  C   THR A 329     173.151 116.297  83.171  1.00195.25           C
ATOM   2415  O   THR A 329     171.922 116.379  83.170  1.00197.03           O
ATOM   2416  CB  THR A 329     174.350 115.322  85.178  1.00198.74           C
ATOM   2417  OG1 THR A 329     174.966 115.668  86.424  1.00151.38           O
ATOM   2418  CG2 THR A 329     175.348 114.535  84.371  1.00227.62           C
ATOM   2419  N   THR A 330     173.852 115.960  82.094  1.00192.15           N
ATOM   2420  CA  THR A 330     173.180 115.643  80.843  1.00174.21           C
ATOM   2421  C   THR A 330     174.004 114.667  80.018  1.00177.58           C
ATOM   2422  O   THR A 330     175.235 114.683  80.064  1.00155.50           O
ATOM   2423  CB  THR A 330     172.912 116.904  80.037  1.00149.29           C
ATOM   2424  OG1 THR A 330     172.189 116.561  78.853  1.00196.16           O
ATOM   2425  CG2 THR A 330     174.209 117.553  79.663  1.00171.73           C
ATOM   2426  N   THR A 331     173.312 113.823  79.255  1.00154.85           N
ATOM   2427  CA  THR A 331     173.933 112.727  78.527  1.00139.34           C
ATOM   2428  C   THR A 331     173.347 112.631  77.131  1.00126.25           C
ATOM   2429  O   THR A 331     172.136 112.788  76.950  1.00126.25           O
ATOM   2430  CB  THR A 331     173.689 111.400  79.219  1.00198.41           C
ATOM   2431  OG1 THR A 331     172.286 111.139  79.199  1.00216.30           O
ATOM   2432  CG2 THR A 331     174.132 111.456  80.641  1.00185.45           C
ATOM   2433  N   ILE A 332     174.192 112.324  76.158  1.00 96.15           N
ATOM   2434  CA  ILE A 332     173.754 112.026  74.805  1.00 96.15           C
ATOM   2435  C   ILE A 332     174.531 110.821  74.318  1.00 96.15           C
ATOM   2436  O   ILE A 332     175.766 110.853  74.273  1.00 96.15           O
ATOM   2437  CB  ILE A 332     173.963 113.208  73.857  1.00 81.50           C
ATOM   2438  CG1 ILE A 332     173.003 114.333  74.196  1.00 81.50           C
ATOM   2439  CG2 ILE A 332     173.758 112.766  72.446  1.00106.08           C
ATOM   2440  CD1 ILE A 332     173.300 115.594  73.446  1.00 81.50           C
ATOM   2441  N   ILE A 333     173.817 109.784  73.902  1.00140.99           N
ATOM   2442  CA  ILE A 333     174.460 108.513  73.612  1.00146.25           C
ATOM   2443  C   ILE A 333     175.126 108.570  72.252  1.00156.54           C
ATOM   2444  O   ILE A 333     176.350 108.684  72.164  1.00137.40           O
ATOM   2445  CB  ILE A 333     173.443 107.365  73.678  1.00124.68           C
ATOM   2446  CG1 ILE A 333     172.994 107.169  75.120  1.00124.68           C
ATOM   2447  CG2 ILE A 333     174.026 106.090  73.113  1.00124.68           C
ATOM   2448  CD1 ILE A 333     171.909 106.157  75.279  1.00124.68           C
ATOM   2449  N   ASP A 334     174.337 108.493  71.187  1.00184.11           N
ATOM   2450  CA  ASP A 334     174.900 108.642  69.855  1.00191.95           C
ATOM   2451  C   ASP A 334     173.822 109.118  68.901  1.00201.36           C
ATOM   2452  O   ASP A 334     172.661 108.726  69.012  1.00169.42           O
ATOM   2453  CB  ASP A 334     175.500 107.328  69.352  1.00229.86           C
ATOM   2454  CG  ASP A 334     176.076 107.454  67.967  1.00209.90           C
ATOM   2455  OD1 ASP A 334     177.073 108.185  67.807  1.00194.49           O
ATOM   2456  OD2 ASP A 334     175.530 106.825  67.040  1.00201.57           O
ATOM   2457  N   GLY A 335     174.222 109.961  67.961  1.00230.09           N
ATOM   2458  CA  GLY A 335     173.372 110.262  66.835  1.00158.73           C
ATOM   2459  C   GLY A 335     173.912 109.583  65.604  1.00155.16           C
ATOM   2460  O   GLY A 335     175.061 109.134  65.593  1.00158.08           O
ATOM   2461  N   VAL A 336     173.117 109.523  64.548  1.00175.68           N
ATOM   2462  CA  VAL A 336     173.631 108.975  63.306  1.00190.55           C
ATOM   2463  C   VAL A 336     174.373 110.102  62.610  1.00175.68           C
ATOM   2464  O   VAL A 336     173.792 111.149  62.310  1.00178.92           O
ATOM   2465  CB  VAL A 336     172.509 108.405  62.425  1.00188.43           C
ATOM   2466  CG1 VAL A 336     173.083 107.857  61.137  1.00208.89           C
ATOM   2467  CG2 VAL A 336     171.737 107.334  63.172  1.00161.96           C
"""

def exercise_no_sidechains(prefix="tst_single_outliers_sur_no_sidechains"):
  pdb_inp = iotbx.pdb.input(lines=pdb_str.split('\n'), source_info=None)
  model = mmtbx.model.manager(
      model_input = pdb_inp)
  s = model.selection("name N or name CA or name C or name O")
  model = model.select(s)
  with open("%s_start.pdb" % prefix, 'w') as f:
    f.write(model.model_as_pdb())
  ci = cablam_idealization(model = model, params=master_phil.extract().cablam_idealization, log=sys.stdout)
  with open("%s_end.pdb" % prefix, 'w') as f:
    f.write(model.model_as_pdb())

def exercise_yes_sidechains(prefix="tst_single_outliers_sur_yes_sidechains"):
  pdb_inp = iotbx.pdb.input(lines=pdb_str.split('\n'), source_info=None)
  model = mmtbx.model.manager(
      model_input = pdb_inp)
  with open("%s_start.pdb" % prefix, 'w') as f:
    f.write(model.model_as_pdb())
  ci = cablam_idealization(model = model, params=master_phil.extract().cablam_idealization, log=sys.stdout)
  pdb_txt = model.model_as_pdb()

if __name__ == '__main__':
  if (not libtbx.env.has_module(name="probe")):
    print("Skipping: probe not configured")
  else:
    exercise_no_sidechains()
    exercise_yes_sidechains()
