#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2021 Mopi
# SPDX-FileCopyrightText: © 2023 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Doctor Who: The Lonely Assassins
# send your bug reports to bugs@dotslashplay.it
###

script_version=20250408.2

PLAYIT_COMPATIBILITY_LEVEL='2.32'

GAME_ID='doctor-who-the-lonely-assassins'
GAME_NAME='Doctor Who: The Lonely Assassins'

ARCHIVE_BASE_0_NAME='setup_doctor_who_the_lonely_assassins_1.840.127_(47861).exe'
ARCHIVE_BASE_0_MD5='102ae49769312005075e26141250b5cc'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_SIZE='1500000'
ARCHIVE_BASE_0_VERSION='1.840.127-gog47861'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/doctor_who_the_lonely_assasins'

UNITY3D_NAME='doctor who the lonely assassins'

CONTENT_PATH_DEFAULT='.'

WINE_PERSISTENT_DIRECTORIES='
users/${USER}/AppData/LocalLow/Kaigan Games/Doctor Who_ The Lonely Assassins'
## Without .NET support, the game fails to load anything after the initial splash screen.
## It seems that Mono is not enough, the .NET Framework 4.5 is required.
WINE_DLLOVERRIDES_DEFAULT='winemenubuilder.exe,mshtml='
WINE_WINETRICKS_VERBS='dotnet45'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ARCH='64'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'
PKG_BIN_DEPENDENCIES_GSTREAMER_PLUGINS='
video/quicktime, variant=(string)iso'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

working_directory_cleanup

exit 0
