/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.view2d;

import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.graph.wrapper.GraphIDProvider;
import com.paterva.maltego.ui.graph.view2d.CollectionNodeUtils;
import com.paterva.maltego.ui.graph.view2d.EditableNodeLabel;
import com.paterva.maltego.ui.graph.view2d.NodeEditHook;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import javax.swing.SwingUtilities;
import yguard.A.A.D;
import yguard.A.A.Y;
import yguard.A.J.GC;
import yguard.A.J.U;
import yguard.A.J.X;
import yguard.A.J.gB;

public class EditLabelAction
extends GC._K {
    public void startEditing(final U view, final X ylabel) {
        if (ylabel instanceof gB) {
            final gB nodeLabel = (gB)ylabel;
            this.fireEditEvent("labelEditorOpened", nodeLabel.getNode());
            ContainerAdapter containerListener = new ContainerAdapter(){

                @Override
                public void componentRemoved(ContainerEvent e2) {
                    boolean fireByCollectionNode = CollectionNodeUtils.isFiredByCollectionNode(e2);
                    if (!fireByCollectionNode) {
                        SwingUtilities.invokeLater(() -> {
                            EditLabelAction.this.fireEditEvent("labelEditorClosed", nodeLabel.getNode());
                            if (ylabel instanceof EditableNodeLabel) {
                                EditableNodeLabel editableLabel = (EditableNodeLabel)ylabel;
                                editableLabel.setEditing(false);
                            }
                        });
                        view.getCanvasComponent().removeContainerListener(this);
                    }
                }
            };
            view.getCanvasComponent().addContainerListener(containerListener);
        }
        if (ylabel instanceof EditableNodeLabel) {
            EditableNodeLabel editableLabel = (EditableNodeLabel)ylabel;
            editableLabel.setEditing(true);
            view.repaint();
        }
    }

    protected void openLabelEditor(U view, X ylabel, PropertyChangeListener pl, boolean bln) {
        this.startEditing(view, ylabel);
        super.openLabelEditor(view, ylabel, pl, bln);
    }

    private void fireEditEvent(String id, Y node) {
        Collection<? extends NodeEditHook> hooks = NodeEditHook.getAll();
        if (hooks.isEmpty()) {
            return;
        }
        D graph = node.H();
        GraphID graphID = GraphIDProvider.forGraph((D)graph);
        if (graphID != null) {
            for (NodeEditHook nodeEditHook : hooks) {
                nodeEditHook.handle(id, graphID);
            }
        }
    }
}

