/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.js.builtins.BigIntFunctionBuiltins;
import com.oracle.truffle.js.builtins.BigIntPrototypeBuiltins;
import com.oracle.truffle.js.lang.JavaScriptLanguage;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.builtins.JSBigIntObject;
import com.oracle.truffle.js.runtime.builtins.JSConstructor;
import com.oracle.truffle.js.runtime.builtins.JSConstructorFactory;
import com.oracle.truffle.js.runtime.builtins.JSPrimitive;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;

public final class JSBigInt
extends JSPrimitive
implements JSConstructorFactory.WithFunctions {
    public static final String TYPE_NAME = "bigint";
    public static final String CLASS_NAME = "BigInt";
    public static final String PROTOTYPE_NAME = "BigInt.prototype";
    public static final JSBigInt INSTANCE = new JSBigInt();

    private JSBigInt() {
    }

    public static DynamicObject create(JSContext context, JSRealm realm, BigInt value) {
        DynamicObject obj = JSBigIntObject.create(realm, context.getBigIntFactory(), value);
        assert (JSBigInt.isJSBigInt(obj));
        return context.trackAllocation(obj);
    }

    private static BigInt getBigIntegerField(DynamicObject obj) {
        assert (JSBigInt.isJSBigInt(obj));
        return ((JSBigIntObject)obj).getBigIntValue();
    }

    public static BigInt valueOf(DynamicObject obj) {
        return JSBigInt.getBigIntegerField(obj);
    }

    @Override
    public DynamicObject createPrototype(JSRealm realm, DynamicObject ctor) {
        JSContext context = realm.getContext();
        DynamicObject bigIntPrototype = JSObjectUtil.createOrdinaryPrototypeObject(realm);
        JSObjectUtil.putConstructorProperty(context, bigIntPrototype, ctor);
        JSObjectUtil.putFunctionsFromContainer(realm, bigIntPrototype, BigIntPrototypeBuiltins.BUILTINS);
        JSObjectUtil.putToStringTag(bigIntPrototype, CLASS_NAME);
        return bigIntPrototype;
    }

    @Override
    public Shape makeInitialShape(JSContext context, DynamicObject prototype) {
        Shape initialShape = JSObjectUtil.getProtoChildShape(prototype, INSTANCE, context);
        return initialShape;
    }

    public static JSConstructor createConstructor(JSRealm realm) {
        return INSTANCE.createConstructorAndPrototype(realm, BigIntFunctionBuiltins.BUILTINS);
    }

    public static boolean isJSBigInt(Object obj) {
        return obj instanceof JSBigIntObject;
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    @Override
    public String getClassName(DynamicObject object) {
        return this.getClassName();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public String toDisplayStringImpl(DynamicObject obj, int depth, boolean allowSideEffects) {
        if (JavaScriptLanguage.get(null).getJSContext().isOptionNashornCompatibilityMode()) {
            return super.toDisplayStringImpl(obj, depth, allowSideEffects);
        }
        BigInt primitiveValue = JSBigInt.valueOf(obj);
        return JSRuntime.objectToConsoleString(obj, this.getBuiltinToStringTag(obj), depth, new String[]{"PrimitiveValue"}, new Object[]{primitiveValue}, allowSideEffects);
    }

    @Override
    public DynamicObject getIntrinsicDefaultProto(JSRealm realm) {
        return realm.getBigIntPrototype();
    }
}

