/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui;

import com.paterva.maltego.util.StringUtilities;
import com.paterva.maltego.util.ui.dialog.EditDialogDescriptor;
import com.paterva.maltego.util.ui.dialog.PasswordEditController;
import java.io.IOException;
import java.util.List;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.io.ZipInputStream;
import net.lingala.zip4j.model.FileHeader;
import net.lingala.zip4j.model.ZipParameters;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Exceptions;

public class PasswordUtil {
    public static ZipParameters getZipParameters(String password) {
        ZipParameters zipParams = null;
        if (!StringUtilities.isNullOrEmpty((String)password)) {
            zipParams = new ZipParameters();
            zipParams.setCompressionMethod(8);
            zipParams.setCompressionLevel(5);
            zipParams.setEncryptFiles(true);
            zipParams.setEncryptionMethod(99);
            zipParams.setAesKeyStrength(1);
            zipParams.setPassword(password);
        }
        return zipParams;
    }

    public static String getPasswordInput(boolean retype) {
        Object pass;
        String password = null;
        PasswordEditController passwordEditor = new PasswordEditController(retype);
        EditDialogDescriptor dd = new EditDialogDescriptor("Enter File Password", passwordEditor);
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)dd) == EditDialogDescriptor.OK_OPTION && (pass = dd.getProperty("password")) instanceof String) {
            password = (String)pass;
        }
        return password;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isPasswordValid(ZipFile zipFile) throws ZipException {
        boolean passwordValid = false;
        List fileHeaders = zipFile.getFileHeaders();
        if (fileHeaders.size() > 0) {
            ZipInputStream is = null;
            try {
                is = zipFile.getInputStream((FileHeader)fileHeaders.get(0));
                passwordValid = true;
            }
            catch (ZipException ex) {
                System.out.println("Password invalid " + ex.getMessage());
            }
            finally {
                if (is != null) {
                    try {
                        is.close(true);
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            }
        }
        return passwordValid;
    }

    public static String promptForPassword(ZipFile zipFile) throws ZipException {
        String password = PasswordUtil.getPasswordInput(false);
        if (password != null) {
            zipFile.setPassword(password);
            if (PasswordUtil.isPasswordValid(zipFile)) {
                return password;
            }
            NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)"Unable to open the file because the password was entered incorrectly.");
            msg.setTitle("Incorrect Password");
            msg.setMessageType(0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
        }
        return null;
    }
}

