/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.polyglot.HostToGuestRootNode;
import com.oracle.truffle.polyglot.PolyglotContextImpl;
import com.oracle.truffle.polyglot.PolyglotEngineException;
import com.oracle.truffle.polyglot.PolyglotLanguageContext;
import java.util.concurrent.atomic.AtomicInteger;

final class PolyglotThread
extends Thread {
    private final PolyglotLanguageContext languageContext;
    PolyglotContextImpl context;
    final CallTarget callTarget;
    private static final AtomicInteger THREAD_INIT_NUMBER = new AtomicInteger(0);

    PolyglotThread(PolyglotLanguageContext languageContext, Runnable runnable, ThreadGroup group, long stackSize) {
        super(group, runnable, PolyglotThread.createDefaultName(languageContext), stackSize);
        this.languageContext = languageContext;
        this.setUncaughtExceptionHandler(languageContext.getPolyglotExceptionHandler());
        this.callTarget = ThreadSpawnRootNode.lookup(languageContext);
    }

    PolyglotThread(PolyglotLanguageContext languageContext, Runnable runnable, ThreadGroup group) {
        this(languageContext, runnable, group, 0L);
    }

    PolyglotThread(PolyglotLanguageContext languageContext, Runnable runnable) {
        this(languageContext, runnable, null, 0L);
    }

    private static String createDefaultName(PolyglotLanguageContext creator) {
        return "Polyglot-" + creator.language.getId() + "-" + THREAD_INIT_NUMBER.getAndIncrement();
    }

    boolean isOwner(PolyglotContextImpl testContext) {
        return this.languageContext.context == testContext;
    }

    @Override
    public void run() {
        this.callTarget.call(this.languageContext, this, new PolyglotThreadRunnable(){

            @Override
            @CompilerDirectives.TruffleBoundary
            public void execute() {
                PolyglotThread.super.run();
            }
        });
    }

    private static final class ThreadSpawnRootNode
    extends HostToGuestRootNode {
        ThreadSpawnRootNode(PolyglotLanguageContext languageContext) {
            super(languageContext);
        }

        @Override
        protected Class<?> getReceiverType() {
            return PolyglotThread.class;
        }

        @Override
        protected boolean needsEnter() {
            return false;
        }

        @Override
        protected boolean needsExceptionWrapping() {
            return false;
        }

        @Override
        public boolean isInternal() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        protected Object executeImpl(PolyglotLanguageContext languageContext, Object receiver, Object[] args) {
            PolyglotContextImpl prev;
            PolyglotThread thread = (PolyglotThread)receiver;
            PolyglotThreadRunnable run = (PolyglotThreadRunnable)args[2];
            try {
                prev = languageContext.enterThread(thread);
            }
            catch (PolyglotEngineException polyglotException) {
                if (polyglotException.closingContext) {
                    return null;
                }
                throw polyglotException;
            }
            assert (prev == null);
            try {
                run.execute();
            }
            finally {
                languageContext.leaveThread(prev, thread);
            }
            return null;
        }

        public static CallTarget lookup(PolyglotLanguageContext languageContext) {
            CallTarget target = ThreadSpawnRootNode.lookupHostCodeCache(languageContext, ThreadSpawnRootNode.class, CallTarget.class);
            if (target == null) {
                target = ThreadSpawnRootNode.installHostCodeCache(languageContext, ThreadSpawnRootNode.class, ThreadSpawnRootNode.createTarget(new ThreadSpawnRootNode(languageContext)), CallTarget.class);
            }
            return target;
        }
    }

    private static interface PolyglotThreadRunnable {
        public void execute();
    }
}

