/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.descriptor;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.TypedPropertyBag;
import com.paterva.maltego.graph.store.GraphStore;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.data.GraphDataStoreReader;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.transform.descriptor.Constraint;
import com.paterva.maltego.transform.descriptor.InheritedTypesProvider;
import com.paterva.maltego.transform.descriptor.TransformInputType;
import com.paterva.maltego.transform.descriptor.TransformPropertyInputType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.openide.util.Exceptions;

public class ConditionalInputConstraint
implements Constraint {
    private final TransformInputType inputType;
    private List<String> typeNames = new ArrayList<String>();
    private TransformPropertyInputType propertyConstraintsType;
    private List<String> propertyConstraints = new ArrayList<String>();

    public ConditionalInputConstraint(TransformInputType inputType) {
        this.inputType = inputType;
    }

    public ConditionalInputConstraint(TransformInputType inputType, String typeName) {
        this.inputType = inputType;
        this.typeNames.add(typeName);
    }

    public ConditionalInputConstraint(TransformInputType inputType, List<String> typeNames) {
        this.inputType = inputType;
        this.typeNames.addAll(typeNames);
    }

    public ConditionalInputConstraint(TransformInputType inputType, List<String> typeNames, TransformPropertyInputType propertyConstraintsType, List<String> propertyConstraints) {
        this.inputType = inputType;
        this.typeNames.addAll(typeNames);
        if (propertyConstraintsType != null && propertyConstraints != null) {
            this.propertyConstraintsType = propertyConstraintsType;
            this.propertyConstraints.addAll(propertyConstraints);
        }
    }

    @Override
    public boolean isSatisfiedByAny(Iterable<? extends TypedPropertyBag> entities, InheritedTypesProvider typeProvider) {
        for (TypedPropertyBag typedPropertyBag : entities) {
            if (!this.isSatisfiedByType(typedPropertyBag.getTypeName(), typeProvider) || !this.isSatisfiedByProperty(typedPropertyBag)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isSatisfiedByAny(GraphID graphID, Set<EntityID> entities, InheritedTypesProvider typeProvider) {
        try {
            Set<String> types = typeProvider.getAllInheritedTypes();
            if ((types == null || this.isSatisfiedByInheritedTypes(types)) && GraphStoreRegistry.getDefault().isExistingAndOpen(graphID)) {
                GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(graphID);
                GraphDataStoreReader dataReader = graphStore.getGraphDataStore().getDataStoreReader();
                for (EntityID entityID : entities) {
                    if (!this.isSatisfiedByAny(entityID, dataReader, typeProvider)) continue;
                    return true;
                }
            }
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return false;
    }

    @Override
    public boolean isSatisfiedByInheritedTypes(Collection<String> types) {
        if (this.typeNames.isEmpty()) {
            return true;
        }
        return types.stream().anyMatch(this.typeNames::contains);
    }

    private boolean isSatisfiedByAny(EntityID entityID, GraphDataStoreReader dataReader, InheritedTypesProvider typeProvider) throws GraphStoreException {
        MaltegoEntity entity = dataReader.getEntity(entityID);
        return this.isSatisfiedByType(entity.getTypeName(), typeProvider) && this.isSatisfiedByProperty((TypedPropertyBag)entity);
    }

    private boolean isSatisfiedByAny(MaltegoEntity entity, InheritedTypesProvider typeProvider) {
        String type = entity.getTypeName();
        return this.isSatisfiedByType(type, typeProvider);
    }

    private boolean isSatisfiedByType(String typeName, InheritedTypesProvider typeProvider) {
        if (this.typeNames.isEmpty()) {
            return true;
        }
        if (typeProvider != null) {
            List<String> types = typeProvider.getAllInheritedTypes(typeName);
            return types.stream().anyMatch(this.typeNames::contains);
        }
        return this.typeNames.contains(typeName);
    }

    private boolean isSatisfiedByPropertyAny(TypedPropertyBag entity) {
        if (entity == null) {
            return false;
        }
        if (this.propertyConstraintsType == null || this.propertyConstraints == null || this.propertyConstraints.isEmpty()) {
            return true;
        }
        for (String property : this.propertyConstraints) {
            if (entity.getProperties().get(property) == null) continue;
            return true;
        }
        return false;
    }

    private boolean isSatisfiedByPropertyAll(TypedPropertyBag entity) {
        if (entity == null) {
            return false;
        }
        if (this.propertyConstraintsType == null || this.propertyConstraints == null || this.propertyConstraints.isEmpty()) {
            return true;
        }
        for (String property : this.propertyConstraints) {
            if (entity.getProperties().get(property) != null) continue;
            return false;
        }
        return true;
    }

    private boolean isSatisfiedByProperty(TypedPropertyBag entity) {
        if (this.propertyConstraintsType == null) {
            return true;
        }
        switch (this.propertyConstraintsType) {
            case ALL: {
                return this.isSatisfiedByPropertyAll(entity);
            }
            case ANY: {
                return this.isSatisfiedByPropertyAny(entity);
            }
        }
        return true;
    }

    @Override
    public Set<EntityID> getSatisfiedBy(GraphID graphID, Set<EntityID> entities, InheritedTypesProvider typeProvider) {
        HashSet<EntityID> satisfied = new HashSet<EntityID>();
        try {
            if (GraphStoreRegistry.getDefault().isExistingAndOpen(graphID)) {
                GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(graphID);
                GraphDataStoreReader dataReader = graphStore.getGraphDataStore().getDataStoreReader();
                for (EntityID entityID : entities) {
                    if (!this.isSatisfiedByAny(entityID, dataReader, typeProvider)) continue;
                    satisfied.add(entityID);
                }
            }
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return satisfied;
    }

    @Override
    public Map<EntityID, MaltegoEntity> getSatisfiedBy(GraphID graphID, Map<EntityID, MaltegoEntity> entities, InheritedTypesProvider typeProvider) {
        HashMap<EntityID, MaltegoEntity> satisfied = new HashMap<EntityID, MaltegoEntity>();
        for (Map.Entry<EntityID, MaltegoEntity> entry : entities.entrySet()) {
            EntityID entityID = entry.getKey();
            MaltegoEntity entity = entry.getValue();
            if (!this.isSatisfiedByAny(entity, typeProvider)) continue;
            satisfied.put(entityID, entity);
        }
        return satisfied;
    }

    @Override
    public String getDisplay() {
        String entityString = null;
        String propertyString = null;
        if (!this.typeNames.isEmpty()) {
            entityString = this.typeNameToString();
        }
        if (this.propertyConstraintsType != null) {
            propertyString = this.propertyToString();
        }
        if (entityString == null && propertyString != null) {
            return String.format("%s", propertyString);
        }
        if (entityString != null && propertyString == null) {
            return String.format("%s", entityString);
        }
        if (entityString == null && propertyString == null) {
            return "Any";
        }
        return String.format("%s and %s", entityString, propertyString);
    }

    public String typeNameToString() {
        StringBuilder entityBuilder = new StringBuilder();
        for (String type : this.typeNames) {
            String formatted = type.equals("maltego.Unknown") ? "Entity[Any]" : String.format("Entity[%s]", type);
            entityBuilder.append(formatted);
            if (this.typeNames.indexOf(type) == this.typeNames.size() - 1) continue;
            entityBuilder.append(", ");
        }
        return entityBuilder.toString();
    }

    public String propertyToString() {
        StringBuilder propertyBuilder = new StringBuilder();
        switch (this.propertyConstraintsType) {
            case ALL: {
                propertyBuilder.append("All[");
                break;
            }
            case ANY: {
                propertyBuilder.append("Any[");
                break;
            }
            default: {
                propertyBuilder.append("Unknown[");
            }
        }
        for (String property : this.propertyConstraints) {
            String formatted = String.format("Property[%s]", property);
            propertyBuilder.append(formatted);
            if (this.propertyConstraints.indexOf(property) == this.propertyConstraints.size() - 1) continue;
            propertyBuilder.append(", ");
        }
        propertyBuilder.append("]");
        return propertyBuilder.toString();
    }

    public TransformInputType getInputType() {
        return this.inputType;
    }

    public List<String> getTypeNames() {
        return this.typeNames;
    }

    public void setTypeNames(List<String> typeNames) {
        this.typeNames = typeNames;
    }

    public void setPropertyConstraintsType(TransformPropertyInputType type) {
        this.propertyConstraintsType = type;
    }

    public void setPropertyConstraints(List<String> propertyConstraints) {
        this.propertyConstraints = propertyConstraints;
    }

    public TransformPropertyInputType getPropertyConstraintsType() {
        return this.propertyConstraintsType;
    }

    public List<String> getPropertyConstraints() {
        return this.propertyConstraints;
    }

    public int hashCode() {
        int hash = 5;
        hash = 29 * hash + Objects.hashCode((Object)this.inputType);
        hash = 29 * hash + Objects.hashCode(this.typeNames);
        hash = 29 * hash + Objects.hashCode((Object)this.propertyConstraintsType);
        hash = 29 * hash + Objects.hashCode(this.propertyConstraints);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConditionalInputConstraint other = (ConditionalInputConstraint)obj;
        if (this.inputType != other.inputType) {
            return false;
        }
        if (!Objects.equals(this.typeNames, other.typeNames)) {
            return false;
        }
        if (!Objects.equals((Object)this.propertyConstraintsType, (Object)other.propertyConstraintsType)) {
            return false;
        }
        return Objects.equals(this.propertyConstraints, other.propertyConstraints);
    }

    @Override
    public List<String> getInputTypeNames() {
        return this.typeNames;
    }
}

