/*
 * Decompiled with CFR 0.152.
 */
package com.bulenkov.darcula;

import com.bulenkov.darcula.DarculaMetalTheme;
import com.bulenkov.iconloader.IconLoader;
import com.bulenkov.iconloader.util.ColorUtil;
import com.bulenkov.iconloader.util.EmptyIcon;
import com.bulenkov.iconloader.util.StringUtil;
import com.bulenkov.iconloader.util.SystemInfo;
import com.paterva.maltego.util.IconSize;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.IconUIResource;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.basic.BasicLookAndFeel;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import org.openide.util.NbBundle;
import sun.awt.AppContext;

public final class DarculaLaf
extends BasicLookAndFeel {
    public static final String NAME = "Darcula";
    public static final String DARCULA_PROP_FILE_STRING = "darcula.properties";
    BasicLookAndFeel base;
    public static String darculaTempCompiledPropertiesString = "";

    public DarculaLaf() {
        try {
            if (SystemInfo.isWindows || SystemInfo.isLinux || SystemInfo.isMac) {
                this.base = new MetalLookAndFeel();
                MetalLookAndFeel.setCurrentTheme(new DarculaMetalTheme());
            } else {
                DarculaLaf.readDarculaProperties(true, true);
                String name = UIManager.getSystemLookAndFeelClassName();
                this.base = (BasicLookAndFeel)Class.forName(name).newInstance();
            }
        }
        catch (Exception ignore) {
            DarculaLaf.log(ignore);
        }
    }

    private void callInit(String method, UIDefaults defaults) {
        try {
            Method superMethod = BasicLookAndFeel.class.getDeclaredMethod(method, UIDefaults.class);
            superMethod.setAccessible(true);
            superMethod.invoke((Object)this.base, defaults);
        }
        catch (Exception ignore) {
            DarculaLaf.log(ignore);
        }
    }

    private static void log(Exception e) {
        e.printStackTrace();
    }

    @Override
    public UIDefaults getDefaults() {
        try {
            Method superMethod = BasicLookAndFeel.class.getDeclaredMethod("getDefaults", new Class[0]);
            superMethod.setAccessible(true);
            UIDefaults metalDefaults = (UIDefaults)superMethod.invoke((Object)new MetalLookAndFeel(), new Object[0]);
            UIDefaults defaults = (UIDefaults)superMethod.invoke((Object)this.base, new Object[0]);
            DarculaLaf.initInputMapDefaults(defaults);
            DarculaLaf.initIdeaDefaults(defaults);
            DarculaLaf.patchStyledEditorKit();
            DarculaLaf.patchComboBox(metalDefaults, defaults);
            Color iconColor = defaults.getColor("Table.sortIconColor");
            defaults.put("ETableHeader.ascendingIcon", new IconUIResource(new ArrowIcon(true, iconColor)));
            defaults.put("ETableHeader.descendingIcon", new IconUIResource(new ArrowIcon(false, iconColor)));
            defaults.remove("Spinner.arrowButtonBorder");
            int iconSize = IconSize.TINY.getSize();
            defaults.put("Spinner.arrowButtonSize", new Dimension(iconSize, 5));
            defaults.put("CheckBoxMenuItem.checkIcon", EmptyIcon.create(iconSize));
            defaults.put("RadioButtonMenuItem.checkIcon", EmptyIcon.create(iconSize));
            defaults.put("JXMonthView.monthDownFileName", new IconUIResource(IconLoader.getIcon("/com/bulenkov/darcula/icons/monthView_scrollleft_enabled.png")));
            defaults.put("JXMonthView.monthUpFileName", new IconUIResource(IconLoader.getIcon("/com/bulenkov/darcula/icons/monthView_scrollright_enabled.png")));
            return defaults;
        }
        catch (Exception ignore) {
            DarculaLaf.log(ignore);
            System.out.println("faulty startup -----------------------///////////////////////////////////--------------------------");
            return super.getDefaults();
        }
    }

    private static void patchComboBox(UIDefaults metalDefaults, UIDefaults defaults) {
        defaults.remove("ComboBox.ancestorInputMap");
        defaults.remove("ComboBox.actionMap");
        defaults.put("ComboBox.ancestorInputMap", metalDefaults.get("ComboBox.ancestorInputMap"));
        defaults.put("ComboBox.actionMap", metalDefaults.get("ComboBox.actionMap"));
    }

    private static void patchStyledEditorKit() {
        try {
            StyleSheet defaultStyles = new StyleSheet();
            InputStream is = DarculaLaf.class.getResourceAsStream("darcula.css");
            BufferedReader r = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            defaultStyles.loadRules(r, null);
            ((Reader)r).close();
            Field keyField = HTMLEditorKit.class.getDeclaredField("DEFAULT_STYLES_KEY");
            keyField.setAccessible(true);
            Object key = keyField.get(null);
            AppContext.getAppContext().put(key, defaultStyles);
        }
        catch (Exception e) {
            DarculaLaf.log(e);
        }
    }

    private void call(String method) {
        try {
            Method superMethod = BasicLookAndFeel.class.getDeclaredMethod(method, new Class[0]);
            superMethod.setAccessible(true);
            superMethod.invoke((Object)this.base, new Object[0]);
        }
        catch (Exception ignore) {
            DarculaLaf.log(ignore);
        }
    }

    @Override
    public void initComponentDefaults(UIDefaults defaults) {
        this.callInit("initComponentDefaults", defaults);
    }

    static void initIdeaDefaults(UIDefaults defaults) {
        DarculaLaf.loadDefaults(defaults);
    }

    private static void loadDefaults(UIDefaults defaults) {
        String osSuffix = SystemInfo.isMac ? "mac" : (SystemInfo.isWindows ? "windows" : "linux");
        try {
            Properties properties = DarculaLaf.readDarculaProperties(false);
            Enumeration keys = UIManager.getLookAndFeelDefaults().keys();
            while (keys.hasMoreElements()) {
                Object key = keys.nextElement();
                Object value = UIManager.getLookAndFeelDefaults().get(key);
                if (value == null || !(value instanceof Font)) continue;
                defaults.put(key, DarculaLaf.parseValue("7-default-font", properties.getProperty("7-default-font")));
            }
            HashMap<String, Object> darculaGlobalSettings = new HashMap<String, Object>();
            String prefix = "darcula.";
            for (String key : properties.stringPropertyNames()) {
                if (!key.startsWith("darcula.")) continue;
                darculaGlobalSettings.put(key.substring("darcula.".length()), DarculaLaf.parseValue(key, properties.getProperty(key)));
            }
            for (String key : defaults.keySet()) {
                String s;
                String darculaKey;
                if (!(key instanceof String) || !key.contains(".") || !darculaGlobalSettings.containsKey(darculaKey = (s = key).substring(s.lastIndexOf(46) + 1))) continue;
                defaults.put(key, darculaGlobalSettings.get(darculaKey));
            }
            for (String key : properties.stringPropertyNames()) {
                String value = properties.getProperty(key);
                defaults.put(key, DarculaLaf.parseValue(key, value));
            }
        }
        catch (IOException e) {
            DarculaLaf.log(e);
        }
    }

    public static Properties readDarculaProperties(boolean fromEither, boolean overwriteFile) throws IOException {
        Properties properties = new Properties();
        if (fromEither) {
            properties = !darculaTempCompiledPropertiesString.isEmpty() ? DarculaLaf.readDarculaPropertiesFromMemory() : DarculaLaf.readDarculaPropertiesFromResource(overwriteFile);
        }
        return properties;
    }

    public static Properties readDarculaProperties(boolean fromResource) throws IOException {
        Properties properties = new Properties();
        if (fromResource) {
            properties = DarculaLaf.readDarculaPropertiesFromResource(false);
        } else if (!darculaTempCompiledPropertiesString.isEmpty()) {
            properties = DarculaLaf.readDarculaPropertiesFromMemory();
        }
        return properties;
    }

    private static Properties readDarculaPropertiesFromMemory() throws IOException {
        Properties properties = new Properties();
        ByteArrayInputStream is = new ByteArrayInputStream(darculaTempCompiledPropertiesString.getBytes(StandardCharsets.UTF_8));
        properties.load(is);
        return properties;
    }

    private static Properties readDarculaPropertiesFromResource(boolean overwriteMemory) throws IOException {
        ResourceBundle bundle = NbBundle.getBundle((String)"com.bulenkov.darcula.darcula");
        Properties properties = new Properties();
        StringBuilder sb = new StringBuilder();
        for (String key : bundle.keySet()) {
            String value = bundle.getString(key);
            properties.put(key, value);
            if (!overwriteMemory) continue;
            sb.append(key).append("=").append(value).append("\n");
        }
        if (overwriteMemory) {
            darculaTempCompiledPropertiesString = sb.toString();
        }
        return properties;
    }

    public static Object parseValue(String key, String value) {
        if ("null".equals(value)) {
            return null;
        }
        if (key.toUpperCase().endsWith("FONT") || value.contains("-") && value.matches(".*[a-zA-Z]+.*") || key.toUpperCase().contains("FONT") && value.matches("^[a-zA-Z]*$")) {
            return new FontUIResource(Font.decode(value));
        }
        if (key.endsWith("Insets")) {
            List<String> numbers = StringUtil.split(value, ",");
            return new InsetsUIResource(Integer.parseInt(numbers.get(0)), Integer.parseInt(numbers.get(1)), Integer.parseInt(numbers.get(2)), Integer.parseInt(numbers.get(3)));
        }
        if (key.endsWith(".border") || key.endsWith("Border")) {
            try {
                return Class.forName(value).newInstance();
            }
            catch (Exception e) {
                DarculaLaf.log(e);
            }
        } else {
            Icon icon;
            Color color = ColorUtil.fromHex(value, null);
            Integer invVal = DarculaLaf.getInteger(value);
            Boolean boolVal = "true".equals(value) ? Boolean.TRUE : ("false".equals(value) ? Boolean.FALSE : null);
            Icon icon2 = icon = key.toLowerCase().endsWith("icon") || key.toLowerCase().endsWith("icon2") ? IconLoader.getIcon(value) : null;
            if (color != null) {
                return new ColorUIResource(color);
            }
            if (invVal != null) {
                return invVal;
            }
            if (icon != null) {
                return new IconUIResource(icon);
            }
            if (boolVal != null) {
                return boolVal;
            }
        }
        return value;
    }

    private static Integer getInteger(String value) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getID() {
        return this.getName();
    }

    @Override
    public String getDescription() {
        return "IntelliJ Dark Look and Feel";
    }

    @Override
    public boolean isNativeLookAndFeel() {
        return true;
    }

    @Override
    public boolean isSupportedLookAndFeel() {
        return true;
    }

    @Override
    protected void initSystemColorDefaults(UIDefaults defaults) {
        this.callInit("initSystemColorDefaults", defaults);
    }

    @Override
    protected void initClassDefaults(UIDefaults defaults) {
        this.callInit("initClassDefaults", defaults);
    }

    @Override
    public void initialize() {
        this.call("initialize");
    }

    @Override
    public void uninitialize() {
        this.call("uninitialize");
    }

    @Override
    protected void loadSystemColors(UIDefaults defaults, String[] systemColors, boolean useNative) {
        try {
            Method superMethod = BasicLookAndFeel.class.getDeclaredMethod("loadSystemColors", UIDefaults.class, String[].class, Boolean.TYPE);
            superMethod.setAccessible(true);
            superMethod.invoke((Object)this.base, defaults, systemColors, useNative);
        }
        catch (Exception ignore) {
            DarculaLaf.log(ignore);
        }
    }

    @Override
    public boolean getSupportsWindowDecorations() {
        return true;
    }

    public static void initInputMapDefaults(UIDefaults defaults) {
        InputMap tableInputMap;
        InputMap passwordFieldInputMap;
        InputMap textPaneInputMap;
        InputMap textFieldInputMap;
        InputMap editorInputMap;
        InputMap textAreaInputMap;
        InputMap treeInputMap = (InputMap)defaults.get("Tree.focusInputMap");
        if (treeInputMap != null) {
            treeInputMap.put(KeyStroke.getKeyStroke(10, 0), "toggle");
        }
        if ((textAreaInputMap = (InputMap)defaults.get("TextArea.focusInputMap")) != null) {
            DarculaLaf.installCutCopyPasteShortcuts(textAreaInputMap, false);
            DarculaLaf.installSelectAllShortcuts(textAreaInputMap, false);
        }
        if ((editorInputMap = (InputMap)defaults.get("EditorPane.focusInputMap")) != null) {
            DarculaLaf.installCutCopyPasteShortcuts(editorInputMap, false);
            DarculaLaf.installSelectAllShortcuts(editorInputMap, false);
        }
        if ((textFieldInputMap = (InputMap)defaults.get("TextField.focusInputMap")) != null) {
            DarculaLaf.installCutCopyPasteShortcuts(textFieldInputMap, false);
            DarculaLaf.installSelectAllShortcuts(textFieldInputMap, false);
        }
        if ((textPaneInputMap = (InputMap)defaults.get("TextPane.focusInputMap")) != null) {
            DarculaLaf.installCutCopyPasteShortcuts(textPaneInputMap, false);
            DarculaLaf.installSelectAllShortcuts(textPaneInputMap, false);
        }
        if ((passwordFieldInputMap = (InputMap)defaults.get("PasswordField.focusInputMap")) != null) {
            DarculaLaf.installCutCopyPasteShortcuts(passwordFieldInputMap, false);
            DarculaLaf.installSelectAllShortcuts(passwordFieldInputMap, false);
        }
        if ((tableInputMap = (InputMap)defaults.get("Table.ancestorInputMap")) != null) {
            DarculaLaf.installCutCopyPasteShortcuts(tableInputMap, true);
            DarculaLaf.installSelectAllShortcuts(tableInputMap, true);
        }
    }

    private static void installCutCopyPasteShortcuts(InputMap inputMap, boolean useSimpleActionKeys) {
        String cutActionKey;
        String copyActionKey = useSimpleActionKeys ? "copy" : "copy-to-clipboard";
        String pasteActionKey = useSimpleActionKeys ? "paste" : "paste-from-clipboard";
        String string = cutActionKey = useSimpleActionKeys ? "cut" : "cut-to-clipboard";
        if (SystemInfo.isMac) {
            inputMap.put(KeyStroke.getKeyStroke(155, 260), copyActionKey);
            inputMap.put(KeyStroke.getKeyStroke(67, 260), copyActionKey);
            inputMap.put(KeyStroke.getKeyStroke(86, 260), pasteActionKey);
            inputMap.put(KeyStroke.getKeyStroke(88, 260), cutActionKey);
        } else {
            inputMap.put(KeyStroke.getKeyStroke(155, 130), copyActionKey);
            inputMap.put(KeyStroke.getKeyStroke(67, 130), copyActionKey);
            inputMap.put(KeyStroke.getKeyStroke(86, 130), pasteActionKey);
            inputMap.put(KeyStroke.getKeyStroke(88, 130), cutActionKey);
        }
        inputMap.put(KeyStroke.getKeyStroke(155, 65), pasteActionKey);
        inputMap.put(KeyStroke.getKeyStroke(127, 65), cutActionKey);
    }

    private static void installSelectAllShortcuts(InputMap inputMap, boolean useSimpleActionKeys) {
        String selectAllActionKey;
        String string = selectAllActionKey = useSimpleActionKeys ? "selectAll" : "select-all";
        if (SystemInfo.isMac) {
            inputMap.put(KeyStroke.getKeyStroke(65, 260), selectAllActionKey);
        } else {
            inputMap.put(KeyStroke.getKeyStroke(65, 130), selectAllActionKey);
        }
    }

    private static class ArrowIcon
    implements Icon {
        private static final Dimension ICON_DIMENSION = new Dimension(11, 6);
        private static final Dimension TRIANGLE_DIMENSION = new Dimension(7, 4);
        private final Color color;
        private final boolean up;

        public ArrowIcon(boolean up, Color color) {
            this.up = up;
            this.color = color;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Graphics2D g2d = (Graphics2D)g;
            int xx = ArrowIcon.ICON_DIMENSION.width > ArrowIcon.TRIANGLE_DIMENSION.width ? x + ArrowIcon.ICON_DIMENSION.width / 2 - ArrowIcon.TRIANGLE_DIMENSION.width / 2 : x;
            int yy = ArrowIcon.ICON_DIMENSION.height > ArrowIcon.TRIANGLE_DIMENSION.height ? y + ArrowIcon.ICON_DIMENSION.height / 2 - ArrowIcon.TRIANGLE_DIMENSION.height / 2 : y;
            g2d.setColor(this.color);
            this.drawTriangle(g2d, xx, yy);
        }

        private void drawTriangle(Graphics2D g2d, int x, int y) {
            if (this.up) {
                g2d.drawLine(x + 3, y, x + 3, y);
                g2d.drawLine(x + 2, y + 1, x + 4, y + 1);
                g2d.drawLine(x + 1, y + 2, x + 5, y + 2);
                g2d.drawLine(x, y + 3, x + 6, y + 3);
            } else {
                g2d.drawLine(x, y, x + 6, y);
                g2d.drawLine(x + 1, y + 1, x + 5, y + 1);
                g2d.drawLine(x + 2, y + 2, x + 4, y + 2);
                g2d.drawLine(x + 3, y + 3, x + 3, y + 3);
            }
        }

        @Override
        public int getIconWidth() {
            return ArrowIcon.ICON_DIMENSION.width;
        }

        @Override
        public int getIconHeight() {
            return ArrowIcon.ICON_DIMENSION.height;
        }
    }
}

