/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.store.views.impl.rules.chain;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.LinkEntityIDs;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.views.collect.CollectionSettings;
import com.paterva.maltego.graph.store.views.impl.InMemoryCollectionNodes;
import com.paterva.maltego.graph.store.views.impl.ModelSnapshotData;
import com.paterva.maltego.graph.store.views.impl.rules.chain.Chain;
import com.paterva.maltego.graph.store.views.impl.rules.chain.ChainEndPoints;
import com.paterva.maltego.graph.store.views.impl.rules.chain.ChainEntityToLinks;
import com.paterva.maltego.graph.store.views.impl.structures.EntityLinks;
import com.paterva.maltego.graph.store.views.impl.structures.LinkDirection;
import com.paterva.maltego.graph.store.views.impl.structures.Pair;
import com.paterva.maltego.graph.store.views.impl.structures.ViewEntity;
import com.paterva.maltego.graph.store.views.impl.structures.ViewLink;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

class ChainSet
extends HashSet<Chain> {
    private static final Logger LOG = Logger.getLogger(ChainSet.class.getName());
    private static final boolean CHECK_ARGS = false;

    ChainSet() {
    }

    @Override
    public boolean add(Chain e) {
        return super.add(e);
    }

    private int getChainLength() {
        return this.isEmpty() ? 0 : ((Chain)this.iterator().next()).size();
    }

    private String getEntityType(int chainLevel) {
        return ((Chain)this.iterator().next()).getChainEntities().get((int)chainLevel)._entityType;
    }

    private Set<EntityID> getEntities(int chainLevel) {
        HashSet<EntityID> s = new HashSet<EntityID>();
        for (Chain chain : this) {
            s.add(chain.getEntity(chainLevel));
        }
        return s;
    }

    private List<List<ChainEntityToLinks>> getItemsToCollect() {
        ArrayList<List<ChainEntityToLinks>> list = new ArrayList<List<ChainEntityToLinks>>(this.size());
        for (Chain chain : this) {
            int size = chain.getChainEntitiesWithOutEndPoints().size();
            ArrayList<ChainEntityToLinks> innerList = new ArrayList<ChainEntityToLinks>(size);
            for (int i = 0; i < size; ++i) {
                ChainEntityToLinks etl = new ChainEntityToLinks();
                etl.ent = chain.getChainEntitiesWithOutEndPoints().get(i);
                if (size == 1) {
                    etl.entOther1 = chain.getEndPt1();
                    etl.entOther2 = chain.getEndPt2();
                } else if (i == 0) {
                    etl.entOther1 = chain.getEndPt1();
                    etl.entOther2 = chain.getChainEntitiesWithOutEndPoints().get(i + 1);
                } else if (i == size - 1) {
                    etl.entOther1 = chain.getChainEntitiesWithOutEndPoints().get(i - 1);
                    etl.entOther2 = chain.getEndPt2();
                } else {
                    etl.entOther1 = chain.getChainEntitiesWithOutEndPoints().get(i - 1);
                    etl.entOther2 = chain.getChainEntitiesWithOutEndPoints().get(i + 1);
                }
                Map<EntityID, EntityLinks> links = this.getLinks(chain, etl);
                this.getIncomingLinkBetween(chain, etl, links);
                this.getOutgoingLinkBetween(chain, etl, links);
                innerList.add(etl);
            }
            list.add(innerList);
        }
        return list;
    }

    private Map<EntityID, EntityLinks> getLinks(Chain chain, ChainEntityToLinks etl) {
        HashMap<EntityID, EntityLinks> links = new HashMap<EntityID, EntityLinks>(4);
        links.put(etl.ent, chain.getEntities().get(etl.ent));
        if (etl.entOther1 != null) {
            links.put(etl.entOther1, chain.getEntities().get(etl.entOther1));
        }
        if (etl.entOther2 != null) {
            links.put(etl.entOther2, chain.getEntities().get(etl.entOther2));
        }
        return links;
    }

    private List<ChainEntityToLinks> getItemsToCollectAtLevel(List<List<ChainEntityToLinks>> itemsToCollect, int level) {
        ArrayList<ChainEntityToLinks> list = new ArrayList<ChainEntityToLinks>(itemsToCollect.size());
        for (List<ChainEntityToLinks> l : itemsToCollect) {
            list.add(l.get(level));
        }
        return list;
    }

    private Set<EntityID> getEntities(List<ChainEntityToLinks> items) {
        HashSet<EntityID> entities = new HashSet<EntityID>(items.size());
        for (ChainEntityToLinks item : items) {
            entities.add(item.ent);
        }
        return entities;
    }

    private Set<LinkID> getLinks(List<ChainEntityToLinks> items, LinkDirection direction, int oneOrTwo) {
        HashSet<LinkID> links = new HashSet<LinkID>();
        block8: for (ChainEntityToLinks item : items) {
            Pair<Set<LinkID>, Set<LinkID>> l;
            switch (oneOrTwo) {
                case 1: {
                    l = item.link1;
                    break;
                }
                case 2: {
                    l = item.link2;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown link group");
                }
            }
            switch (direction) {
                case INCOMING: {
                    if (l.getOne() == null) continue block8;
                    links.addAll((Collection<LinkID>)l.getOne());
                    continue block8;
                }
                case OUTGOING: {
                    if (l.getTwo() == null) continue block8;
                    links.addAll((Collection<LinkID>)l.getTwo());
                    continue block8;
                }
            }
            throw new IllegalArgumentException("Unknown direction");
        }
        return links;
    }

    private void getIncomingLinkBetween(Chain chain, ChainEntityToLinks etl, Map<EntityID, EntityLinks> links) {
        if (etl.entOther1 != null) {
            Set<LinkID> l1 = chain.getIncomingLinkBetween(etl.ent, etl.entOther1, links);
            etl.link1.setOne(l1);
        }
        if (etl.entOther2 != null) {
            Set<LinkID> l2 = chain.getIncomingLinkBetween(etl.ent, etl.entOther2, links);
            etl.link2.setOne(l2);
        }
    }

    private void getOutgoingLinkBetween(Chain chain, ChainEntityToLinks etl, Map<EntityID, EntityLinks> links) {
        if (etl.entOther1 != null) {
            Set<LinkID> l1 = chain.getOutgoingLinkBetween(etl.ent, etl.entOther1, links);
            etl.link1.setTwo(l1);
        }
        if (etl.entOther2 != null) {
            Set<LinkID> l2 = chain.getOutgoingLinkBetween(etl.ent, etl.entOther2, links);
            etl.link2.setTwo(l2);
        }
    }

    boolean isCollectable(ModelSnapshotData msd) {
        int minEntityCount = msd.getMinEntityCountForCollection(this.getEntityType(0));
        double ruleRatio = CollectionSettings.getDefault().getRuleRatio();
        minEntityCount = (int)((double)minEntityCount * ruleRatio);
        return this.getEntities(0).size() >= minEntityCount;
    }

    private Pair<LinkID, ViewLink> getOrCreate(ModelSnapshotData msd, Map<LinkID, ViewLink> linkCache, Set<LinkID> linksToCollect, EntityID source, EntityID target, InMemoryCollectionNodes collectionNodes) throws GraphStoreException {
        ViewLink viewLink = new ViewLink(source, target, linksToCollect);
        for (Map.Entry<LinkID, ViewLink> entry : linkCache.entrySet()) {
            LinkID key = entry.getKey();
            ViewLink value = entry.getValue();
            for (LinkID linkID : linksToCollect) {
                if (!value.getCollection().contains(linkID)) continue;
                if (!value.getCollection().containsAll(linksToCollect)) {
                    throw new IllegalStateException("Previous Links must contain the exact same collections, there is a problem with this logic");
                }
                linkCache.put(key, viewLink);
                return new Pair<LinkID, ViewLink>(key, viewLink);
            }
        }
        Pair<LinkID, ViewLink> itemToReuse = collectionNodes.getFirstViewLinkThatIsACollection(linksToCollect, source, target);
        if (itemToReuse != null && !msd.collectedViewLinksContains(itemToReuse.getOne()) && !linkCache.containsKey(itemToReuse.getOne())) {
            linkCache.put(itemToReuse.getOne(), viewLink);
            return new Pair<LinkID, ViewLink>(itemToReuse.getOne(), viewLink);
        }
        LinkID collectionLink = LinkID.create();
        linkCache.put(collectionLink, viewLink);
        return new Pair<LinkID, ViewLink>(collectionLink, viewLink);
    }

    void collect(ChainEndPoints endPoints, ModelSnapshotData msd, InMemoryCollectionNodes collectionNodes, Map<EntityID, EntityLinks> entitiesSnapShot, Map<LinkID, LinkEntityIDs> linksSnapShot, Pair<EntityLinks, EntityLinks> endPointLinkMods) throws GraphStoreException {
        HashSet entitiesToCollect;
        ArrayList levelItems;
        int level;
        int size = this.getChainLength();
        List<List<ChainEntityToLinks>> itemsToCollect = this.getItemsToCollect();
        HashMap<LinkID, ViewLink> linkCache = new HashMap<LinkID, ViewLink>(size);
        HashSet entitiesToRemove = new HashSet();
        HashSet<LinkID> linksToRemove = new HashSet<LinkID>();
        EntityID[] entityCache = new EntityID[size];
        ArrayList[] allLevelItems = new ArrayList[size];
        HashSet[] allEntitiesToCollect = new HashSet[size];
        for (level = 0; level < size; ++level) {
            levelItems = this.getItemsToCollectAtLevel(itemsToCollect, level);
            entitiesToCollect = this.getEntities(levelItems);
            Pair<EntityID, ViewEntity> entPair = collectionNodes.getFirstViewEntityThatIsACollection(entitiesToCollect);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "IN COLLECTION RULES entitiesToCollect {0}", ((Object)entitiesToCollect).toString());
                if (entPair != null) {
                    LOG.log(Level.FINE, "ENT_PAIR {0}", entPair.toString());
                } else {
                    LOG.log(Level.FINE, "ENT_PAIR null");
                }
            }
            if (entPair != null && !this.contains(entityCache, entPair.getOne()) && !msd.collectedViewEntitiesContains(entPair.getOne())) {
                entityCache[level] = entPair.getOne();
            }
            entitiesToRemove.addAll(entitiesToCollect);
            allLevelItems[level] = levelItems;
            allEntitiesToCollect[level] = entitiesToCollect;
        }
        for (level = 0; level < size; ++level) {
            levelItems = allLevelItems[level];
            entitiesToCollect = allEntitiesToCollect[level];
            Set<LinkID> incomingLinks1 = this.getLinks(levelItems, LinkDirection.INCOMING, 1);
            Set<LinkID> incomingLinks2 = this.getLinks(levelItems, LinkDirection.INCOMING, 2);
            Set<LinkID> outgoingLinks1 = this.getLinks(levelItems, LinkDirection.OUTGOING, 1);
            Set<LinkID> outgoingLinks2 = this.getLinks(levelItems, LinkDirection.OUTGOING, 2);
            linksToRemove.addAll(incomingLinks1);
            linksToRemove.addAll(incomingLinks2);
            linksToRemove.addAll(outgoingLinks1);
            linksToRemove.addAll(outgoingLinks2);
            EntityID collectionEntity = this.getOrAddEntityFromCache(endPoints, entityCache, level, size);
            EntityLinks allLinks = new EntityLinks();
            ViewEntity viewEntity = new ViewEntity(this.getEntityType(level), entitiesToCollect, allLinks);
            allLinks.getModelIncomingLinks().addAll(incomingLinks1);
            allLinks.getModelIncomingLinks().addAll(incomingLinks2);
            allLinks.getModelOutgoingLinks().addAll(outgoingLinks1);
            allLinks.getModelOutgoingLinks().addAll(outgoingLinks2);
            Pair<LinkID, ViewLink> incomingCollectionLink1 = incomingLinks1.isEmpty() ? null : this.getOrCreate(msd, linkCache, incomingLinks1, this.getOrAddEntityFromCache(endPoints, entityCache, level - 1, size), collectionEntity, collectionNodes);
            Pair<LinkID, ViewLink> incomingCollectionLink2 = incomingLinks2.isEmpty() ? null : this.getOrCreate(msd, linkCache, incomingLinks2, this.getOrAddEntityFromCache(endPoints, entityCache, level + 1, size), collectionEntity, collectionNodes);
            Pair<LinkID, ViewLink> outgoingCollectionLink1 = outgoingLinks1.isEmpty() ? null : this.getOrCreate(msd, linkCache, outgoingLinks1, collectionEntity, this.getOrAddEntityFromCache(endPoints, entityCache, level - 1, size), collectionNodes);
            Pair<LinkID, ViewLink> outgoingCollectionLink2 = outgoingLinks2.isEmpty() ? null : this.getOrCreate(msd, linkCache, outgoingLinks2, collectionEntity, this.getOrAddEntityFromCache(endPoints, entityCache, level + 1, size), collectionNodes);
            int counter = 0;
            if (incomingCollectionLink1 != null) {
                ++counter;
                this.addIncoming(endPoints, msd, allLinks, incomingCollectionLink1, level, size, endPointLinkMods);
            }
            if (incomingCollectionLink2 != null) {
                ++counter;
                this.addIncoming(endPoints, msd, allLinks, incomingCollectionLink2, level, size, endPointLinkMods);
            }
            if (outgoingCollectionLink1 != null) {
                ++counter;
                this.addOutgoing(endPoints, msd, allLinks, outgoingCollectionLink1, level, size, endPointLinkMods);
            }
            if (outgoingCollectionLink2 != null) {
                ++counter;
                this.addOutgoing(endPoints, msd, allLinks, outgoingCollectionLink2, level, size, endPointLinkMods);
            }
            msd.addToCollectedViewEntities(collectionEntity, viewEntity);
        }
        entitiesSnapShot.keySet().removeAll(entitiesToRemove);
        linksSnapShot.keySet().removeAll(linksToRemove);
    }

    private boolean CHECK_execute(EntityLinks entLinks, Pair<LinkID, ViewLink> linkCollection, EntityID collectionEntity, EntityID otherEntity) {
        if (linkCollection == null) {
            return true;
        }
        for (LinkID linkID : linkCollection.getTwo().getCollection()) {
            if (entLinks.getModelIncomingLinks().remove(linkID) || entLinks.getModelOutgoingLinks().remove(linkID)) continue;
            LOG.log(Level.FINE, "Inner collected link not contained");
            return false;
        }
        LinkEntityIDs entities = linkCollection.getTwo().getEntities();
        EntityID sourceID = entities.getSourceID();
        EntityID targetID = entities.getTargetID();
        if (!(sourceID.equals((Object)collectionEntity) && targetID.equals((Object)otherEntity) || sourceID.equals((Object)otherEntity) && targetID.equals((Object)collectionEntity))) {
            LOG.log(Level.FINE, "Collected link source & target do not match");
            return false;
        }
        LinkID collectionLink = linkCollection.getOne();
        if (!entLinks.getViewIncomingLinks().remove(collectionLink) && !entLinks.getViewOutgoingLinks().remove(collectionLink)) {
            LOG.log(Level.FINE, "Collection link not contained");
            return false;
        }
        return true;
    }

    private void addIncoming(ChainEndPoints endPoints, ModelSnapshotData msd, EntityLinks allLinks, Pair<LinkID, ViewLink> incomingCollectionLink, int level, int size, Pair<EntityLinks, EntityLinks> endPointLinkMods) {
        ViewLink vl;
        EntityLinks endEntLinks;
        allLinks.getViewIncomingLinks().add(incomingCollectionLink.getOne());
        msd.addToCollectedViewLinks(incomingCollectionLink.getOne(), incomingCollectionLink.getTwo());
        if (level == 0 && endPoints.getEndPt1() != null) {
            endEntLinks = endPointLinkMods.getOne();
            vl = incomingCollectionLink.getTwo();
            if (endEntLinks != null && vl.getEntities().getSourceID().equals((Object)endPoints.getEndPt1())) {
                endEntLinks.getModelOutgoingLinks().addAll(vl.getCollection());
                endEntLinks.getViewOutgoingLinks().add(incomingCollectionLink.getOne());
            }
        }
        if (level + 1 == size && endPoints.getEndPt2() != null) {
            endEntLinks = endPointLinkMods.getTwo();
            vl = incomingCollectionLink.getTwo();
            if (endEntLinks != null && vl.getEntities().getSourceID().equals((Object)endPoints.getEndPt2())) {
                endEntLinks.getModelOutgoingLinks().addAll(vl.getCollection());
                endEntLinks.getViewOutgoingLinks().add(incomingCollectionLink.getOne());
            }
        }
    }

    private void addOutgoing(ChainEndPoints endPoints, ModelSnapshotData msd, EntityLinks allLinks, Pair<LinkID, ViewLink> outgoingCollectionLink, int level, int size, Pair<EntityLinks, EntityLinks> endPointLinkMods) {
        ViewLink vl;
        EntityLinks endEntLinks;
        allLinks.getViewOutgoingLinks().add(outgoingCollectionLink.getOne());
        msd.addToCollectedViewLinks(outgoingCollectionLink.getOne(), outgoingCollectionLink.getTwo());
        if (level == 0 && endPoints.getEndPt1() != null) {
            endEntLinks = endPointLinkMods.getOne();
            vl = outgoingCollectionLink.getTwo();
            if (endEntLinks != null && vl.getEntities().getTargetID().equals((Object)endPoints.getEndPt1())) {
                endEntLinks.getModelIncomingLinks().addAll(vl.getCollection());
                endEntLinks.getViewIncomingLinks().add(outgoingCollectionLink.getOne());
            }
        }
        if (level + 1 == size && endPoints.getEndPt2() != null) {
            endEntLinks = endPointLinkMods.getTwo();
            vl = outgoingCollectionLink.getTwo();
            if (endEntLinks != null && vl.getEntities().getTargetID().equals((Object)endPoints.getEndPt2())) {
                endEntLinks.getModelIncomingLinks().addAll(vl.getCollection());
                endEntLinks.getViewIncomingLinks().add(outgoingCollectionLink.getOne());
            }
        }
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this);
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj;
    }

    private EntityID getOrAddEntityFromCache(ChainEndPoints endPoints, EntityID[] entityCache, int level, int size) {
        if (level < 0) {
            return endPoints.getEndPt1();
        }
        if (level >= size) {
            return endPoints.getEndPt2();
        }
        EntityID ent = entityCache[level];
        if (ent == null) {
            entityCache[level] = ent = EntityID.create();
        }
        return ent;
    }

    private boolean contains(EntityID[] entityCache, EntityID entity) {
        for (EntityID entityID : entityCache) {
            if (!entity.equals((Object)entityID)) continue;
            return true;
        }
        return false;
    }
}

