/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.store.views.impl;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.LinkEntityIDs;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.structure.GraphStructureMods;
import com.paterva.maltego.graph.store.structure.GraphStructureReader;
import com.paterva.maltego.graph.store.views.impl.InMemoryCollectionNodes;
import com.paterva.maltego.graph.store.views.impl.structures.EntityLinks;
import com.paterva.maltego.graph.store.views.impl.structures.ViewEntity;
import com.paterva.maltego.graph.store.views.impl.structures.ViewLink;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

class ViewSnapShot {
    private ViewSnapShot() {
    }

    private static EntityLinks linkLookup(InMemoryCollectionNodes collectionNodes, GraphStructureReader modelStructureReader, Set<EntityID> snapshotUncollectedModelEntityIDsWithMods, EntityID modelEntity, boolean recollectEntireGraph, Map<EntityID, Set<LinkID>> incoming, Map<EntityID, Set<LinkID>> outgoing, Map<LinkID, LinkEntityIDs> modelLinkEntities) throws GraphStoreException {
        LinkID incomingViewLink;
        Set<LinkID> incomingModel = incoming.get(modelEntity);
        Set<LinkID> outgoingModel = outgoing.get(modelEntity);
        HashSet<LinkID> incomingView = new HashSet<LinkID>(incomingModel.size());
        HashSet<LinkID> outgoingView = new HashSet<LinkID>(outgoingModel.size());
        HashMap<LinkID, LinkEntityIDs> incomingLinkModelEnts = new HashMap<LinkID, LinkEntityIDs>();
        for (LinkID incomingLink : incomingModel) {
            incomingLinkModelEnts.put(incomingLink, modelLinkEntities.get(incomingLink));
        }
        HashMap<LinkID, LinkEntityIDs> outgoingLinkModelEnts = new HashMap<LinkID, LinkEntityIDs>();
        for (LinkID linkID : outgoingModel) {
            outgoingLinkModelEnts.put(linkID, modelLinkEntities.get(linkID));
        }
        for (Map.Entry entry : incomingLinkModelEnts.entrySet()) {
            LinkID incomingModelLink = (LinkID)entry.getKey();
            EntityID sourceID = ((LinkEntityIDs)entry.getValue()).getSourceID();
            if (!snapshotUncollectedModelEntityIDsWithMods.contains(sourceID)) {
                if (recollectEntireGraph) {
                    throw new IllegalStateException("Must uncollect all links as the entire graph is being recollected");
                }
                incomingViewLink = collectionNodes.getViewLink(incomingModelLink);
                incomingView.add(incomingViewLink);
                continue;
            }
            incomingView.add(incomingModelLink);
        }
        for (Map.Entry entry : outgoingLinkModelEnts.entrySet()) {
            LinkID outgoingModelLink = (LinkID)entry.getKey();
            EntityID targetID = ((LinkEntityIDs)entry.getValue()).getTargetID();
            if (!snapshotUncollectedModelEntityIDsWithMods.contains(targetID)) {
                if (recollectEntireGraph) {
                    throw new IllegalStateException("Must uncollect all links as the entire graph is being recollected");
                }
                incomingViewLink = collectionNodes.getViewLink(outgoingModelLink);
                outgoingView.add(incomingViewLink);
                continue;
            }
            outgoingView.add(outgoingModelLink);
        }
        return new EntityLinks(incomingModel, outgoingModel, incomingView, outgoingView);
    }

    private static Map<EntityID, EntityLinks> linkLookup(GraphStructureReader modelStructureReader, Set<EntityID> modelEntities, Set<EntityID> entitiesRemoved) throws GraphStoreException {
        Set<EntityID> entCopy = modelEntities;
        if (entitiesRemoved != null) {
            entCopy = new HashSet<EntityID>(modelEntities);
            entCopy.removeAll(entitiesRemoved);
        }
        HashMap<EntityID, EntityLinks> entityLinks = new HashMap<EntityID, EntityLinks>(entCopy.size());
        Map incoming = modelStructureReader.getIncoming(entCopy);
        Map outgoing = modelStructureReader.getOutgoing(entCopy);
        for (EntityID entityID : entCopy) {
            Set in = (Set)incoming.get(entityID);
            Set out = (Set)outgoing.get(entityID);
            entityLinks.put(entityID, new EntityLinks(in, out, new HashSet<LinkID>(in), new HashSet<LinkID>(out)));
        }
        return entityLinks;
    }

    private static Map<EntityID, EntityLinks> linkLookup(Collection<EntityID> modelEntities, Set<EntityID> entitiesRemoved, Map<EntityID, Set<LinkID>> incoming, Map<EntityID, Set<LinkID>> outgoing) throws GraphStoreException {
        Collection<EntityID> entCopy = modelEntities;
        if (entitiesRemoved != null) {
            entCopy = new HashSet<EntityID>(modelEntities);
            entCopy.removeAll(entitiesRemoved);
        }
        HashMap<EntityID, EntityLinks> entityLinks = new HashMap<EntityID, EntityLinks>(entCopy.size());
        for (EntityID entityID : entCopy) {
            Set<LinkID> in = incoming.get(entityID);
            Set<LinkID> out = outgoing.get(entityID);
            entityLinks.put(entityID, new EntityLinks(in, out, new HashSet<LinkID>(in), new HashSet<LinkID>(out)));
        }
        return entityLinks;
    }

    static void createViewSnapShot(InMemoryCollectionNodes collectionNodes, Set<EntityID> touchedViewEntities, Map<EntityID, ViewEntity> viewEntitiesSnapShot, Map<LinkID, ViewLink> viewLinksSnapShot) throws GraphStoreException {
        Map<EntityID, ViewEntity> viewEntities = collectionNodes.getViewEntities();
        Map<LinkID, ViewLink> viewLinks = collectionNodes.getViewLinks();
        for (EntityID touchedViewEntity : touchedViewEntities) {
            Set<LinkID> viewLinkLinks = collectionNodes.getLinks(touchedViewEntity);
            for (LinkID viewLink : viewLinkLinks) {
                ViewLink collectionViewLink = viewLinks.get(viewLink);
                if (collectionViewLink == null) {
                    throw new GraphStoreException("The linkID '" + viewLink + "' is not a view link");
                }
                viewLinksSnapShot.put(viewLink, collectionViewLink);
            }
            ViewEntity viewEntity = viewEntities.get(touchedViewEntity);
            if (viewEntity == null) {
                throw new GraphStoreException("The entityID '" + touchedViewEntity + "' is not a view entity");
            }
            viewEntitiesSnapShot.put(touchedViewEntity, viewEntity);
        }
    }

    static void uncollectViewSnapShot(InMemoryCollectionNodes collectionNodes, Map<EntityID, ViewEntity> viewEntitiesSnapShot, Map<LinkID, ViewLink> viewLinksSnapShot, Map<EntityID, EntityLinks> uncollectedEntities, Map<LinkID, LinkEntityIDs> uncollectedLinks, GraphStructureMods incomingModelMods, boolean recollectEntireGraph) throws GraphStoreException {
        GraphStructureReader modelStructureReader = collectionNodes.getModelStructureReader();
        Map linksRemoved = incomingModelMods.getLinksRemoved();
        Set entitiesRemoved = incomingModelMods.getEntitiesRemoved();
        Set entitiesAdded = incomingModelMods.getEntitiesAdded();
        HashSet<EntityID> snapshotUncollectedModelEntityIDsWithMods = new HashSet<EntityID>();
        for (Map.Entry<EntityID, ViewEntity> entry : viewEntitiesSnapShot.entrySet()) {
            EntityID entity = entry.getKey();
            ViewEntity viewEntity = entry.getValue();
            if (viewEntity.isCollection()) {
                snapshotUncollectedModelEntityIDsWithMods.addAll(viewEntity.getCollection());
                continue;
            }
            snapshotUncollectedModelEntityIDsWithMods.add(entity);
        }
        HashSet snapshotUncollectedModelEntityIDs = new HashSet(snapshotUncollectedModelEntityIDsWithMods);
        snapshotUncollectedModelEntityIDsWithMods.removeAll(entitiesRemoved);
        snapshotUncollectedModelEntityIDsWithMods.addAll(entitiesAdded);
        Set modelEntities = modelStructureReader.getEntities();
        Map incoming = modelStructureReader.getIncoming((Collection)modelEntities);
        Map outgoing = modelStructureReader.getOutgoing((Collection)modelEntities);
        Set modelLinks = modelStructureReader.getLinks();
        Map modelLinkEntities = modelStructureReader.getEntities((Collection)modelLinks);
        for (Map.Entry<EntityID, ViewEntity> entry : viewEntitiesSnapShot.entrySet()) {
            EntityID entity = entry.getKey();
            ViewEntity viewEntity = entry.getValue();
            if (viewEntity.isCollection()) {
                uncollectedEntities.putAll(ViewSnapShot.linkLookup(viewEntity.getCollection(), entitiesRemoved, incoming, outgoing));
                continue;
            }
            if (entitiesRemoved.contains(entity)) continue;
            uncollectedEntities.put(entity, ViewSnapShot.linkLookup(collectionNodes, modelStructureReader, snapshotUncollectedModelEntityIDsWithMods, entity, recollectEntireGraph, incoming, outgoing, modelLinkEntities));
        }
        HashSet<LinkID> linksToRemovedFromSnapshotView = new HashSet<LinkID>();
        for (Map.Entry<LinkID, ViewLink> entry : viewLinksSnapShot.entrySet()) {
            LinkID viewLinkId = entry.getKey();
            ViewLink viewLink = entry.getValue();
            LinkEntityIDs entities = viewLink.getEntities();
            if (viewLink.isCollection()) {
                for (LinkID collectedLink : viewLink.getCollection()) {
                    LinkEntityIDs removedLinkEntities = (LinkEntityIDs)linksRemoved.get(collectedLink);
                    if (removedLinkEntities != null) {
                        if (snapshotUncollectedModelEntityIDs.contains(removedLinkEntities.getSourceID()) && snapshotUncollectedModelEntityIDs.contains(removedLinkEntities.getTargetID())) {
                            uncollectedLinks.put(collectedLink, removedLinkEntities);
                            continue;
                        }
                        linksToRemovedFromSnapshotView.add(viewLinkId);
                        continue;
                    }
                    entities = modelStructureReader.getEntities(collectedLink);
                    if (snapshotUncollectedModelEntityIDs.contains(entities.getSourceID()) && snapshotUncollectedModelEntityIDs.contains(entities.getTargetID())) {
                        uncollectedLinks.put(collectedLink, entities);
                        continue;
                    }
                    linksToRemovedFromSnapshotView.add(viewLinkId);
                }
                continue;
            }
            if (snapshotUncollectedModelEntityIDs.contains(entities.getSourceID()) && snapshotUncollectedModelEntityIDs.contains(entities.getTargetID())) {
                uncollectedLinks.put(viewLinkId, entities);
                continue;
            }
            linksToRemovedFromSnapshotView.add(viewLinkId);
        }
        viewLinksSnapShot.keySet().removeAll(linksToRemovedFromSnapshotView);
    }

    static void applyIncommingMods(InMemoryCollectionNodes collectionNodes, Map<EntityID, EntityLinks> uncollectedEntities, Map<LinkID, LinkEntityIDs> uncollectedLinks, Map<EntityID, EntityLinks> uncollectedEntitiesWithMods, Map<LinkID, LinkEntityIDs> uncollectedLinksWithMods, GraphStructureMods modelMods) throws GraphStoreException {
        GraphStructureReader modelStructureReader = collectionNodes.getModelStructureReader();
        uncollectedEntitiesWithMods.putAll(uncollectedEntities);
        uncollectedEntitiesWithMods.putAll(ViewSnapShot.linkLookup(modelStructureReader, modelMods.getEntitiesAdded(), null));
        if (!modelMods.getEntitiesRemoved().isEmpty()) {
            uncollectedEntitiesWithMods.keySet().removeAll(modelMods.getEntitiesRemoved());
        }
        uncollectedLinksWithMods.putAll(uncollectedLinks);
        uncollectedLinksWithMods.putAll(modelStructureReader.getEntities((Collection)modelMods.getLinksAdded()));
        if (!modelMods.getLinksRemoved().isEmpty()) {
            uncollectedLinksWithMods.keySet().removeAll(modelMods.getLinksRemoved().keySet());
        }
    }
}

