/*
 * Decompiled with CFR 0.152.
 */
package com.spatial4j.core.shape;

import com.spatial4j.core.context.SpatialContext;
import com.spatial4j.core.shape.Point;
import com.spatial4j.core.shape.Shape;
import com.spatial4j.core.shape.ShapeCollection;
import com.spatial4j.core.shape.SpatialRelation;
import java.util.List;

public class PinkmatterShapeCollection<S extends Shape>
extends ShapeCollection<S> {
    public PinkmatterShapeCollection(List<S> shapes, SpatialContext ctx) {
        super(shapes, ctx);
    }

    public SpatialRelation relate(Shape other) {
        SpatialRelation bboxSect = this.bbox.relate(other);
        if (bboxSect == SpatialRelation.DISJOINT || bboxSect == SpatialRelation.WITHIN) {
            return bboxSect;
        }
        boolean containsWillShortCircuit = other instanceof Point || this.relateContainsShortCircuits();
        SpatialRelation sect = null;
        for (Shape shape : this.shapes) {
            SpatialRelation nextSect = shape.relate(other);
            if ((sect = sect == null ? nextSect : this.combine(sect, nextSect)) != SpatialRelation.CONTAINS || !containsWillShortCircuit) continue;
            return SpatialRelation.CONTAINS;
        }
        return sect;
    }

    private SpatialRelation combine(SpatialRelation current, SpatialRelation other) {
        if (other == current) {
            return current;
        }
        if (current == SpatialRelation.CONTAINS || other == SpatialRelation.CONTAINS) {
            return SpatialRelation.CONTAINS;
        }
        if (current == SpatialRelation.INTERSECTS || other == SpatialRelation.INTERSECTS) {
            return SpatialRelation.INTERSECTS;
        }
        if (current == SpatialRelation.WITHIN || other == SpatialRelation.WITHIN) {
            return SpatialRelation.WITHIN;
        }
        return SpatialRelation.DISJOINT;
    }
}

