/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.collab.session.xmpp;

import com.paterva.maltego.chatapi.conn.ConnectionInitiationCallback;
import com.paterva.maltego.chatapi.msg.LogMessageLevel;
import com.paterva.maltego.collab.CollaborationException;
import com.paterva.maltego.collab.session.xmpp.XmppCollaborationConnection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smackx.ServiceDiscoveryManager;
import org.jivesoftware.smackx.packet.DiscoverInfo;
import org.jivesoftware.smackx.packet.DiscoverItems;

abstract class FindConferenceStrategy {
    FindConferenceStrategy() {
    }

    public static FindConferenceStrategy quick() {
        return new Quick();
    }

    public static FindConferenceStrategy brute() {
        return new Brute();
    }

    public String getConferenceService(XmppCollaborationConnection cn, String service, ConnectionInitiationCallback callback) throws CollaborationException {
        try {
            ServiceDiscoveryManager discoManager = cn.getDisoveryManager();
            callback.progress(LogMessageLevel.Info, "Discovering from " + service);
            DiscoverItems discoItems = discoManager.discoverItems(service);
            Iterator it = discoItems.getItems();
            return this.getConferenceService(discoManager, it, callback);
        }
        catch (XMPPException ex) {
            throw new CollaborationException(ex, true);
        }
    }

    protected abstract String getConferenceService(ServiceDiscoveryManager var1, Iterator<DiscoverItems.Item> var2, ConnectionInitiationCallback var3) throws XMPPException;

    protected Set<String> getFeatures(ServiceDiscoveryManager discoManager, String service, ConnectionInitiationCallback callback) throws XMPPException {
        HashSet<String> set = new HashSet<String>();
        if (!callback.isCancelled()) {
            callback.progress(LogMessageLevel.Info, "Discovering from " + service);
            DiscoverInfo discInfo = discoManager.discoverInfo(service);
            Iterator features = discInfo.getFeatures();
            while (features.hasNext()) {
                DiscoverInfo.Feature feature = (DiscoverInfo.Feature)features.next();
                set.add(feature.getVar());
            }
        }
        return set;
    }

    protected boolean hasConference(Set<String> features) {
        return features.contains("http://jabber.org/protocol/muc");
    }

    private static class Brute
    extends FindConferenceStrategy {
        private Brute() {
        }

        @Override
        protected String getConferenceService(ServiceDiscoveryManager discoManager, Iterator<DiscoverItems.Item> items, ConnectionInitiationCallback callback) throws XMPPException {
            while (items.hasNext() && !callback.isCancelled()) {
                DiscoverItems.Item item = items.next();
                Set<String> features = this.getFeatures(discoManager, item.getEntityID(), callback);
                if (!this.hasConference(features)) continue;
                return item.getEntityID();
            }
            return null;
        }
    }

    private static class Quick
    extends FindConferenceStrategy {
        private Quick() {
        }

        private boolean contains(String name, String s) {
            if (name == null) {
                return false;
            }
            return name.toLowerCase().contains(s);
        }

        @Override
        protected String getConferenceService(ServiceDiscoveryManager discoManager, Iterator<DiscoverItems.Item> items, ConnectionInitiationCallback callback) throws XMPPException {
            while (items.hasNext() && !callback.isCancelled()) {
                DiscoverItems.Item item = items.next();
                Set<String> features = this.getFeatures(discoManager, item.getEntityID(), callback);
                if (!this.hasConference(features)) continue;
                return item.getEntityID();
            }
            Brute brute = new Brute();
            return brute.getConferenceService(discoManager, items, callback);
        }
    }
}

