/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URLDecoder;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xlightweb.HttpRequest;
import org.xlightweb.HttpRequestHeaderWrapper;
import org.xlightweb.HttpRequestWrapper;
import org.xlightweb.HttpResponse;
import org.xlightweb.IBodyCloseListener;
import org.xlightweb.IBodyCompleteListener;
import org.xlightweb.IBodyDataHandler;
import org.xlightweb.IHttpConnectHandler;
import org.xlightweb.IHttpConnection;
import org.xlightweb.IHttpConnectionHandler;
import org.xlightweb.IHttpDisconnectHandler;
import org.xlightweb.IHttpMessage;
import org.xlightweb.IHttpRequest;
import org.xlightweb.IHttpRequestHandler;
import org.xlightweb.IHttpRequestTimeoutHandler;
import org.xlightweb.IHttpResponse;
import org.xlightweb.IHttpResponseHandler;
import org.xlightweb.IPartHandler;
import org.xlightweb.InvokeOn;
import org.xlightweb.NonBlockingBodyDataSource;
import org.xlightweb.PartHandlerInfo;
import org.xlightweb.RequestHandlerInfo;
import org.xlightweb.ResponseHandlerInfo;
import org.xlightweb.SynchronizedOn;
import org.xsocket.DataConverter;
import org.xsocket.Execution;
import org.xsocket.Resource;
import org.xsocket.connection.ConnectionUtils;
import org.xsocket.connection.IServer;
import org.xsocket.connection.IWriteCompletionHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HttpUtils {
    static final byte CR = 13;
    static final byte LF = 10;
    static final byte SPACE = 32;
    static final byte HTAB = 9;
    private static final Logger LOG = Logger.getLogger(HttpUtils.class.getName());
    private static final Map<Class, Boolean> bodyDataExecutionModeCache = HttpUtils.newMapCache(25);
    private static final Map<Class, Boolean> bodyCompleteListenerExecutionModeCache = HttpUtils.newMapCache(25);
    private static final Map<Class, Boolean> requestTimeoutHandlerExecutionModeCache = HttpUtils.newMapCache(25);
    private static final Map<Class, CompletionHandlerInfo> completionHandlerInfoCache = ConnectionUtils.newMapCache((int)25);
    private static final Map<Class, Boolean> bodyCloseListenerExecutionModeCache = HttpUtils.newMapCache(25);
    private static final Map<Class, RequestHandlerInfo> httpRequestHandlerInfoCache = HttpUtils.newMapCache(25);
    private static RequestHandlerInfo emptyHttpRequestHandlerInfo;
    private static final Map<Class, PartHandlerInfo> partHandlerInfoCache;
    private static PartHandlerInfo emptyPartHandlerInfo;
    private static final Map<Class, ResponseHandlerInfo> httpResponseHandlerInfoCache;
    private static ResponseHandlerInfo emptyResponseHandlerInfo;
    private static final Map<Class, HttpConnectionHandlerInfo> httpConnectionHandlerInfoCache;
    private static final HttpConnectionHandlerInfo EMPTY_HTTP_CONNECTION_HANDLER_INFO;
    private static String implementationVersion;
    private static String implementationDate;
    private static String xSocketImplementationVersion;
    private static Map<String, String> mimeTypeMap;
    private static boolean showDetailedError;
    private static final char[] ISO_8859_1_Array;
    private static final byte[] base64;

    private HttpUtils() {
    }

    static char[] getISO_8859_1_Array() {
        return ISO_8859_1_Array;
    }

    public static boolean isShowDetailedError() {
        return showDetailedError;
    }

    public static String getReason(int statusCode) {
        switch (statusCode) {
            case 200: {
                return "OK";
            }
            case 201: {
                return "Created";
            }
            case 304: {
                return "Not Modifed";
            }
            case 401: {
                return "Unauthorized";
            }
            case 404: {
                return "Not found";
            }
            case 500: {
                return "Internal Server Error";
            }
            case 501: {
                return "Not Implemented";
            }
            case 502: {
                return "Bad Gateway";
            }
            case 503: {
                return "Service Unavailable";
            }
            case 504: {
                return "Gateway Timeout";
            }
            case 505: {
                return "HTTP Version Not Supported";
            }
        }
        return " ";
    }

    public static byte[] encodeBase64(byte[] bytes) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int got = -1;
        int off = 0;
        int count = 0;
        while ((got = in.read(buffer, off, 1024 - off)) > 0) {
            if (got >= 3) {
                got += off;
                off = 0;
                while (off + 3 <= got) {
                    int c1 = (buffer[off] & 0xFC) >> 2;
                    int c2 = (buffer[off] & 3) << 4 | (buffer[off + 1] & 0xF0) >>> 4;
                    int c3 = (buffer[off + 1] & 0xF) << 2 | (buffer[off + 2] & 0xC0) >>> 6;
                    int c4 = buffer[off + 2] & 0x3F;
                    switch (count) {
                        case 73: {
                            out.write(base64[c1]);
                            out.write(base64[c2]);
                            out.write(base64[c3]);
                            out.write(10);
                            out.write(base64[c4]);
                            count = 1;
                            break;
                        }
                        case 74: {
                            out.write(base64[c1]);
                            out.write(base64[c2]);
                            out.write(10);
                            out.write(base64[c3]);
                            out.write(base64[c4]);
                            count = 2;
                            break;
                        }
                        case 75: {
                            out.write(base64[c1]);
                            out.write(10);
                            out.write(base64[c2]);
                            out.write(base64[c3]);
                            out.write(base64[c4]);
                            count = 3;
                            break;
                        }
                        case 76: {
                            out.write(10);
                            out.write(base64[c1]);
                            out.write(base64[c2]);
                            out.write(base64[c3]);
                            out.write(base64[c4]);
                            count = 4;
                            break;
                        }
                        default: {
                            out.write(base64[c1]);
                            out.write(base64[c2]);
                            out.write(base64[c3]);
                            out.write(base64[c4]);
                            count += 4;
                        }
                    }
                    off += 3;
                }
                for (int i = 0; i < 3; ++i) {
                    buffer[i] = i < got - off ? buffer[off + i] : (byte)0;
                }
                off = got - off;
                continue;
            }
            off += got;
        }
        switch (off) {
            case 1: {
                out.write(base64[(buffer[0] & 0xFC) >> 2]);
                out.write(base64[(buffer[0] & 3) << 4 | (buffer[1] & 0xF0) >>> 4]);
                out.write(61);
                out.write(61);
                break;
            }
            case 2: {
                out.write(base64[(buffer[0] & 0xFC) >> 2]);
                out.write(base64[(buffer[0] & 3) << 4 | (buffer[1] & 0xF0) >>> 4]);
                out.write(base64[(buffer[1] & 0xF) << 2 | (buffer[2] & 0xC0) >>> 6]);
                out.write(61);
            }
        }
        return out.toByteArray();
    }

    public static int validateSufficientDatasizeByIntLengthField(NonBlockingBodyDataSource stream) throws IOException, BufferUnderflowException {
        return HttpUtils.validateSufficientDatasizeByIntLengthField(stream, true);
    }

    public static int validateSufficientDatasizeByIntLengthField(NonBlockingBodyDataSource stream, boolean removeLengthField) throws IOException, BufferUnderflowException {
        stream.resetToReadMark();
        stream.markReadPosition();
        int length = stream.readInt();
        if (stream.available() < length) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("insufficient data. require " + length + " got " + stream.available());
            }
            throw new BufferUnderflowException();
        }
        if (!removeLengthField) {
            stream.resetToReadMark();
        }
        stream.removeReadMark();
        return length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized Map<String, String> getMimeTypeMapping() {
        block18: {
            if (mimeTypeMap == null) {
                HashMap<String, String> map = new HashMap<String, String>();
                mimeTypeMap = Collections.unmodifiableMap(map);
                InputStreamReader isr = null;
                BufferedReader lnr = null;
                try {
                    isr = new InputStreamReader(HttpUtils.class.getResourceAsStream("/org/xlightweb/mime.types"));
                    if (isr == null) break block18;
                    lnr = new LineNumberReader(isr);
                    String line = null;
                    while ((line = ((LineNumberReader)lnr).readLine()) != null) {
                        if ((line = line.trim()).startsWith("#")) continue;
                        StringTokenizer st = new StringTokenizer(line);
                        if (st.hasMoreTokens()) {
                            String mimeType = st.nextToken();
                            while (st.hasMoreTokens()) {
                                String extension = st.nextToken();
                                map.put(extension, mimeType);
                                if (!LOG.isLoggable(Level.FINER)) continue;
                                LOG.finer("mapping " + extension + " -> " + mimeType + " added");
                            }
                            continue;
                        }
                        if (!LOG.isLoggable(Level.FINE)) continue;
                        LOG.fine("line " + line + "ignored");
                    }
                    lnr.close();
                }
                catch (Exception ioe) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("could not read mime.types. reason: " + ioe.toString());
                    }
                }
                finally {
                    block19: {
                        try {
                            if (lnr != null) {
                                lnr.close();
                            }
                            if (isr != null) {
                                isr.close();
                            }
                        }
                        catch (IOException ioe) {
                            if (!LOG.isLoggable(Level.FINE)) break block19;
                            LOG.fine("exception occured by closing mime.types file stream " + ioe.toString());
                        }
                    }
                }
            }
        }
        return mimeTypeMap;
    }

    static void injectServerField(Object handler, IServer server) {
        Field[] fields;
        for (Field field : fields = handler.getClass().getDeclaredFields()) {
            if (!field.isAnnotationPresent(Resource.class)) continue;
            Resource res = field.getAnnotation(Resource.class);
            if (field.getType() != IServer.class && res.type() != IServer.class) continue;
            field.setAccessible(true);
            try {
                field.set(handler, server);
            }
            catch (IllegalAccessException iae) {
                LOG.warning("could not set HandlerContext for attribute " + field.getName() + ". Reason " + iae.toString());
            }
        }
    }

    static boolean isContentTypeFormUrlencoded(IHttpMessage message) {
        if (!message.hasBody()) {
            return false;
        }
        String contentType = message.getContentType();
        return contentType != null && contentType.startsWith("application/x-www-form-urlencoded");
    }

    static String getContentTypedFormUrlencodedEncodingType(IHttpMessage message) {
        String[] parts;
        String contentType = message.getContentType();
        if (contentType != null && contentType.startsWith("application/x-www-form-urlencoded") && (parts = contentType.split(";")).length > 1) {
            for (int i = 1; i < parts.length; ++i) {
                String[] kvp = parts[i].split("=");
                if (!kvp[0].trim().toUpperCase().equals("CHARSET")) continue;
                return kvp[1].trim();
            }
        }
        return "UTF-8";
    }

    static IHttpRequest newFormEncodedRequestWrapper(IHttpRequest request) throws IOException {
        if (request instanceof HttpRequestWrapper) {
            return request;
        }
        return new HttpRequestWrapper(new ExtendedHttpRequestHeaderWrapper(request), request);
    }

    static RequestHandlerInfo getHttpRequestHandlerInfo(IHttpRequestHandler httpRequestHandler) {
        if (httpRequestHandler == null) {
            if (emptyHttpRequestHandlerInfo == null) {
                emptyHttpRequestHandlerInfo = new RequestHandlerInfo(null);
            }
            return emptyHttpRequestHandlerInfo;
        }
        RequestHandlerInfo httpRequestHandlerInfo = httpRequestHandlerInfoCache.get(httpRequestHandler.getClass());
        if (httpRequestHandlerInfo == null) {
            httpRequestHandlerInfo = new RequestHandlerInfo(httpRequestHandler.getClass());
            httpRequestHandlerInfoCache.put(httpRequestHandler.getClass(), httpRequestHandlerInfo);
        }
        return httpRequestHandlerInfo;
    }

    static CompletionHandlerInfo getCompletionHandlerInfo(IWriteCompletionHandler handler) {
        CompletionHandlerInfo completionHandlerInfo = completionHandlerInfoCache.get(handler.getClass());
        if (completionHandlerInfo == null) {
            completionHandlerInfo = new CompletionHandlerInfo(handler);
            completionHandlerInfoCache.put(handler.getClass(), completionHandlerInfo);
        }
        return completionHandlerInfo;
    }

    static PartHandlerInfo getPartHandlerInfo(IPartHandler partHandler) {
        if (partHandler == null) {
            if (emptyPartHandlerInfo == null) {
                emptyPartHandlerInfo = new PartHandlerInfo(null);
            }
            return emptyPartHandlerInfo;
        }
        PartHandlerInfo partHandlerInfo = partHandlerInfoCache.get(partHandler.getClass());
        if (partHandlerInfo == null) {
            partHandlerInfo = new PartHandlerInfo(partHandler.getClass());
            partHandlerInfoCache.put(partHandler.getClass(), partHandlerInfo);
        }
        return partHandlerInfo;
    }

    static ResponseHandlerInfo getHttpResponseHandlerInfo(IHttpResponseHandler httpResponseHandler) {
        if (httpResponseHandler == null) {
            if (emptyResponseHandlerInfo == null) {
                emptyResponseHandlerInfo = new ResponseHandlerInfo(null);
            }
            return emptyResponseHandlerInfo;
        }
        ResponseHandlerInfo httpResponseHandlerInfo = httpResponseHandlerInfoCache.get(httpResponseHandler.getClass());
        if (httpResponseHandlerInfo == null) {
            httpResponseHandlerInfo = new ResponseHandlerInfo(httpResponseHandler.getClass());
            httpResponseHandlerInfoCache.put(httpResponseHandler.getClass(), httpResponseHandlerInfo);
        }
        return httpResponseHandlerInfo;
    }

    static HttpConnectionHandlerInfo getHttpConnectionHandlerInfo(IHttpConnectionHandler httpConnectionHandler) {
        if (httpConnectionHandler == null) {
            return EMPTY_HTTP_CONNECTION_HANDLER_INFO;
        }
        HttpConnectionHandlerInfo httpConnectionHandlerInfo = httpConnectionHandlerInfoCache.get(httpConnectionHandler.getClass());
        if (httpConnectionHandlerInfo == null) {
            httpConnectionHandlerInfo = new HttpConnectionHandlerInfo(httpConnectionHandler.getClass());
            httpConnectionHandlerInfoCache.put(httpConnectionHandler.getClass(), httpConnectionHandlerInfo);
        }
        return httpConnectionHandlerInfo;
    }

    static RequestHandlerInfo getRequestHandlerInfo(IHttpRequestHandler requestHandler) {
        return HttpUtils.getHttpRequestHandlerInfo(requestHandler);
    }

    static ResponseHandlerInfo getResponseHandlerInfo(IHttpResponseHandler responseHandler) {
        return HttpUtils.getHttpResponseHandlerInfo(responseHandler);
    }

    static boolean isMutlithreaded(IBodyDataHandler bodyHandler) {
        Boolean isMutlithreaded = bodyDataExecutionModeCache.get(bodyHandler.getClass());
        if (isMutlithreaded == null) {
            int mode;
            block5: {
                mode = 1;
                Execution execution = bodyHandler.getClass().getAnnotation(Execution.class);
                if (execution != null) {
                    mode = execution.value();
                }
                try {
                    Method meth = bodyHandler.getClass().getMethod("onData", NonBlockingBodyDataSource.class);
                    execution = meth.getAnnotation(Execution.class);
                    if (execution != null) {
                        mode = execution.value();
                    }
                }
                catch (NoSuchMethodException nsme) {
                    if (!LOG.isLoggable(Level.FINE)) break block5;
                    LOG.fine("shouldn't occure because body handler has to have such a method " + nsme.toString());
                }
            }
            isMutlithreaded = mode == 1;
            bodyDataExecutionModeCache.put(bodyHandler.getClass(), isMutlithreaded);
        }
        return isMutlithreaded;
    }

    static String parseEncoding(String contentType) {
        int pos2;
        int pos = contentType.indexOf(59);
        if (pos > 0 && (pos2 = contentType.indexOf("charset=", pos + 1)) > 0) {
            String encoding = contentType.substring(pos2 + "charset=".length(), contentType.length()).trim();
            if (encoding.indexOf(59) != -1) {
                encoding = encoding.substring(0, encoding.indexOf(59));
            }
            return encoding;
        }
        return null;
    }

    static String parseEncoding(String contentType, String dflt) {
        String encoding = HttpUtils.parseEncoding(contentType);
        if (encoding == null) {
            return dflt;
        }
        return encoding;
    }

    static boolean isBodyCompleteListenerMutlithreaded(IBodyCompleteListener completeListener) {
        Boolean isMutlithreaded = bodyCompleteListenerExecutionModeCache.get(completeListener.getClass());
        if (isMutlithreaded == null) {
            int mode;
            block5: {
                mode = 1;
                Execution execution = completeListener.getClass().getAnnotation(Execution.class);
                if (execution != null) {
                    mode = execution.value();
                }
                try {
                    Method meth = completeListener.getClass().getMethod("onComplete", new Class[0]);
                    execution = meth.getAnnotation(Execution.class);
                    if (execution != null) {
                        mode = execution.value();
                    }
                }
                catch (NoSuchMethodException nsme) {
                    if (!LOG.isLoggable(Level.FINE)) break block5;
                    LOG.fine("shouldn't occure because body handler has to have such a method " + nsme.toString());
                }
            }
            isMutlithreaded = mode == 1;
            bodyCompleteListenerExecutionModeCache.put(completeListener.getClass(), isMutlithreaded);
        }
        return isMutlithreaded;
    }

    public static IHttpRequest copy(IHttpRequest request) throws IOException {
        if (request.hasBody()) {
            if (!request.getNonBlockingBody().isComplete()) {
                throw new IOException("copy is only supported for complete received messages (hint: uses @InvokeOn(InvokeOn.MESSAGE_RECEIVED) annotation)");
            }
            return new HttpRequest(request.getRequestHeader().copy(), request.getNonBlockingBody().copyContent());
        }
        return new HttpRequest(request.getRequestHeader().copy());
    }

    public static IHttpResponse copy(IHttpResponse response) throws IOException {
        if (response.hasBody()) {
            if (!response.getNonBlockingBody().isComplete()) {
                throw new IOException("copy is only supported for complete received messages (hint: uses @InvokeOn(InvokeOn.MESSAGE_RECEIVED) annotation)");
            }
            return new HttpResponse(response.getResponseHeader().copy(), response.getNonBlockingBody().copyContent());
        }
        return new HttpResponse(response.getResponseHeader().copy());
    }

    static int computeRemaining(ByteBuffer[] bufs) {
        int remaining = 0;
        for (ByteBuffer byteBuffer : bufs) {
            remaining += byteBuffer.remaining();
        }
        return remaining;
    }

    static ByteBuffer copy(ByteBuffer buffer) {
        if (buffer == null) {
            return null;
        }
        return ByteBuffer.wrap(DataConverter.toBytes((ByteBuffer)buffer));
    }

    static ByteBuffer[] copy(ByteBuffer[] buffers) {
        if (buffers == null) {
            return null;
        }
        ByteBuffer[] copy = new ByteBuffer[buffers.length];
        for (int i = 0; i < copy.length; ++i) {
            copy[i] = HttpUtils.copy(buffers[i]);
        }
        return copy;
    }

    static boolean isRequestTimeoutHandlerMultithreaded(Class<IHttpRequestTimeoutHandler> clazz) {
        Boolean isMultithreaded = requestTimeoutHandlerExecutionModeCache.get(clazz);
        if (isMultithreaded == null) {
            int mode;
            block5: {
                mode = 1;
                Execution execution = clazz.getAnnotation(Execution.class);
                if (execution != null) {
                    mode = execution.value();
                }
                try {
                    Method meth = clazz.getMethod("onRequestTimeout", IHttpConnection.class);
                    execution = meth.getAnnotation(Execution.class);
                    if (execution != null) {
                        mode = execution.value();
                    }
                }
                catch (NoSuchMethodException nsme) {
                    if (!LOG.isLoggable(Level.FINE)) break block5;
                    LOG.fine("shouldn't occure because request timeout handlerr has to have such a method " + nsme.toString());
                }
            }
            isMultithreaded = mode == 1;
            bodyCompleteListenerExecutionModeCache.put(clazz, isMultithreaded);
        }
        return isMultithreaded;
    }

    static boolean isBodyCloseListenerMutlithreaded(IBodyCloseListener closeListener) {
        Boolean isMutlithreaded = bodyCloseListenerExecutionModeCache.get(closeListener.getClass());
        if (isMutlithreaded == null) {
            int mode;
            block5: {
                mode = 1;
                Execution execution = closeListener.getClass().getAnnotation(Execution.class);
                if (execution != null) {
                    mode = execution.value();
                }
                try {
                    Method meth = closeListener.getClass().getMethod("onClose", new Class[0]);
                    execution = meth.getAnnotation(Execution.class);
                    if (execution != null) {
                        mode = execution.value();
                    }
                }
                catch (NoSuchMethodException nsme) {
                    if (!LOG.isLoggable(Level.FINE)) break block5;
                    LOG.fine("shouldn't occure because body handler has to have such a method " + nsme.toString());
                }
            }
            isMutlithreaded = mode == 1;
            bodyCloseListenerExecutionModeCache.put(closeListener.getClass(), isMutlithreaded);
        }
        return isMutlithreaded;
    }

    static Map<String, List<String>> parseParamters(String txt, String encoding) {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        try {
            String[] params;
            for (String param : params = txt.split("&")) {
                String[] kv = param.split("=");
                if (kv.length <= 1) continue;
                String name = URLDecoder.decode(kv[0], encoding);
                ArrayList<String> values = (ArrayList<String>)result.get(name);
                if (values == null) {
                    values = new ArrayList<String>();
                    result.put(name, values);
                }
                values.add(URLDecoder.decode(kv[1], encoding));
            }
            return result;
        }
        catch (UnsupportedEncodingException use) {
            throw new RuntimeException(use.toString());
        }
    }

    public static String getImplementationVersion() {
        if (implementationVersion == null) {
            HttpUtils.readVersionFile();
        }
        return implementationVersion;
    }

    static String getXSocketImplementationVersion() {
        if (xSocketImplementationVersion == null) {
            HttpUtils.readVersionFile();
        }
        return xSocketImplementationVersion;
    }

    public static String getImplementationDate() {
        if (implementationDate == null) {
            HttpUtils.readVersionFile();
        }
        return implementationDate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void readVersionFile() {
        implementationVersion = "<unknown>";
        implementationDate = "<unknown>";
        InputStreamReader isr = null;
        BufferedReader lnr = null;
        try {
            isr = new InputStreamReader(HttpUtils.class.getResourceAsStream("/org/xlightweb/version.txt"));
            if (isr != null) {
                lnr = new LineNumberReader(isr);
                String line = null;
                do {
                    if ((line = ((LineNumberReader)lnr).readLine()) == null) continue;
                    if (line.startsWith("Implementation-Version=")) {
                        implementationVersion = line.substring("Implementation-Version=".length(), line.length()).trim();
                        continue;
                    }
                    if (line.startsWith("Implementation-Date=")) {
                        implementationDate = line.substring("Implementation-Date=".length(), line.length()).trim();
                        continue;
                    }
                    if (!line.startsWith("Dependency.xSocket.Implementation-Version=")) continue;
                    xSocketImplementationVersion = line.substring("Dependency.xSocket.Implementation-Version=".length(), line.length()).trim();
                } while (line != null);
                lnr.close();
            }
        }
        catch (Exception ioe) {
            implementationDate = "<unknown>";
            implementationVersion = "<unknown>";
            xSocketImplementationVersion = "<unknown>";
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("could not read version file. reason: " + ioe.toString());
            }
        }
        finally {
            block19: {
                try {
                    if (lnr != null) {
                        lnr.close();
                    }
                    if (isr != null) {
                        isr.close();
                    }
                }
                catch (IOException ioe) {
                    if (!LOG.isLoggable(Level.FINE)) break block19;
                    LOG.fine("exception occured by closing version.txt file stream " + ioe.toString());
                }
            }
        }
    }

    public static boolean isHandlerMultithreaded(Class<? extends Object> clazz, boolean dflt) {
        Execution execution = clazz.getAnnotation(Execution.class);
        if (execution != null) {
            return execution.value() != 0;
        }
        return dflt;
    }

    public static boolean isMethodMultithreaded(Class clazz, String methodname, boolean dflt, Class ... paramClass) {
        try {
            Method meth = clazz.getMethod(methodname, paramClass);
            Execution execution = meth.getAnnotation(Execution.class);
            if (execution != null) {
                return execution.value() != 0;
            }
            return dflt;
        }
        catch (NoSuchMethodException nsme) {
            return dflt;
        }
    }

    static boolean isSynchronizedOnSession(Class<? extends Object> clazz, boolean dflt) {
        SynchronizedOn synchronizedOn = clazz.getAnnotation(SynchronizedOn.class);
        if (synchronizedOn != null) {
            return synchronizedOn.value() == 1;
        }
        return dflt;
    }

    static boolean isSynchronizedOnSession(Class clazz, String methodname, boolean dflt, Class ... paramClass) {
        try {
            Method meth = clazz.getMethod(methodname, paramClass);
            SynchronizedOn synchronizedOn = meth.getAnnotation(SynchronizedOn.class);
            if (synchronizedOn != null) {
                return synchronizedOn.value() == 1;
            }
            return dflt;
        }
        catch (NoSuchMethodException nsme) {
            return dflt;
        }
    }

    static boolean isInvokeOnMessageReceived(Class<? extends Object> clazz, boolean dflt) {
        InvokeOn invokeOn = clazz.getAnnotation(InvokeOn.class);
        if (invokeOn != null) {
            return invokeOn.value() == 1;
        }
        return dflt;
    }

    static boolean isInvokeOnMessageReceived(Class clazz, String methodname, boolean dflt, Class ... paramClass) {
        try {
            Method meth = clazz.getMethod(methodname, paramClass);
            InvokeOn invokeOn = meth.getAnnotation(InvokeOn.class);
            if (invokeOn != null) {
                return invokeOn.value() == 1;
            }
            return dflt;
        }
        catch (NoSuchMethodException nsme) {
            return dflt;
        }
    }

    public static <T, E> Map<T, E> newMapCache(int maxSize) {
        return Collections.synchronizedMap(new Cache(maxSize));
    }

    static {
        partHandlerInfoCache = HttpUtils.newMapCache(25);
        httpResponseHandlerInfoCache = HttpUtils.newMapCache(25);
        httpConnectionHandlerInfoCache = HttpUtils.newMapCache(25);
        EMPTY_HTTP_CONNECTION_HANDLER_INFO = new HttpConnectionHandlerInfo(null);
        showDetailedError = Boolean.parseBoolean(System.getProperty("org.xlightweb.showDetailedError", "false"));
        ISO_8859_1_Array = new char[256];
        for (int i = 0; i < ISO_8859_1_Array.length; ++i) {
            try {
                HttpUtils.ISO_8859_1_Array[i] = new String(new byte[]{(byte)i}, "ISO-8859-1").charAt(0);
                continue;
            }
            catch (UnsupportedEncodingException use) {
                throw new RuntimeException(use);
            }
        }
        base64 = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47, 61};
    }

    static final class CompletionHandlerInfo {
        private boolean isOnWrittenMultithreaded = false;
        private boolean isOnExceptionMultithreaded = false;

        public CompletionHandlerInfo(IWriteCompletionHandler handler) {
            boolean isHandlerMultithreaded = HttpUtils.isHandlerMultithreaded(handler.getClass(), true);
            this.isOnWrittenMultithreaded = HttpUtils.isMethodMultithreaded(handler.getClass(), "onWritten", isHandlerMultithreaded, Integer.TYPE);
            this.isOnExceptionMultithreaded = HttpUtils.isMethodMultithreaded(handler.getClass(), "onException", isHandlerMultithreaded, IOException.class);
        }

        public boolean isOnWrittenMultithreaded() {
            return this.isOnWrittenMultithreaded;
        }

        public boolean isOnExceptionMutlithreaded() {
            return this.isOnExceptionMultithreaded;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ExtendedHttpRequestHeaderWrapper
    extends HttpRequestHeaderWrapper {
        private static final Boolean NULL_BOOLEAN = null;
        private Map<String, List<String>> bodyParamsMap = new HashMap<String, List<String>>();

        ExtendedHttpRequestHeaderWrapper(IHttpRequest request) throws IOException {
            super(request.getRequestHeader());
            if (HttpUtils.isContentTypeFormUrlencoded(request) && request.hasBody()) {
                this.bodyParamsMap.putAll(HttpUtils.parseParamters(request.getNonBlockingBody().toString(), HttpUtils.getContentTypedFormUrlencodedEncodingType(request)));
            }
        }

        @Override
        public Integer getIntParameter(String name) {
            String s = this.getParameter(name);
            if (s != null) {
                return Integer.parseInt(s);
            }
            return null;
        }

        @Override
        public int getIntParameter(String name, int defaultVal) {
            String s = this.getParameter(name);
            if (s != null) {
                try {
                    return Integer.parseInt(s);
                }
                catch (Exception e) {
                    return defaultVal;
                }
            }
            return defaultVal;
        }

        @Override
        public Long getLongParameter(String name) {
            String s = this.getParameter(name);
            if (s != null) {
                return Long.parseLong(s);
            }
            return null;
        }

        @Override
        public long getLongParameter(String name, long defaultVal) {
            String s = this.getParameter(name);
            if (s != null) {
                try {
                    return Long.parseLong(s);
                }
                catch (Exception e) {
                    return defaultVal;
                }
            }
            return defaultVal;
        }

        @Override
        public Double getDoubleParameter(String name) {
            String s = this.getParameter(name);
            if (s != null) {
                return Double.parseDouble(s);
            }
            return null;
        }

        @Override
        public double getDoubleParameter(String name, double defaultVal) {
            String s = this.getParameter(name);
            if (s != null) {
                try {
                    return Double.parseDouble(s);
                }
                catch (Exception e) {
                    return defaultVal;
                }
            }
            return defaultVal;
        }

        @Override
        public Float getFloatParameter(String name) {
            String s = this.getParameter(name);
            if (s != null) {
                return Float.valueOf(Float.parseFloat(s));
            }
            return null;
        }

        @Override
        public float getFloatParameter(String name, float defaultVal) {
            String s = this.getParameter(name);
            if (s != null) {
                try {
                    return Float.parseFloat(s);
                }
                catch (Exception e) {
                    return defaultVal;
                }
            }
            return defaultVal;
        }

        @Override
        public Boolean getBooleanParameter(String name) {
            String s = this.getParameter(name);
            if (s != null) {
                return Boolean.parseBoolean(s);
            }
            return NULL_BOOLEAN;
        }

        @Override
        public boolean getBooleanParameter(String name, boolean defaultVal) {
            String s = this.getParameter(name);
            if (s != null) {
                try {
                    return Boolean.parseBoolean(s);
                }
                catch (Exception e) {
                    return defaultVal;
                }
            }
            return defaultVal;
        }

        @Override
        public String getParameter(String name) {
            if (this.bodyParamsMap.containsKey(name)) {
                return this.bodyParamsMap.get(name).get(0);
            }
            return this.getWrappedRequestHeader().getParameter(name);
        }

        @Override
        public String[] getParameterValues(String name) {
            ArrayList<String> result = new ArrayList<String>();
            if (this.bodyParamsMap.containsKey(name)) {
                result.addAll((Collection)this.bodyParamsMap.get(name));
            }
            String[] v = this.getWrappedRequestHeader().getParameterValues(name);
            result.addAll(Arrays.asList(v));
            return result.toArray(new String[result.size()]);
        }

        @Override
        public void setParameter(String parameterName, String parameterValue) {
            if (this.bodyParamsMap.containsKey(parameterName)) {
                throw new RuntimeException("parameter is contained in body and can not be modified");
            }
            this.getWrappedRequestHeader().setParameter(parameterName, parameterValue);
        }

        @Override
        public Set<String> getParameterNameSet() {
            HashSet<String> result = new HashSet<String>();
            result.addAll(this.getWrappedRequestHeader().getParameterNameSet());
            result.addAll(this.bodyParamsMap.keySet());
            return result;
        }

        @Override
        public Enumeration getParameterNames() {
            return Collections.enumeration(this.getParameterNameSet());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class HttpConnectionHandlerInfo {
        private boolean isConnectHandler = false;
        private boolean isConnectHandlerMultithreaded = true;
        private boolean isDisconnectHandler = false;
        private boolean isDisconnectHandlerMultithreaded = true;

        public HttpConnectionHandlerInfo(Class clazz) {
            if (clazz == null) {
                return;
            }
            if (IHttpConnectHandler.class.isAssignableFrom(clazz)) {
                this.isConnectHandler = true;
                this.isConnectHandlerMultithreaded = HttpConnectionHandlerInfo.isOnConnectMultithreaded(clazz);
            }
            if (IHttpDisconnectHandler.class.isAssignableFrom(clazz)) {
                this.isDisconnectHandler = true;
                this.isDisconnectHandlerMultithreaded = HttpConnectionHandlerInfo.isOnDisconnectMultithreaded(clazz);
            }
        }

        static boolean isOnConnectMultithreaded(Class<IHttpRequestHandler> serverHandlerClass) {
            int mode;
            block4: {
                mode = 1;
                Execution execution = serverHandlerClass.getAnnotation(Execution.class);
                if (execution != null) {
                    mode = execution.value();
                    return mode == 1;
                }
                try {
                    Method meth = serverHandlerClass.getMethod("onConnect", IHttpConnection.class);
                    execution = meth.getAnnotation(Execution.class);
                    if (execution != null) {
                        mode = execution.value();
                    }
                }
                catch (NoSuchMethodException nsme) {
                    if (!LOG.isLoggable(Level.FINE)) break block4;
                    LOG.fine("shouldn't occure because body handler has to have such a method " + nsme.toString());
                }
            }
            return mode == 1;
        }

        static boolean isOnDisconnectMultithreaded(Class<IHttpRequestHandler> serverHandlerClass) {
            int mode;
            block4: {
                mode = 1;
                Execution execution = serverHandlerClass.getAnnotation(Execution.class);
                if (execution != null) {
                    mode = execution.value();
                    return mode == 1;
                }
                try {
                    Method meth = serverHandlerClass.getMethod("onDisconnect", IHttpConnection.class);
                    execution = meth.getAnnotation(Execution.class);
                    if (execution != null) {
                        mode = execution.value();
                    }
                }
                catch (NoSuchMethodException nsme) {
                    if (!LOG.isLoggable(Level.FINE)) break block4;
                    LOG.fine("shouldn't occure because body handler has to have such a method " + nsme.toString());
                }
            }
            return mode == 1;
        }

        public boolean isConnectHandler() {
            return this.isConnectHandler;
        }

        public boolean isConnectHandlerMultithreaded() {
            return this.isConnectHandlerMultithreaded;
        }

        public boolean isDisconnectHandler() {
            return this.isDisconnectHandler;
        }

        public boolean isDisconnectHandlerMultithreaded() {
            return this.isDisconnectHandlerMultithreaded;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Cache<T, E>
    extends LinkedHashMap<T, E> {
        private static final long serialVersionUID = 4513864504007457500L;
        private int maxSize = 0;

        Cache(int maxSize) {
            this.maxSize = maxSize;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<T, E> eldest) {
            return this.size() > this.maxSize;
        }
    }
}

