/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.runner.impl;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.sound.SoundPlayer;
import com.paterva.maltego.transform.descriptor.InheritedTypesProvider;
import com.paterva.maltego.transform.descriptor.TransformDefinition;
import com.paterva.maltego.transform.descriptor.TransformDescriptor;
import com.paterva.maltego.transform.descriptor.TransformServerInfo;
import com.paterva.maltego.transform.runner.RegistryInheritedTypesProvider;
import com.paterva.maltego.transform.runner.api.TransformsHandle;
import com.paterva.maltego.transform.runner.api.impl.DefaultTransformRunManager;
import com.paterva.maltego.ui.graph.actions.UpdateViewAction;
import java.awt.event.ActionListener;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import org.netbeans.api.progress.aggregate.ProgressMonitor;
import org.openide.awt.Notification;
import org.openide.awt.NotificationDisplayer;
import org.openide.util.Cancellable;
import org.openide.util.ImageUtilities;
import org.openide.util.actions.SystemAction;

public class UITransformRunManager
extends DefaultTransformRunManager
implements Cancellable,
ProgressMonitor {
    private static final int COUNT_4_SOUND = 5;
    private boolean _playDoneSound = false;
    private final long _lastLicenseCheck = 0L;
    private static final int MinutesBetweenChecks = 30;
    private static final int MillisBetweenChecks = 1800000;

    public Map<EntityID, MaltegoEntity> getEntityIDs(GraphID graphID, Map<EntityID, MaltegoEntity> entities, TransformDescriptor transform, EntityRegistry registry) {
        RegistryInheritedTypesProvider typeProvider = new RegistryInheritedTypesProvider(graphID, registry, entities.keySet());
        Map ids = transform.getInputConstraint().getSatisfiedBy(graphID, entities, (InheritedTypesProvider)typeProvider);
        return ids;
    }

    public void cancel(TransformsHandle groupHandle) {
        this._playDoneSound = false;
        super.cancel(groupHandle);
    }

    public boolean cancel() {
        this._playDoneSound = false;
        return super.cancel();
    }

    protected void onTransformsStarted(Map<TransformDefinition, TransformServerInfo> transforms, GraphID graphID, Set<EntityID> entityIDs) {
        super.onTransformsStarted(transforms, graphID, entityIDs);
        if (transforms.size() * entityIDs.size() >= 5) {
            SoundPlayer.instance().play("txstart");
            this._playDoneSound = true;
        }
    }

    protected void onTransformsDone() {
        super.onTransformsDone();
        if (this._playDoneSound) {
            SoundPlayer.instance().play("txdone");
            this._playDoneSound = false;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                UpdateViewAction action = (UpdateViewAction)SystemAction.get(UpdateViewAction.class);
                if (action.isEnabled()) {
                    Notification notify = NotificationDisplayer.getDefault().notify("Transforms complete", (Icon)ImageUtilities.loadImageIcon((String)"com/paterva/maltego/ui/graph/impl/reload.png", (boolean)false), "Click here to update the graph", (ActionListener)action, NotificationDisplayer.Priority.HIGH);
                    UpdateViewAction.setNotification((Notification)notify);
                }
            }
        });
    }
}

