/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.lsp;

import java.util.List;
import java.util.function.Consumer;
import org.netbeans.api.lsp.CodeAction;
import org.netbeans.api.lsp.Position;

public class Diagnostic {
    private final Position startPosition;
    private final Position endPosition;
    private final String description;
    private final Severity severity;
    private final String code;
    private final LazyCodeActions actions;

    private Diagnostic(Position startPosition, Position endPosition, String description, Severity severity, String code, LazyCodeActions actions) {
        this.startPosition = startPosition;
        this.endPosition = endPosition;
        this.description = description;
        this.severity = severity;
        this.code = code;
        this.actions = actions;
    }

    public Position getStartPosition() {
        return this.startPosition;
    }

    public Position getEndPosition() {
        return this.endPosition;
    }

    public String getDescription() {
        return this.description;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public String getCode() {
        return this.code;
    }

    public LazyCodeActions getActions() {
        return this.actions;
    }

    public static interface LazyCodeActions {
        public List<CodeAction> computeCodeActions(Consumer<Exception> var1);
    }

    public static final class Builder {
        private final Position startPosition;
        private final Position endPosition;
        private final String description;
        private Severity severity;
        private String code;
        private LazyCodeActions actions;

        private Builder(Position startPosition, Position endPosition, String description) {
            this.startPosition = startPosition;
            this.endPosition = endPosition;
            this.description = description;
        }

        public static Builder create(Position startPosition, Position endPosition, String description) {
            return new Builder(startPosition, endPosition, description);
        }

        public Builder setSeverity(Severity severity) {
            this.severity = severity;
            return this;
        }

        public Builder setCode(String code) {
            this.code = code;
            return this;
        }

        public Builder addActions(LazyCodeActions actions) {
            this.actions = actions;
            return this;
        }

        public Diagnostic build() {
            return new Diagnostic(this.startPosition, this.endPosition, this.description, this.severity, this.code, this.actions);
        }
    }

    public static enum Severity {
        Error,
        Warning,
        Hint,
        Information;

    }
}

