/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.undo;

import com.paterva.maltego.graph.undo.Command;
import com.paterva.maltego.graph.undo.UndoRedoModel;
import com.paterva.maltego.graph.undo.UndoRedoStackAction;
import com.paterva.maltego.util.ui.WindowUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.undo.CannotUndoException;

public final class UndoStackAction
extends UndoRedoStackAction {
    @Override
    public String getName() {
        return "Undo";
    }

    @Override
    public String getDescription() {
        return "Undo the last action(s)";
    }

    @Override
    public String iconResource() {
        return "com/paterva/maltego/ui/graph/actions/UndoTaskBar.png";
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        UndoRedoModel undoRedo = this.getUndoRedo();
        if (undoRedo != null && undoRedo.canUndo()) {
            this.undo(undoRedo);
        }
    }

    @Override
    protected Command[] getCommands() {
        return this.getUndoRedo().getUndoStack();
    }

    @Override
    protected ActionListener createActionListener(Command command) {
        return new UndoUpToActionListener(command);
    }

    @Override
    protected void updateEnabledState() {
        UndoRedoModel undoRedo = this.getUndoRedo();
        boolean isEnabled = false;
        if (undoRedo != null) {
            isEnabled = undoRedo.canUndo();
        }
        this.setEnabled(isEnabled);
    }

    private void undo(UndoRedoModel undoRedo) throws CannotUndoException {
        try {
            WindowUtil.showWaitCursor();
            undoRedo.undo();
        }
        finally {
            WindowUtil.hideWaitCursor();
        }
    }

    private class UndoUpToActionListener
    implements ActionListener {
        private final Command _command;

        public UndoUpToActionListener(Command command) {
            this._command = command;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            UndoRedoModel undoRedo = UndoStackAction.this.getUndoRedo();
            Command[] undoStack = undoRedo.getUndoStack();
            int undoCount = 0;
            boolean found = false;
            for (Command cmd : undoStack) {
                ++undoCount;
                if (!cmd.equals(this._command)) continue;
                found = true;
                break;
            }
            if (found) {
                for (int i = 0; i < undoCount; ++i) {
                    if (undoRedo.canUndo()) {
                        UndoStackAction.this.undo(undoRedo);
                        continue;
                    }
                    System.out.println("Wanted to undo but can't!");
                }
            }
        }
    }
}

