/*
 * Decompiled with CFR 0.152.
 */
package org.officelaf;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import org.officelaf.OfficeRootPaneUI;

class RootPaneLayout
implements LayoutManager2 {
    private LayoutManager _delegate;

    public RootPaneLayout(LayoutManager delegate) {
        this._delegate = delegate;
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        Dimension tpd;
        JComponent titlePane;
        Dimension mbd;
        int cpWidth = 0;
        int cpHeight = 0;
        int mbWidth = 0;
        int mbHeight = 0;
        int tpWidth = 0;
        int tpHeight = 0;
        Insets i = parent.getInsets();
        JRootPane root = (JRootPane)parent;
        Dimension cpd = root.getContentPane() != null ? root.getContentPane().getPreferredSize() : root.getSize();
        if (cpd != null) {
            cpWidth = cpd.width;
            cpHeight = cpd.height;
        }
        if (root.getJMenuBar() != null && (mbd = root.getJMenuBar().getPreferredSize()) != null) {
            mbWidth = mbd.width;
            mbHeight = mbd.height;
        }
        if (root.getWindowDecorationStyle() != 0 && root.getUI() instanceof OfficeRootPaneUI && (titlePane = ((OfficeRootPaneUI)root.getUI()).getTitlePane()) != null && (tpd = titlePane.getPreferredSize()) != null) {
            tpWidth = tpd.width;
            tpHeight = tpd.height;
        }
        return new Dimension(Math.max(Math.max(cpWidth, mbWidth), tpWidth) + i.left + i.right, cpHeight + mbHeight + tpHeight + i.top + i.bottom);
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        Dimension tpd;
        JComponent titlePane;
        Dimension mbd;
        int cpWidth = 0;
        int cpHeight = 0;
        int mbWidth = 0;
        int mbHeight = 0;
        int tpWidth = 0;
        int tpHeight = 0;
        Insets i = parent.getInsets();
        JRootPane root = (JRootPane)parent;
        Dimension cpd = root.getContentPane() != null ? root.getContentPane().getMinimumSize() : root.getSize();
        if (cpd != null) {
            cpWidth = cpd.width;
            cpHeight = cpd.height;
        }
        if (root.getJMenuBar() != null && (mbd = root.getJMenuBar().getMinimumSize()) != null) {
            mbWidth = mbd.width;
            mbHeight = mbd.height;
        }
        if (root.getWindowDecorationStyle() != 0 && root.getUI() instanceof OfficeRootPaneUI && (titlePane = ((OfficeRootPaneUI)root.getUI()).getTitlePane()) != null && (tpd = titlePane.getMinimumSize()) != null) {
            tpWidth = tpd.width;
            tpHeight = tpd.height;
        }
        return new Dimension(Math.max(Math.max(cpWidth, mbWidth), tpWidth) + i.left + i.right, cpHeight + mbHeight + tpHeight + i.top + i.bottom);
    }

    @Override
    public Dimension maximumLayoutSize(Container target) {
        int maxWidth;
        int maxHeight;
        Dimension tpd;
        JComponent titlePane;
        Dimension mbd;
        Dimension cpd;
        int cpWidth = Integer.MAX_VALUE;
        int cpHeight = Integer.MAX_VALUE;
        int mbWidth = Integer.MAX_VALUE;
        int mbHeight = Integer.MAX_VALUE;
        int tpWidth = Integer.MAX_VALUE;
        int tpHeight = Integer.MAX_VALUE;
        Insets i = target.getInsets();
        JRootPane root = (JRootPane)target;
        if (root.getContentPane() != null && (cpd = root.getContentPane().getMaximumSize()) != null) {
            cpWidth = cpd.width;
            cpHeight = cpd.height;
        }
        if (root.getJMenuBar() != null && (mbd = root.getJMenuBar().getMaximumSize()) != null) {
            mbWidth = mbd.width;
            mbHeight = mbd.height;
        }
        if (root.getWindowDecorationStyle() != 0 && root.getUI() instanceof OfficeRootPaneUI && (titlePane = ((OfficeRootPaneUI)root.getUI()).getTitlePane()) != null && (tpd = titlePane.getMaximumSize()) != null) {
            tpWidth = tpd.width;
            tpHeight = tpd.height;
        }
        if ((maxHeight = Math.max(Math.max(cpHeight, mbHeight), tpHeight)) != Integer.MAX_VALUE) {
            maxHeight = cpHeight + mbHeight + tpHeight + i.top + i.bottom;
        }
        if ((maxWidth = Math.max(Math.max(cpWidth, mbWidth), tpWidth)) != Integer.MAX_VALUE) {
            maxWidth += i.left + i.right;
        }
        return new Dimension(maxWidth, maxHeight);
    }

    @Override
    public void layoutContainer(Container parent) {
        Dimension tpd;
        OfficeRootPaneUI ui;
        JComponent titlePane;
        JRootPane root = (JRootPane)parent;
        Rectangle b = root.getBounds();
        Insets i = root.getInsets();
        int nextY = 0;
        int w = b.width - i.right - i.left;
        int h = b.height - i.top - i.bottom;
        if (root.getLayeredPane() != null) {
            root.getLayeredPane().setBounds(i.left, i.top, w, h);
        }
        if (root.getGlassPane() != null) {
            root.getGlassPane().setBounds(i.left, i.top, w, h);
        }
        if (root.getWindowDecorationStyle() != 0 && root.getUI() instanceof OfficeRootPaneUI && (titlePane = (ui = (OfficeRootPaneUI)root.getUI()).getTitlePane()) != null && (tpd = titlePane.getPreferredSize()) != null) {
            int tpHeight = tpd.height;
            titlePane.setBounds(0, 0, w, tpHeight);
            nextY += tpHeight;
        }
        if (root.getContentPane() != null) {
            root.getContentPane().setBounds(0, nextY, w, h < nextY ? 0 : h - nextY);
        }
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
    }

    @Override
    public float getLayoutAlignmentX(Container target) {
        return 0.0f;
    }

    @Override
    public float getLayoutAlignmentY(Container target) {
        return 0.0f;
    }

    @Override
    public void invalidateLayout(Container target) {
    }
}

