/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.typing.editing.form;

import com.paterva.maltego.core.PropertyBag;
import com.paterva.maltego.typing.DataSource;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.typing.editing.form.ControlAdapter;
import com.paterva.maltego.typing.editing.form.Input;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.openide.util.WeakListeners;

class PropertyDescriptorInput
extends Input
implements PropertyChangeListener {
    private DataSource _dataSource;
    private PropertyDescriptor _descriptor;

    public PropertyDescriptorInput(PropertyDescriptor descriptor, DataSource dataSource, ControlAdapter adapter) {
        super(adapter);
        if (descriptor == null) {
            throw new IllegalArgumentException("Property descriptor cannot be null");
        }
        if (dataSource == null) {
            throw new IllegalArgumentException("Data source adapter cannot be null");
        }
        this._dataSource = dataSource;
        this._descriptor = descriptor;
        if (this._dataSource instanceof PropertyBag) {
            PropertyBag propertyBag = (PropertyBag)this._dataSource;
            propertyBag.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)propertyBag));
        }
    }

    private Object getValueFromDataSource() {
        return this._dataSource.getValue(this._descriptor);
    }

    private void setValueToDataSource(Object object) {
        this._dataSource.setValue(this._descriptor, object);
    }

    protected PropertyDescriptor getPropertyDescriptor() {
        return this._descriptor;
    }

    @Override
    public Class getType() {
        return this._descriptor.getType();
    }

    @Override
    public String getName() {
        return this._descriptor.getName();
    }

    @Override
    public String getDisplayName() {
        return this._descriptor.getDisplayName();
    }

    @Override
    public String getDescription() {
        return this._descriptor.getDescription();
    }

    @Override
    public boolean isHidden() {
        return this._descriptor.isHidden();
    }

    @Override
    public boolean canWrite() {
        return !this._descriptor.isReadonly();
    }

    @Override
    public boolean isRequired() {
        return !this._descriptor.isNullable();
    }

    @Override
    public boolean isReadOnly() {
        return this._descriptor.isReadonly();
    }

    @Override
    protected boolean validate(Object value) {
        this.setValueToDataSource(value);
        return super.validate(value);
    }

    @Override
    protected Object getInitialValue() {
        Object value = this.getValueFromDataSource();
        if (value == null) {
            value = this.getDefaultValue();
        }
        if (value == null) {
            value = super.getDefaultValue();
        }
        return value;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals(this._descriptor.getName())) {
            this.setValue(this.getValueFromDataSource());
        }
    }
}

