/*
 * Decompiled with CFR 0.152.
 */
package com.pinkmatter.pandora.lucene;

import com.pinkmatter.pandora.Artifact;
import com.pinkmatter.pandora.PandoraQueryResult;
import java.util.Iterator;

class PandoraQueryResultImpl
implements PandoraQueryResult {
    private final int _hitCount;
    private final Artifact[] _artifacts;
    private long[] _keys;
    private boolean _isDirty = true;

    public PandoraQueryResultImpl(Artifact[] artifacts, int hitCount) {
        this._hitCount = hitCount;
        this._artifacts = artifacts;
    }

    public int getHitCount() {
        return this._hitCount;
    }

    public int getCount() {
        return this._artifacts.length;
    }

    public boolean isEmpty() {
        return this._artifacts.length == 0;
    }

    public Artifact get(int index) throws IndexOutOfBoundsException {
        return this._artifacts[index];
    }

    public Artifact getFirst() {
        if (this._artifacts.length > 0) {
            return this._artifacts[0];
        }
        return null;
    }

    public Artifact getLast() {
        if (this._artifacts.length > 0) {
            return this._artifacts[this._artifacts.length - 1];
        }
        return null;
    }

    public long getFirstKey() {
        if (this._artifacts.length > 0) {
            return this._artifacts[0].getKey();
        }
        return -1L;
    }

    public long getLastKey() {
        if (this._artifacts.length > 0) {
            return this._artifacts[this._artifacts.length - 1].getKey();
        }
        return -1L;
    }

    public Iterator<Artifact> iterator() {
        return new Iterator<Artifact>(){
            private int index = -1;

            @Override
            public boolean hasNext() {
                return this.index + 1 < PandoraQueryResultImpl.this._artifacts.length;
            }

            @Override
            public Artifact next() {
                ++this.index;
                if (this.index < PandoraQueryResultImpl.this._artifacts.length) {
                    return PandoraQueryResultImpl.this._artifacts[this.index];
                }
                return null;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Not implemented");
            }
        };
    }

    public long[] getKeys() {
        if (this._isDirty) {
            this._keys = new long[this._artifacts.length];
            int i = 0;
            for (Artifact artifact : this._artifacts) {
                this._keys[i] = artifact.getKey();
                ++i;
            }
            this._isDirty = false;
        }
        return this._keys;
    }
}

