/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.java.config;

import com.paterva.maltego.java.config.jre.SystemUtils;
import java.util.Objects;

public class Java2DProperty {
    private final String displayName;
    private final String key;
    private boolean prefer;

    Java2DProperty(String displayName, String key, boolean value) {
        this.displayName = displayName;
        this.key = key;
        this.prefer = value;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getKey() {
        return this.key;
    }

    public boolean isPrefer() {
        return this.prefer;
    }

    public void setPrefer(boolean prefer) {
        this.prefer = prefer;
    }

    public static Java2DProperty getOpenGL() {
        return new Java2DProperty("OpenGL", "-J-Dsun.java2d.opengl", false);
    }

    public static Java2DProperty getD3D() {
        return new Java2DProperty("D3D", "-J-Dsun.java2d.d3d", SystemUtils.isWindows2());
    }

    public int hashCode() {
        int hash = 7;
        hash = 71 * hash + Objects.hashCode(this.displayName);
        hash = 71 * hash + Objects.hashCode(this.key);
        hash = 71 * hash + (this.prefer ? 1 : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Java2DProperty other = (Java2DProperty)obj;
        if (this.prefer != other.prefer) {
            return false;
        }
        if (!Objects.equals(this.displayName, other.displayName)) {
            return false;
        }
        return Objects.equals(this.key, other.key);
    }
}

