/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.java.config;

import com.paterva.maltego.java.config.IPVersion;
import java.util.Objects;

public class IPVersionSettings {
    public static final String MANAGED_DISPLAY_NAME = "Let Java choose which IP version stack and addresses to use";
    private boolean managed = true;
    private IPVersion ipv4 = IPVersion.getIPv4Stack();
    private IPVersion ipv6 = IPVersion.getIPv6Addresses();

    public IPVersionSettings() {
    }

    public IPVersionSettings(IPVersion ipv4, IPVersion ipv6) {
        this.ipv4 = ipv4;
        this.ipv6 = ipv6;
    }

    public boolean isManaged() {
        return this.managed;
    }

    public void setManaged(boolean managed) {
        this.managed = managed;
    }

    public IPVersion getIPv4() {
        return this.ipv4;
    }

    public IPVersion getIPv6() {
        return this.ipv6;
    }

    public int hashCode() {
        int hash = 5;
        hash = 53 * hash + (this.managed ? 1 : 0);
        hash = 53 * hash + Objects.hashCode(this.ipv4);
        hash = 53 * hash + Objects.hashCode(this.ipv6);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IPVersionSettings other = (IPVersionSettings)obj;
        if (this.managed != other.managed) {
            return false;
        }
        if (!Objects.equals(this.ipv4, other.ipv4)) {
            return false;
        }
        return Objects.equals(this.ipv6, other.ipv6);
    }
}

