/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.entity.manager.forms;

import com.paterva.maltego.typing.Converter;
import com.paterva.maltego.typing.DisplayDescriptor;
import com.paterva.maltego.typing.Evaluator;
import com.paterva.maltego.typing.serializer.EvaluatorFactory;
import com.paterva.maltego.util.StringUtilities;
import java.lang.reflect.InvocationTargetException;
import java.text.Format;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.Exceptions;
import org.openide.util.lookup.Lookups;

class DisplayDescriptorNode
extends AbstractNode {
    public DisplayDescriptorNode(DisplayDescriptor descriptor) {
        super(Children.LEAF, Lookups.singleton((Object)descriptor));
    }

    protected Sheet createSheet() {
        Sheet sheet = Sheet.createDefault();
        Sheet.Set display = Sheet.createPropertiesSet();
        Sheet.Set main = Sheet.createPropertiesSet();
        Sheet.Set defaults = Sheet.createPropertiesSet();
        main.setName("main");
        display.setName("display");
        defaults.setName("defaults");
        main.setDisplayName("Basic information");
        display.setDisplayName("Display information");
        defaults.setDisplayName("Defaults");
        DisplayDescriptor descriptor = (DisplayDescriptor)this.getLookup().lookup(DisplayDescriptor.class);
        try {
            Node.Property displayName = this.createReflectionProperty(descriptor, String.class, "DisplayName", "Display name", "The name displayed to the user.");
            Node.Property description = this.createReflectionProperty(descriptor, String.class, "Description", "Description", "Short description of this property.");
            Node.Property name = this.createReflectionProperty(descriptor, String.class, "getName", null, "Name", "The unique name that references this property.");
            Node.Property type = this.createReadOnlyProperty(String.class, descriptor.getTypeDescriptor().toString(), "Type", "The data type of this property.");
            Node.Property group = this.createReflectionProperty(descriptor, String.class, "GroupName", "Group", "Optional group name under which this property is visually ordered.");
            RequiredProperty mandatory = new RequiredProperty(descriptor);
            ReadonlyProperty readonly = new ReadonlyProperty(descriptor);
            HiddenProperty hidden = new HiddenProperty(descriptor);
            DefaultValueProperty defaultValue = new DefaultValueProperty(descriptor);
            SampleValueProperty sampleValue = new SampleValueProperty(descriptor);
            FormatProperty format = null;
            if (descriptor.getTypeDescriptor().getFormatAdapter() != null) {
                format = new FormatProperty(descriptor);
            }
            main.put(name);
            main.put(type);
            main.put((Node.Property)mandatory);
            main.put((Node.Property)readonly);
            main.put((Node.Property)hidden);
            display.put(displayName);
            display.put(description);
            if (format != null) {
                display.put((Node.Property)format);
            }
            defaults.put((Node.Property)defaultValue);
            defaults.put((Node.Property)sampleValue);
        }
        catch (NoSuchMethodException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        sheet.put(main);
        sheet.put(display);
        sheet.put(defaults);
        return sheet;
    }

    private Node.Property createReadOnlyProperty(Class<?> type, final Object value, String displayName, String shortDescription) {
        PropertySupport.ReadOnly property = new PropertySupport.ReadOnly(displayName, type, displayName, shortDescription){

            public Object getValue() throws IllegalAccessException, InvocationTargetException {
                return value;
            }
        };
        return property;
    }

    private Node.Property createReflectionProperty(Object obj, Class<?> type, String propertyName, String displayName, String shortDescription) throws NoSuchMethodException {
        PropertySupport.Reflection property = new PropertySupport.Reflection(obj, type, propertyName);
        property.setName(displayName);
        property.setDisplayName(displayName);
        property.setShortDescription(shortDescription);
        return property;
    }

    private Node.Property createReflectionProperty(Object obj, Class<?> type, String getter, String setter, String displayName, String shortDescription) throws NoSuchMethodException {
        PropertySupport.Reflection property = new PropertySupport.Reflection(obj, type, getter, setter);
        property.setName(displayName);
        property.setDisplayName(displayName);
        property.setShortDescription(shortDescription);
        return property;
    }

    public String getDisplayName() {
        DisplayDescriptor descriptor = (DisplayDescriptor)this.getLookup().lookup(DisplayDescriptor.class);
        return descriptor.getDisplayName();
    }

    public String getShortDescription() {
        DisplayDescriptor descriptor = (DisplayDescriptor)this.getLookup().lookup(DisplayDescriptor.class);
        return descriptor.getDescription();
    }

    private static class HiddenProperty
    extends PropertySupport.ReadWrite {
        private final DisplayDescriptor _descriptor;

        public HiddenProperty(DisplayDescriptor descriptor) {
            super("hidden", Boolean.class, "Hidden", "Indicates that this property is hidden from the user.");
            this._descriptor = descriptor;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this._descriptor.isHidden();
        }

        public void setValue(Object value) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            this._descriptor.setHidden(((Boolean)value).booleanValue());
        }
    }

    private static class ReadonlyProperty
    extends PropertySupport.ReadWrite {
        private final DisplayDescriptor _descriptor;

        public ReadonlyProperty(DisplayDescriptor descriptor) {
            super("reaonly", Boolean.class, "Read only", "Indicates that this property cannot be set by the user.");
            this._descriptor = descriptor;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this._descriptor.isReadonly();
        }

        public void setValue(Object value) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            this._descriptor.setReadonly(((Boolean)value).booleanValue());
        }
    }

    private static class RequiredProperty
    extends PropertySupport.ReadWrite {
        private DisplayDescriptor _descriptor;

        public RequiredProperty(DisplayDescriptor descriptor) {
            super("required", Boolean.class, "Required", "Indicates that this property cannot be left blank.");
            this._descriptor = descriptor;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return !this._descriptor.isNullable();
        }

        public void setValue(Object value) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            this._descriptor.setNullable((Boolean)value == false);
        }
    }

    private static class FormatProperty
    extends PropertySupport.ReadWrite {
        private DisplayDescriptor _descriptor;

        public FormatProperty(DisplayDescriptor descriptor) {
            super("format", String.class, "Format", "Optional format specifier used when rendering values (highly dependant on data type).");
            this._descriptor = descriptor;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            Format format = this._descriptor.getFormat();
            String formatStr = this._descriptor.getTypeDescriptor().getFormatString(format);
            return formatStr == null ? "" : formatStr;
        }

        public void setValue(Object value) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            this._descriptor.setFormat(this._descriptor.getTypeDescriptor().getFormat((String)value));
        }
    }

    private static class SampleValueProperty
    extends PropertySupport.ReadWrite {
        private DisplayDescriptor _descriptor;

        public SampleValueProperty(DisplayDescriptor descriptor) {
            super("sampleValue", String.class, "Sample value", "The value of the property when dragged from the palette.");
            this._descriptor = descriptor;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            String sampleValue = "";
            if (this._descriptor.getSampleValue() != null) {
                sampleValue = Converter.convertTo((Object)this._descriptor.getSampleValue(), (Class)this._descriptor.getType());
            }
            return sampleValue;
        }

        public void setValue(Object value) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            try {
                String valueStr = (String)value;
                Class type = this._descriptor.getType();
                if (String.class.equals((Object)type)) {
                    if (valueStr != null) {
                        if (valueStr.isEmpty()) {
                            valueStr = " ";
                        }
                        this._descriptor.setSampleValue((Object)valueStr);
                    }
                } else if (!StringUtilities.isNullOrEmpty((String)valueStr)) {
                    this._descriptor.setSampleValue(Converter.convertFrom((String)valueStr, (Class)type));
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    private static class DefaultValueProperty
    extends PropertySupport.ReadWrite {
        private DisplayDescriptor _descriptor;

        public DefaultValueProperty(DisplayDescriptor descriptor) {
            super("defaultValue", String.class, "Default value", "The default value of the property.");
            this._descriptor = descriptor;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            String defaultValue = "";
            if (this._descriptor.getDefaultValue() != null) {
                defaultValue = Converter.convertTo((Object)this._descriptor.getDefaultValue(), (Class)this._descriptor.getType());
            }
            return defaultValue;
        }

        public void setValue(Object value) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            try {
                String valueStr = (String)value;
                Class type = this._descriptor.getType();
                if (String.class.equals((Object)type)) {
                    if (valueStr != null) {
                        Evaluator evaluator = EvaluatorFactory.createForDefaultValue((String)valueStr);
                        this._descriptor.setEvaluator(evaluator);
                        this._descriptor.setDefaultValue((Object)valueStr);
                    }
                } else if (!StringUtilities.isNullOrEmpty((String)valueStr)) {
                    this._descriptor.setDefaultValue(Converter.convertFrom((String)valueStr, (Class)type));
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }
}

