/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jbosh;

import com.kenai.jbosh.AbstractBody;
import com.kenai.jbosh.BOSHException;
import com.kenai.jbosh.BodyQName;
import com.kenai.jbosh.StaticBody;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ComposableBody
extends AbstractBody {
    private static final Pattern BOSH_START = Pattern.compile("<(?:(?:[^:\t\n\r >]+:)|(?:\\{[^\\}>]*?}))?body(?:[\t\n\r ][^>]*?)?(/>|>)");
    private final Map<BodyQName, String> attrs;
    private final String payload;
    private final AtomicReference<String> computed = new AtomicReference();

    private ComposableBody(Map<BodyQName, String> attrMap, String payloadXML) {
        this.attrs = attrMap;
        this.payload = payloadXML;
    }

    static ComposableBody fromStaticBody(StaticBody body) throws BOSHException {
        String payload;
        String raw = body.toXML();
        Matcher matcher = BOSH_START.matcher(raw);
        if (!matcher.find()) {
            throw new BOSHException("Could not locate 'body' element in XML.  The raw XML did not match the pattern: " + BOSH_START);
        }
        if (">".equals(matcher.group(1))) {
            int first = matcher.end();
            int last = raw.lastIndexOf("</");
            if (last < first) {
                last = first;
            }
            payload = raw.substring(first, last);
        } else {
            payload = "";
        }
        return new ComposableBody(body.getAttributes(), payload);
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder rebuild() {
        return Builder.fromBody(this);
    }

    @Override
    public Map<BodyQName, String> getAttributes() {
        return Collections.unmodifiableMap(this.attrs);
    }

    @Override
    public String toXML() {
        String comp = this.computed.get();
        if (comp == null) {
            comp = this.computeXML();
            this.computed.set(comp);
        }
        return comp;
    }

    public String getPayloadXML() {
        return this.payload;
    }

    private String escape(String value) {
        return value.replace("'", "&apos;");
    }

    private String computeXML() {
        BodyQName bodyName = ComposableBody.getBodyQName();
        StringBuilder builder = new StringBuilder();
        builder.append("<");
        builder.append(bodyName.getLocalPart());
        for (Map.Entry<BodyQName, String> entry : this.attrs.entrySet()) {
            builder.append(" ");
            BodyQName name = entry.getKey();
            String prefix = name.getPrefix();
            if (prefix != null && prefix.length() > 0) {
                builder.append(prefix);
                builder.append(":");
            }
            builder.append(name.getLocalPart());
            builder.append("='");
            builder.append(this.escape(entry.getValue()));
            builder.append("'");
        }
        builder.append(" ");
        builder.append("xmlns");
        builder.append("='");
        builder.append(bodyName.getNamespaceURI());
        builder.append("'>");
        if (this.payload != null) {
            builder.append(this.payload);
        }
        builder.append("</body>");
        return builder.toString();
    }

    public static final class Builder {
        private Map<BodyQName, String> map;
        private boolean doMapCopy;
        private String payloadXML;

        private Builder() {
        }

        private static Builder fromBody(ComposableBody source) {
            Builder result = new Builder();
            result.map = source.getAttributes();
            result.doMapCopy = true;
            result.payloadXML = source.payload;
            return result;
        }

        public Builder setPayloadXML(String xml) {
            if (xml == null) {
                throw new IllegalArgumentException("payload XML argument cannot be null");
            }
            this.payloadXML = xml;
            return this;
        }

        public Builder setAttribute(BodyQName name, String value) {
            if (this.map == null) {
                this.map = new HashMap<BodyQName, String>();
            } else if (this.doMapCopy) {
                this.map = new HashMap<BodyQName, String>(this.map);
                this.doMapCopy = false;
            }
            if (value == null) {
                this.map.remove(name);
            } else {
                this.map.put(name, value);
            }
            return this;
        }

        public Builder setNamespaceDefinition(String prefix, String uri) {
            BodyQName qname = BodyQName.createWithPrefix("http://www.w3.org/XML/1998/namespace", prefix, "xmlns");
            return this.setAttribute(qname, uri);
        }

        public ComposableBody build() {
            if (this.map == null) {
                this.map = new HashMap<BodyQName, String>();
            }
            if (this.payloadXML == null) {
                this.payloadXML = "";
            }
            return new ComposableBody(this.map, this.payloadXML);
        }
    }
}

