/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.chat.users;

import com.paterva.maltego.chatapi.ChatRoom;
import com.paterva.maltego.chatapi.user.User;
import com.paterva.maltego.chatapi.user.UserComparator;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.openide.util.Utilities;

class UsersTableModel
extends AbstractTableModel {
    private ChatRoom _chatRoom;
    private ChatRoomListener _chatRoomListener = new ChatRoomListener();

    UsersTableModel() {
    }

    public void setChatRoom(ChatRoom chatRoom) {
        if (!Utilities.compareObjects((Object)this._chatRoom, (Object)chatRoom)) {
            if (this._chatRoom != null) {
                this._chatRoom.removePropertyChangeListener((PropertyChangeListener)this._chatRoomListener);
            }
            this._chatRoom = chatRoom;
            if (this._chatRoom != null) {
                this._chatRoom.addPropertyChangeListener((PropertyChangeListener)this._chatRoomListener);
            }
            this.fireTableDataChanged();
        }
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return User.class;
    }

    @Override
    public int getRowCount() {
        return this._chatRoom != null ? this._chatRoom.getUsers().size() : 0;
    }

    @Override
    public int getColumnCount() {
        return 1;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this._chatRoom != null) {
            return this.getSortedUsers().get(rowIndex);
        }
        return null;
    }

    private List<User> getSortedUsers() {
        List users = this._chatRoom.getUsers();
        Collections.sort(users, new UserComparator(this._chatRoom));
        return users;
    }

    private class ChatRoomListener
    implements PropertyChangeListener {
        private ChatRoomListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (UsersTableModel.this._chatRoom == null) {
                throw new IllegalStateException("receiving events for null chatroom");
            }
            if ("chatRoomUserAdded".equals(evt.getPropertyName()) || "chatRoomUserRemoved".equals(evt.getPropertyName()) || "chatRoomUserPresence".equals(evt.getPropertyName()) || "chatRoomUserChanged".equals(evt.getPropertyName())) {
                UsersTableModel.this.fireTableDataChanged();
            }
        }
    }
}

