/*
 * Decompiled with CFR 0.152.
 */
package com.maltego.tx3.java.api.constraints.execution.entity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.maltego.tx3.java.api.constraints.ConstraintTargetTypeEnum;
import com.maltego.tx3.java.api.constraints.ConstraintTypeEnum;
import com.maltego.tx3.java.api.constraints.LogicalOperation;
import com.maltego.tx3.java.api.constraints.execution.InputConstraint;
import com.maltego.tx3.java.api.execution.Entity;

public class EntityTypeConstraint
extends InputConstraint {
    private final String entityType;

    @JsonCreator
    public EntityTypeConstraint(@JsonProperty(value="entity_type") String entityType) {
        this.entityType = entityType;
        this.constraintType = ConstraintTypeEnum.ENTITY;
        this.constraintTargetType = ConstraintTargetTypeEnum.ENTITY_TYPE;
    }

    @Override
    public boolean evaluate(Entity inputValue) {
        return inputValue.getType().equalsIgnoreCase(this.entityType);
    }

    @Override
    public LogicalOperation getConstraintOperation() {
        return LogicalOperation.ALL;
    }

    public String getEntityType() {
        return this.entityType;
    }
}

