/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.util;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;

public class CollectionUtilities {
    private CollectionUtilities() {
    }

    public static Enumeration getIteratorEnumeration(final Iterator i) {
        return new Enumeration(){

            @Override
            public boolean hasMoreElements() {
                return i.hasNext();
            }

            public Object nextElement() {
                return i.next();
            }
        };
    }

    public static Iterator iteratorUnion(final Iterator[] iterators) {
        return new Iterator(){
            private int iteratorIndex = 0;
            private Iterator current = iterators.length > 0 ? iterators[0] : null;

            @Override
            public boolean hasNext() {
                while (this.current != null) {
                    if (this.current.hasNext()) {
                        return true;
                    }
                    ++this.iteratorIndex;
                    this.current = this.iteratorIndex >= iterators.length ? null : iterators[this.iteratorIndex];
                }
                return false;
            }

            public Object next() {
                while (true) {
                    if (this.current == null) {
                        throw new NoSuchElementException();
                    }
                    try {
                        return this.current.next();
                    }
                    catch (NoSuchElementException nse) {
                        ++this.iteratorIndex;
                        this.current = this.iteratorIndex >= iterators.length ? null : iterators[this.iteratorIndex];
                        continue;
                    }
                    break;
                }
            }

            @Override
            public void remove() {
                if (this.current == null) {
                    throw new NoSuchElementException();
                }
                this.current.remove();
            }
        };
    }

    public static Collection reverse(Collection collection) {
        LinkedList newCollection = new LinkedList();
        Iterator i = collection.iterator();
        while (i.hasNext()) {
            newCollection.addFirst(i.next());
        }
        return newCollection;
    }

    public static Iterator singletonIterator(final Object item) {
        return new Iterator(){
            private boolean gotItem = false;

            @Override
            public boolean hasNext() {
                return !this.gotItem;
            }

            public Object next() {
                if (this.gotItem) {
                    throw new NoSuchElementException();
                }
                this.gotItem = true;
                return item;
            }

            @Override
            public void remove() {
                if (this.gotItem) {
                    throw new NoSuchElementException();
                }
                this.gotItem = true;
            }
        };
    }
}

