/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.automation.feeders;

import com.paterva.maltego.automation.feeders.AutomationRequestHandler;
import com.paterva.maltego.util.NamedThreadFactory;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;

class AutomationServer {
    private final int _port;
    private ExecutorService _pool;
    private boolean _started = false;
    private ServerSocket _server;

    public AutomationServer(int port) {
        this._port = port;
    }

    public synchronized void start() throws IOException {
        if (!this._started) {
            this._pool = Executors.newCachedThreadPool((ThreadFactory)new NamedThreadFactory("Automation Server"));
            InetSocketAddress address = new InetSocketAddress("localhost", this._port);
            this._server = new ServerSocket();
            this._server.bind(address);
            this._started = true;
            this._pool.execute(new ServerTask(this._server));
        }
    }

    public synchronized void stop() throws IOException {
        if (this._started) {
            this._started = false;
            try {
                this._server.close();
            }
            finally {
                this._pool.shutdown();
                try {
                    this._pool.awaitTermination(60L, TimeUnit.SECONDS);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private class ServerTask
    implements Runnable {
        private final ServerSocket _server;

        public ServerTask(ServerSocket server) {
            this._server = server;
        }

        @Override
        public void run() {
            while (AutomationServer.this._started) {
                try {
                    Socket client = this._server.accept();
                    if (!AutomationServer.this._started) continue;
                    AutomationServer.this._pool.execute(new HandleClientTask(client));
                }
                catch (IOException ex) {
                    Logger.getLogger(AutomationServer.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    private static class HandleClientTask
    implements Runnable {
        private final Socket _client;

        public HandleClientTask(Socket client) {
            this._client = client;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            InputStream is = null;
            try {
                is = this._client.getInputStream();
                String text = IOUtils.toString((InputStream)is);
                for (AutomationRequestHandler automationRequestHandler : AutomationRequestHandler.getAll()) {
                    automationRequestHandler.handleRequest(text);
                }
            }
            catch (IOException ex) {
            }
            finally {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException ex) {
                            Logger.getLogger(AutomationServer.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    }
                    this._client.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(AutomationServer.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }
}

