/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.automation;

import com.paterva.maltego.automation.PropertyBag;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public abstract class PropertySupport
implements PropertyBag {
    private Map<String, Object> _properties;
    private Object _value;

    public Object getProperty(String name) {
        return this.getProperty(name, null);
    }

    public static double getNumber(Object value, double defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof Integer) {
            int v = (Integer)value;
            return v;
        }
        if (value instanceof Float) {
            float v = ((Float)value).floatValue();
            return v;
        }
        if (value instanceof Byte) {
            byte v = (Byte)value;
            return v;
        }
        if (value instanceof Short) {
            short v = (Short)value;
            return v;
        }
        if (value instanceof Long) {
            long v = (Long)value;
            return v;
        }
        String v = value.toString();
        try {
            return Double.parseDouble(v);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    @Override
    public Object getProperty(String name, Object defaultValue) {
        Object value = null;
        if (this._properties != null) {
            value = this._properties.get(name);
        }
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    @Override
    public void putProperty(String name, Object value) {
        if (this._properties == null) {
            this._properties = new TreeMap<String, Object>();
        }
        this._properties.put(name, value);
    }

    @Override
    public Object getValue() {
        return this._value;
    }

    public Object getValue(Object defaultValue) {
        if (this._value == null) {
            return defaultValue;
        }
        return this._value;
    }

    @Override
    public void setValue(Object value) {
        this._value = value;
    }

    public Object getValueOrProperty(String name) {
        return this.getValueOrProperty(name, null);
    }

    public Object getValueOrProperty(String name, Object defaultValue) {
        Object value = this.getValue();
        if (value == null) {
            value = this.getProperty(name);
        }
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    public Set<String> getPropertyNames() {
        if (this._properties == null) {
            return null;
        }
        return this._properties.keySet();
    }
}

