/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.table.ui.wizard;

import com.paterva.maltego.graph.table.MappingRegistry;
import com.paterva.maltego.graph.table.TabularGraph;
import com.paterva.maltego.graph.table.io.impl.DefaultTabularGraph;
import com.paterva.maltego.graph.table.io.impl.TabularGraphSavedDateComparator;
import com.paterva.maltego.graph.table.ui.manager.ShowMappingManagerAction;
import com.paterva.maltego.graph.table.ui.wizard.ImportFileController;
import com.paterva.maltego.typing.descriptor.RegistryEvent;
import com.paterva.maltego.typing.descriptor.RegistryListener;
import com.paterva.maltego.util.ui.dialog.ValidatingController;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;

public class ImportFileLoadMappingController
extends ValidatingController<JPanel>
implements WizardDescriptor.ValidatingPanel {
    private final ImportFileController _importFileController = new ImportFileController();
    private JRadioButton _newMapping;
    private JRadioButton _existingMapping;
    private JComboBox _savedMappingsComboBox;
    private JButton _manageMappingsButton;
    private final RegistryListener _listener;

    public ImportFileLoadMappingController() {
        this.setName(this._importFileController.getName());
        this.setDescription("First choose whether you want to create a new mapping configuration or load a saved one. Then choose the table structured file or files to import from your file system.");
        this.setImage(ImageUtilities.loadImage((String)"com/paterva/maltego/graph/table/ui/resources/ImportTabularGraph.png".replace(".png", "48.png")));
        this.setBackgroundColor(new JPanel().getBackground());
        this._listener = new RegistryListener(){

            public void typeAdded(RegistryEvent event) {
                ImportFileLoadMappingController.this.refreshSavedMappings();
            }

            public void typeRemoved(RegistryEvent event) {
                ImportFileLoadMappingController.this.refreshSavedMappings();
            }

            public void typeUpdated(RegistryEvent event) {
                ImportFileLoadMappingController.this.refreshSavedMappings();
            }
        };
    }

    protected JPanel createComponent() {
        JPanel importLoadPanel = new JPanel();
        importLoadPanel.setLayout(new BorderLayout());
        JPanel mappingConfigPanel = new JPanel(new BorderLayout());
        mappingConfigPanel.setBorder(new TitledBorder(BorderFactory.createEmptyBorder(), "Mapping Configuration"));
        this._savedMappingsComboBox = new JComboBox();
        ButtonGroup mappingConfButtonGroup = new ButtonGroup();
        this._newMapping = new JRadioButton("New");
        this._existingMapping = new JRadioButton("Saved");
        this._existingMapping.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    ImportFileLoadMappingController.this._savedMappingsComboBox.setEnabled(true);
                } else {
                    ImportFileLoadMappingController.this._savedMappingsComboBox.setEnabled(false);
                }
            }
        });
        this._existingMapping.setSelected(true);
        mappingConfButtonGroup.add(this._newMapping);
        mappingConfButtonGroup.add(this._existingMapping);
        this._manageMappingsButton = new JButton("Manage");
        this._manageMappingsButton.addActionListener(new ShowMappingManagerAction());
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(this._manageMappingsButton);
        JPanel optionPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        optionPanel.add((Component)this._newMapping, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        optionPanel.add((Component)this._existingMapping, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 90;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        optionPanel.add((Component)this._savedMappingsComboBox, gridBagConstraints);
        mappingConfigPanel.add((Component)optionPanel, "West");
        mappingConfigPanel.add((Component)buttonPanel, "East");
        JPanel importFilePanel = new JPanel(new BorderLayout());
        importFilePanel.setBorder(new TitledBorder(BorderFactory.createEmptyBorder(), "Input File"));
        Component component = this._importFileController.getComponent();
        if (component instanceof JFileChooser) {
            ((JFileChooser)component).setMultiSelectionEnabled(true);
        }
        importFilePanel.add(component);
        importLoadPanel.add((Component)mappingConfigPanel, "North");
        importLoadPanel.add(importFilePanel);
        importLoadPanel.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
                MappingRegistry registry = MappingRegistry.getDefault();
                registry.addListener(ImportFileLoadMappingController.this._listener);
                ImportFileLoadMappingController.this.refreshSavedMappings();
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
                MappingRegistry registry = MappingRegistry.getDefault();
                registry.removeListener(ImportFileLoadMappingController.this._listener);
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }
        });
        return importLoadPanel;
    }

    protected void readSettings(WizardDescriptor settings) {
        this._importFileController.readSettings(settings);
    }

    protected void storeSettings(WizardDescriptor settings) {
        this._importFileController.storeSettings(settings);
        settings.putProperty("hasEntitiesbeenAutoDetected", (Object)false);
    }

    public void validate() throws WizardValidationException {
        if (this._existingMapping.isSelected() && this._savedMappingsComboBox.getSelectedIndex() != -1) {
            DefaultTabularGraph selectedTabularGraphCopy = new DefaultTabularGraph(MappingRegistry.getDefault().get(this._savedMappingsComboBox.getSelectedItem().toString()));
            this._importFileController.setTabularGraph((TabularGraph)selectedTabularGraphCopy);
        } else {
            this._importFileController.setTabularGraph(null);
        }
        this._importFileController.validate();
    }

    private void refreshSavedMappings() {
        try {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    ArrayList allMappings = ImportFileLoadMappingController.getSortedMappings(MappingRegistry.getDefault());
                    DefaultComboBoxModel<Object> cbmodel = new DefaultComboBoxModel<Object>(allMappings.toArray());
                    ImportFileLoadMappingController.this._savedMappingsComboBox.setModel(cbmodel);
                    if (ImportFileLoadMappingController.this._savedMappingsComboBox.getItemCount() > 0) {
                        ImportFileLoadMappingController.this._manageMappingsButton.setEnabled(true);
                        ImportFileLoadMappingController.this._existingMapping.setEnabled(true);
                        TabularGraph tg = ImportFileLoadMappingController.this._importFileController.getTabularGraph();
                        if (tg != null) {
                            for (int i = 0; i < ImportFileLoadMappingController.this._savedMappingsComboBox.getItemCount(); ++i) {
                                TabularGraph item = (TabularGraph)ImportFileLoadMappingController.this._savedMappingsComboBox.getItemAt(i);
                                if (!item.getName().equals(tg.getName())) continue;
                                ImportFileLoadMappingController.this._savedMappingsComboBox.setSelectedIndex(i);
                                break;
                            }
                        }
                    } else {
                        ImportFileLoadMappingController.this._manageMappingsButton.setEnabled(false);
                        ImportFileLoadMappingController.this._newMapping.setSelected(true);
                        ImportFileLoadMappingController.this._existingMapping.setSelected(false);
                        ImportFileLoadMappingController.this._existingMapping.setEnabled(false);
                        ImportFileLoadMappingController.this._savedMappingsComboBox.setEnabled(false);
                    }
                }
            };
            if (!SwingUtilities.isEventDispatchThread()) {
                SwingUtilities.invokeAndWait(runnable);
            } else {
                runnable.run();
            }
        }
        catch (InterruptedException | InvocationTargetException exception) {
            // empty catch block
        }
    }

    private static ArrayList<TabularGraph> getSortedMappings(MappingRegistry registry) {
        ArrayList<TabularGraph> list = new ArrayList<TabularGraph>(registry.getAll());
        Collections.sort(list, new TabularGraphSavedDateComparator());
        return list;
    }

    public HelpCtx getHelp() {
        return HelpCtx.DEFAULT_HELP;
    }
}

