/*
 * Decompiled with CFR 0.152.
 */
package com.maltego.guided.tour.ui;

import com.maltego.guided.tour.TourStep;
import com.maltego.guided.tour.ui.GuidedTourUtil;
import com.maltego.guided.tour.ui.StepNavigationPanel;
import com.maltego.guided.tour.ui.TitlePanel;
import com.maltego.guided.tour.ui.TourDialog;
import com.maltego.guided.tour.ui.TourDialogPresenter;
import com.maltego.guided.tour.ui.TutorialDefaults;
import com.paterva.maltego.util.MaltegoUrl;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.Area;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.swing.Action;
import javax.swing.GroupLayout;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class GraphAreaDialog
extends TourDialog {
    private TopComponent editorTC;
    private TourStep tourStep = TourStep.DEFAULT;
    private StepNavigationPanel navigationPanel;
    private TitlePanel titlePanel;

    public GraphAreaDialog(Frame frame) {
        super(frame);
        this.setMinimumSize(new Dimension(370, 0));
        this.initComponents();
        this.setEditorTC();
        this.adjustLocation();
        this.adjustShape();
        this.getContentPane().setBackground(TutorialDefaults.COLOR_STEP_BACKGROUND);
        this.navigationPanel.setCustomNextAction(() -> {
            List actionsForPath = Utilities.actionsForPath((String)"Actions/Graph");
            Optional<Action> showPaletteAction = actionsForPath.stream().filter(action -> {
                String name = action.getClass().getSimpleName();
                return name.equals("ShowPaletteAction");
            }).findFirst();
            showPaletteAction.orElseThrow(() -> new IllegalStateException("Entity Palette needs to be opened to go on with the guided tour")).actionPerformed(null);
            RequestProcessor.getDefault().post(() -> SwingUtilities.invokeLater(() -> this.tourStep.next()), 500, 10);
        });
    }

    @Override
    protected Point getRelativeLocation() {
        return new Point(-150, 90);
    }

    @Override
    public void setTourStep(TourStep tourStep) {
        this.tourStep = tourStep;
        this.titlePanel.setTourStep(tourStep);
        this.navigationPanel.setTourStep(tourStep);
    }

    private void setEditorTC() {
        Mode editorMode = WindowManager.getDefault().findMode("editor");
        this.editorTC = editorMode.getSelectedTopComponent();
        this.setLocationOnComponent((Component)this.editorTC);
    }

    private void adjustShape() {
        Area rectangle = new Area(new Rectangle(0, 0, this.getWidth() - 10, this.getHeight()));
        Area triangle = new Area(new Polygon(new int[]{this.getWidth() - 10, this.getWidth(), this.getWidth() - 10}, new int[]{this.getHeight() / 2 - 10, this.getHeight() / 2, this.getHeight() / 2 + 10}, 3));
        rectangle.add(triangle);
        this.setShape(rectangle);
    }

    private void initComponents() {
        this.titlePanel = new TitlePanel();
        JTextArea contentTextArea = new JTextArea();
        this.navigationPanel = new StepNavigationPanel();
        this.setDefaultCloseOperation(2);
        this.titlePanel.setTitle(NbBundle.getMessage(GraphAreaDialog.class, (String)"GraphAreaDialog.titlePanel.title"));
        contentTextArea.setEditable(false);
        contentTextArea.setColumns(20);
        contentTextArea.setFont(contentTextArea.getFont().deriveFont((float)contentTextArea.getFont().getSize() + 3.0f));
        contentTextArea.setLineWrap(true);
        contentTextArea.setRows(3);
        contentTextArea.setText(NbBundle.getMessage(GraphAreaDialog.class, (String)"GraphAreaDialog.contentTextArea.text"));
        contentTextArea.setWrapStyleWord(true);
        contentTextArea.setBorder(null);
        contentTextArea.setDisabledTextColor(TutorialDefaults.COLOR_TEXT);
        contentTextArea.setEnabled(false);
        contentTextArea.setOpaque(false);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(15, 15, 15).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.titlePanel, -1, -1, Short.MAX_VALUE).addComponent(contentTextArea).addComponent(this.navigationPanel, -1, -1, Short.MAX_VALUE)).addGap(25, 25, 25)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(15, 15, 15).addComponent(this.titlePanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(contentTextArea, -2, -1, -2).addGap(32, 32, 32).addComponent(this.navigationPanel, -2, -1, -2).addContainerGap(15, Short.MAX_VALUE)));
        this.pack();
    }

    public static class Presenter
    extends TourDialogPresenter<GraphAreaDialog> {
        @Override
        protected GraphAreaDialog createTourDialog(Frame frame) {
            return new GraphAreaDialog(frame);
        }

        @Override
        public Supplier<Rectangle> getFocusArea() {
            Mode editorMode = WindowManager.getDefault().findMode("editor");
            TopComponent selectedTopComponent = editorMode.getSelectedTopComponent();
            return GuidedTourUtil.createTopComponentFocusArea(selectedTopComponent);
        }

        @Override
        public Consumer<Graphics2D> getPainter() {
            Mode editorMode = WindowManager.getDefault().findMode("editor");
            TopComponent selectedTopComponent = editorMode.getSelectedTopComponent();
            return GuidedTourUtil.createTopComponentFocusAreaPainter(selectedTopComponent);
        }

        @Override
        public String learnMoreLink() {
            return MaltegoUrl.getCurrent().getGotoOnboardingFirstGraph();
        }
    }
}

