/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core;

import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Type;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.QueryParam;
import org.jboss.resteasy.core.StringParameterInjector;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.spi.ValueInjector;

public class QueryParamInjector
extends StringParameterInjector
implements ValueInjector {
    private boolean encode;
    private String encodedName;

    public QueryParamInjector(Class<?> type, Type genericType, AccessibleObject target, String paramName, String defaultValue, boolean encode, Annotation[] annotations, ResteasyProviderFactory factory) {
        super(type, genericType, paramName, QueryParam.class, defaultValue, target, annotations, factory);
        this.encode = encode;
        try {
            this.encodedName = URLDecoder.decode(paramName, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new BadRequestException(Messages.MESSAGES.unableToDecodeQueryString());
        }
    }

    @Override
    protected void throwProcessingException(String message, Throwable cause) {
        throw new NotFoundException(message, cause);
    }

    public Object inject(HttpRequest request, HttpResponse response, boolean unwrapAsync) {
        if (this.encode) {
            List list = (List)request.getUri().getQueryParameters(false).get((Object)this.encodedName);
            return this.extractValues(list);
        }
        List list = (List)request.getUri().getQueryParameters().get((Object)this.paramName);
        return this.extractValues(list);
    }

    public Object inject(boolean unwrapAsync) {
        throw new RuntimeException(Messages.MESSAGES.illegalToInjectQueryParam());
    }
}

