/*
 * Decompiled with CFR 0.152.
 */
package com.pinkmatter.pandora;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class PandoraProperty {
    private final String _name;
    private final Class _type;
    private List<PandoraProperty> _children;

    public PandoraProperty(String name, Class type) {
        this._name = name;
        this._type = type;
    }

    public PandoraProperty(String name, Class type, List<PandoraProperty> children) {
        this._name = name;
        this._type = type;
        this._children = children;
    }

    public String getName() {
        return this._name;
    }

    public Class getType() {
        return this._type;
    }

    public boolean hasChildren() {
        return this._children == null || this._children.isEmpty();
    }

    public List<PandoraProperty> getChildren() {
        if (this._children == null) {
            this._children = new ArrayList<PandoraProperty>();
        }
        return this._children;
    }

    public PandoraProperty getChild(String name) {
        if (this.hasChildren()) {
            for (PandoraProperty prop : this.getChildren()) {
                if (!prop.getName().equals(name)) continue;
                return prop;
            }
        }
        return null;
    }

    public int hashCode() {
        int hash = 7;
        hash = 11 * hash + Objects.hashCode(this._name);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PandoraProperty other = (PandoraProperty)obj;
        if (!Objects.equals(this._name, other._name)) {
            return false;
        }
        if (!Objects.equals(this._type, other._type)) {
            return false;
        }
        if (!Objects.equals(this.hasChildren(), other.hasChildren())) {
            return false;
        }
        return Objects.equals(this.getChildren(), other.getChildren());
    }

    public String toString() {
        return "PandoraProperty{_name=" + this._name + ", _type=" + this._type + '}';
    }
}

