/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.external.text;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.MaltegoLink;
import com.paterva.maltego.graph.external.api.GraphXDescriptor;
import com.paterva.maltego.graph.external.api.GraphXException;
import com.paterva.maltego.graph.external.api.GraphXUpdateResult;
import com.paterva.maltego.graph.external.text.stubs.RequestGraphStub;
import com.paterva.maltego.graph.external.text.stubs.RequestStub;
import com.paterva.maltego.graph.external.text.stubs.ResponseGraphStub;
import com.paterva.maltego.graph.external.text.stubs.ResponseGraphsStub;
import com.paterva.maltego.graph.external.text.stubs.ResponseStub;
import com.paterva.maltego.graph.external.text.stubs.ResponseUpdateStub;
import com.paterva.maltego.merging.GraphMergeStrategy;
import com.paterva.maltego.merging.PartMergeStrategy;
import com.paterva.maltego.serializers.GraphSerializationException;
import com.paterva.maltego.serializers.compact.CompactGraphNameMappings;
import com.paterva.maltego.serializers.compact.CompactGraphReader;
import com.paterva.maltego.serializers.compact.CompactGraphWriter;
import com.paterva.maltego.serializers.compact.DeserializedGraph;
import com.paterva.maltego.serializers.compact.LinkNameMappings;
import com.paterva.maltego.serializers.compact.SerializedGraph;
import com.paterva.maltego.serializers.compact.stubs.EntityStub;
import com.paterva.maltego.serializers.compact.stubs.GraphSnippetStub;
import com.paterva.maltego.serializers.compact.stubs.LinkStub;
import com.paterva.maltego.serializers.compact.stubs.OrderedStub;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

class TextGraphXTranslator {
    TextGraphXTranslator() {
    }

    public List<OrderedStub> translateRequest(RequestStub request) {
        ArrayList<OrderedStub> operations = new ArrayList<OrderedStub>();
        operations.addAll(request.getGraphsList());
        operations.addAll(request.getGraphList());
        operations.addAll(request.getUpdateList());
        operations.addAll(request.getRemoveList());
        operations.addAll(request.getNewGraphList());
        Collections.sort(operations, new OperationsComparator());
        return operations;
    }

    public ResponseStub translateResponse(List<OrderedStub> results) throws GraphXException {
        ResponseStub response = new ResponseStub();
        response.addAll(results);
        return response;
    }

    public ResponseGraphsStub translateGraphs(List<GraphXDescriptor> graphs) {
        ResponseGraphsStub stub = new ResponseGraphsStub();
        for (GraphXDescriptor graph : graphs) {
            stub.add(graph.getId(), graph.getName());
        }
        return stub;
    }

    public ResponseGraphStub translateGraphResponse(RequestGraphStub request, GraphID graphID) throws GraphSerializationException, GraphXException {
        List requestedLinks;
        ResponseGraphStub stub = new ResponseGraphStub();
        SerializedGraph serializedGraph = new SerializedGraph();
        serializedGraph.setGraph((GraphSnippetStub)stub);
        CompactGraphWriter cgs = new CompactGraphWriter((CompactGraphNameMappings)new LinkNameMappings());
        cgs.copy(graphID, serializedGraph, true);
        List requestedEntities = request.getEntities();
        if (!requestedEntities.isEmpty()) {
            this.retainRequestedEntities(stub, requestedEntities);
        }
        if (!(requestedLinks = request.getLinks()).isEmpty()) {
            this.retainRequestedLinks(stub, requestedLinks);
        }
        return stub;
    }

    private void retainRequestedEntities(ResponseGraphStub stub, Collection<EntityStub> requestedEntities) {
        ArrayList<EntityStub> toRemove = new ArrayList<EntityStub>();
        for (EntityStub responseEntity : stub.getEntities()) {
            boolean found = false;
            for (EntityStub entityStub : requestedEntities) {
                if (entityStub.getID() == null || !entityStub.getID().equals(responseEntity.getID())) continue;
                found = true;
                break;
            }
            if (found) continue;
            toRemove.add(responseEntity);
        }
        stub.removeEntities(toRemove);
    }

    private void retainRequestedLinks(ResponseGraphStub stub, Collection<LinkStub> requestedLinks) {
        ArrayList<LinkStub> toRemove = new ArrayList<LinkStub>();
        for (LinkStub responseLink : stub.getLinks()) {
            boolean found = false;
            for (LinkStub linkStub : requestedLinks) {
                if (linkStub.getID() == null || !linkStub.getID().equals(responseLink.getID())) continue;
                found = true;
                break;
            }
            if (found) continue;
            toRemove.add(responseLink);
        }
        stub.removeLinks(toRemove);
    }

    public DeserializedGraph translateUpdateGraph(GraphSnippetStub stub, GraphID graphID) throws GraphSerializationException {
        CompactGraphReader cgr = new CompactGraphReader((CompactGraphNameMappings)new LinkNameMappings());
        return cgr.translate(stub, graphID, true, false);
    }

    public ResponseUpdateStub translateUpdateResult(DeserializedGraph graph, GraphXUpdateResult result) {
        ResponseUpdateStub stub = new ResponseUpdateStub();
        List<EntityStub> dstEntityStubs = this.translateUpdatedEntities(graph, result);
        List<LinkStub> dstLinkStubs = this.translateUpdatedLinks(graph, result);
        if (!dstEntityStubs.isEmpty()) {
            stub.addEntities(dstEntityStubs);
        }
        if (!dstLinkStubs.isEmpty()) {
            stub.addLinks(dstLinkStubs);
        }
        return stub;
    }

    private List<EntityStub> translateUpdatedEntities(DeserializedGraph graph, GraphXUpdateResult result) {
        ArrayList<EntityStub> dstStubs = new ArrayList<EntityStub>();
        for (Map.Entry entry : graph.getEntityMap().entrySet()) {
            EntityStub srcStub = (EntityStub)entry.getKey();
            MaltegoEntity srcEntity = (MaltegoEntity)entry.getValue();
            MaltegoEntity dstEntity = (MaltegoEntity)result.getEntityMap().get(srcEntity);
            if (dstEntity == null) continue;
            EntityStub dstStub = new EntityStub();
            dstStub.setNum(srcStub.getNum());
            dstStub.setID(((EntityID)dstEntity.getID()).toString());
            dstStubs.add(dstStub);
        }
        Collections.sort(dstStubs, new OperationsComparator());
        return dstStubs;
    }

    private List<LinkStub> translateUpdatedLinks(DeserializedGraph graph, GraphXUpdateResult result) {
        ArrayList<LinkStub> dstStubs = new ArrayList<LinkStub>();
        for (Map.Entry entry : graph.getLinkMap().entrySet()) {
            LinkStub srcStub = (LinkStub)entry.getKey();
            MaltegoLink srcLink = (MaltegoLink)entry.getValue();
            MaltegoLink dstLink = (MaltegoLink)result.getLinkMap().get(srcLink);
            if (dstLink == null) continue;
            LinkStub dstStub = new LinkStub();
            dstStub.setNum(srcStub.getNum());
            dstStub.setID(((LinkID)dstLink.getID()).toString());
            dstStubs.add(dstStub);
        }
        Collections.sort(dstStubs, new OperationsComparator());
        return dstStubs;
    }

    public GraphMergeStrategy translateMergeStrategies(String entityMergeSrat, String linkMergeStrat) throws GraphXException {
        return new GraphMergeStrategy.Basic(this.translateMergeStrategy(entityMergeSrat), this.translateMergeStrategy(linkMergeStrat));
    }

    public PartMergeStrategy translateMergeStrategy(String mergeSrat) throws GraphXException {
        if (mergeSrat == null) {
            return PartMergeStrategy.PreferNew;
        }
        if ("keep old".equals(mergeSrat)) {
            return PartMergeStrategy.KeepOriginal;
        }
        if ("prefer old".equals(mergeSrat)) {
            return PartMergeStrategy.PreferOriginal;
        }
        if ("prefer new".equals(mergeSrat)) {
            return PartMergeStrategy.PreferNew;
        }
        if ("keep new".equals(mergeSrat)) {
            return PartMergeStrategy.Replace;
        }
        if ("update".equals(mergeSrat)) {
            return PartMergeStrategy.Update;
        }
        throw new GraphXException("Unknown merge strategy: " + mergeSrat);
    }

    private static class OperationsComparator
    implements Comparator<OrderedStub> {
        private OperationsComparator() {
        }

        @Override
        public int compare(OrderedStub o1, OrderedStub o2) {
            Integer num1 = o1.getNum();
            Integer num2 = o2.getNum();
            if (num1 != null && num2 != null) {
                return num1.compareTo(num2);
            }
            if (num1 == null && num2 == null) {
                return 0;
            }
            if (num1 == null) {
                return -1;
            }
            return 1;
        }
    }
}

