/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.external;

import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.graph.external.api.GraphXDescriptor;
import com.paterva.maltego.graph.external.api.GraphXException;
import com.paterva.maltego.graph.external.api.GraphXRegistry;
import com.paterva.maltego.ui.graph.GraphEditorRegistry;
import com.paterva.maltego.ui.graph.data.GraphDataObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.openide.windows.TopComponent;

public class MaltegoGraphXRegistry
extends GraphXRegistry {
    public List<GraphXDescriptor> getGraphXDescriptors() {
        ArrayList<GraphXDescriptor> descriptors = new ArrayList<GraphXDescriptor>();
        Set openTCs = GraphEditorRegistry.getDefault().getOpen();
        for (TopComponent tc : openTCs) {
            GraphDataObject gdo = (GraphDataObject)tc.getLookup().lookup(GraphDataObject.class);
            if (gdo == null) continue;
            GraphXDescriptor descriptor = MaltegoGraphXRegistry.getGraphXDescriptor(gdo);
            descriptors.add(descriptor);
        }
        return descriptors;
    }

    public GraphXDescriptor getGraphXDescriptor(int id) throws GraphXException {
        GraphXDescriptor descriptor;
        GraphDataObject gdo = this.getGraphDataObject(id);
        GraphXDescriptor graphXDescriptor = descriptor = gdo == null ? null : MaltegoGraphXRegistry.getGraphXDescriptor(gdo);
        if (descriptor == null) {
            throw new GraphXException("No open graph with id " + id);
        }
        return descriptor;
    }

    public GraphID getGraphID(int id) throws GraphXException {
        GraphDataObject gdo = this.getGraphDataObject(id);
        if (gdo == null) {
            throw new GraphXException("No open graph with id " + id);
        }
        return gdo.getGraphID();
    }

    private GraphDataObject getGraphDataObject(int id) {
        Set openTCs = GraphEditorRegistry.getDefault().getOpen();
        for (TopComponent tc : openTCs) {
            GraphDataObject gdo = (GraphDataObject)tc.getLookup().lookup(GraphDataObject.class);
            if (gdo == null || id != MaltegoGraphXRegistry.getGraphXID(gdo.getGraphID())) continue;
            return gdo;
        }
        return null;
    }

    public static GraphXDescriptor getGraphXDescriptor(GraphDataObject gdo) {
        Integer id = MaltegoGraphXRegistry.getGraphXID(gdo.getGraphID());
        String name = gdo.getName();
        return new GraphXDescriptor(id.intValue(), name);
    }

    private static int getGraphXID(GraphID graphID) {
        return (int)graphID.getValue();
    }
}

