/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.imgfactoryapi;

import com.paterva.maltego.imgfactoryapi.RegistryIcon;
import com.paterva.maltego.util.Args;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class IconCatalog {
    private final Map<String, Map<String, RegistryIcon>> icons = new LinkedHashMap<String, Map<String, RegistryIcon>>();

    public RegistryIcon addOrReplaceIcon(String category, String name) {
        return this.addOrReplaceIcon(category, name, Collections.emptySet(), Collections.emptySet());
    }

    public RegistryIcon addOrReplaceIcon(String category, String name, Set<String> aliases, Set<String> hubItems) {
        Args.notNullOrBlank((String)category, (String)"category");
        Args.notNullOrBlank((String)name, (String)"name");
        Args.notNull(aliases, (String)"aliases");
        Args.notNull(hubItems, (String)"hubItems");
        Map<String, RegistryIcon> namesMap = this.icons.get(category);
        if (namesMap == null) {
            namesMap = new LinkedHashMap<String, RegistryIcon>();
            this.icons.put(category, namesMap);
        }
        RegistryIcon icon = new RegistryIcon(category, name, aliases, hubItems);
        namesMap.put(name, icon);
        return icon;
    }

    public List<RegistryIcon> getIcons() {
        return this.getIcons((String __) -> true);
    }

    public List<RegistryIcon> getIcons(String category) {
        Args.notNullOrBlank((String)category, (String)"category");
        return this.getIcons((String cat) -> cat.equals(category));
    }

    public boolean contains(RegistryIcon icon) {
        Args.notNull((Object)icon, (String)"icon");
        Map<String, RegistryIcon> namesMap = this.icons.get(icon.getCategory());
        return namesMap != null && namesMap.containsKey(icon.getName());
    }

    private List<RegistryIcon> getIcons(Predicate<String> categoryFilter) {
        Args.notNull(categoryFilter, (String)"categoryFilter");
        List icns = this.icons.entrySet().stream().filter(entry -> categoryFilter.test((String)entry.getKey())).map(entry -> ((Map)entry.getValue()).values()).flatMap(Collection::stream).collect(Collectors.toList());
        return Collections.unmodifiableList(icns);
    }

    public Set<String> getCategories() {
        return Collections.unmodifiableSet(this.icons.keySet());
    }

    public Set<String> getIconNames(String category) {
        Args.notNullOrBlank((String)category, (String)"category");
        Map<String, RegistryIcon> namesMap = this.getNamesMap(category);
        return Collections.unmodifiableSet(namesMap.keySet());
    }

    public RegistryIcon rename(RegistryIcon icon, String newName) {
        Args.notNull((Object)icon, (String)"icon");
        Args.notNullOrBlank((String)newName, (String)"newName");
        String category = icon.getCategory();
        Map<String, RegistryIcon> namesMap = this.icons.get(category);
        if (namesMap == null) {
            throw new IllegalArgumentException("Category does not exist: " + category);
        }
        String oldName = icon.getName();
        RegistryIcon oldIcon = namesMap.remove(oldName);
        if (oldIcon == null) {
            throw new IllegalArgumentException("Old icon does not exist: " + oldName);
        }
        RegistryIcon newIcon = new RegistryIcon(category, newName, oldIcon.getAliases(), oldIcon.getHubItems());
        namesMap.put(newName, newIcon);
        return newIcon;
    }

    public void removeCategory(String category) {
        Args.notNullOrBlank((String)category, (String)"category");
        this.icons.remove(category);
    }

    public void removeIcon(RegistryIcon icon) {
        Args.notNull((Object)icon, (String)"icon");
        Map<String, RegistryIcon> namesMap = this.icons.get(icon.getCategory());
        if (namesMap == null) {
            throw new IllegalArgumentException("Category does not exist: " + namesMap);
        }
        namesMap.remove(icon.getName());
    }

    private Map<String, RegistryIcon> getNamesMap(String category) {
        Args.notNullOrBlank((String)category, (String)"category");
        Map<String, RegistryIcon> namesMap = this.icons.get(category);
        return namesMap != null ? namesMap : Collections.emptyMap();
    }
}

