/*
 * Decompiled with CFR 0.152.
 */
package org.officelaf;

import com.bulenkov.iconloader.util.GraphicsUtil;
import com.paterva.maltego.util.ui.fonts.FontUtils;
import com.paterva.maltego.util.ui.laf.MaltegoLAF;
import com.paterva.maltego.util.ui.laf.MaltegoLAFRefresh;
import com.paterva.maltego.util.ui.laf.debug.MaltegoLAFDebugPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.lang.reflect.InvocationTargetException;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.FontUIResource;
import org.officelaf.OSFileChooser;
import org.officelaf.OfficeLookAndFeelHelper;
import org.officelaf.OfficeRootPaneUI;
import org.openide.ErrorManager;
import org.openide.util.Exceptions;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class MaltegoLAFRefresher
extends MaltegoLAFRefresh {
    private static final Logger LOG = Logger.getLogger(MaltegoLAFRefresher.class.getName());
    private static final Color GRAY_76 = new Color(76, 76, 76);

    public void refresh(final boolean firstRefresh) {
        try {
            System.setProperty("netbeans.exception.report.min.level", "99999");
            System.setProperty("netbeans.winsys.status_line.path", "LookAndFeel/org-officelaf-StatusBar.instance");
            Laf laf = Laf.get(System.getProperty("os.name"));
            LOG.log(Level.INFO, "LAF: {0}", (Object)laf);
            final LookAndFeel lafInstance = laf.createLafInstance();
            if (lafInstance != null) {
                try {
                    while (UIManager.getDefaults().get("ClassLoader") == null) {
                        Thread.sleep(100L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.runInEDT(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Frame[] frames;
                            OSFileChooser.getDefault(!firstRefresh);
                            UIManager.setLookAndFeel(lafInstance);
                            if ("Darcula".equals(lafInstance.getName())) {
                                OfficeLookAndFeelHelper helper = new OfficeLookAndFeelHelper();
                                UIManager.getLookAndFeelDefaults().putDefaults(helper.getClassDefaults());
                                UIManager.getLookAndFeelDefaults().putDefaults(helper.getComponentDefaults());
                                OfficeLookAndFeelHelper.installLFCustoms(lafInstance, UIManager.getDefaults());
                                MaltegoLAFRefresher.this.overwriteFontSizesWithUserSetSizes();
                                MaltegoLAFRefresher.this.overwriteUIManagerDeveloperSysemColorsWithUIManagerLafSystemColors();
                                Font defaultFontWithUserSetSize = UIManager.getLookAndFeelDefaults().getFont("7-default-font");
                                int userSetSize = defaultFontWithUserSetSize.getSize();
                                UIManager.put("uiFontSize", userSetSize);
                                UIManager.put("controlFont", defaultFontWithUserSetSize);
                                UIManager.put("EditorPane.font", new Font(defaultFontWithUserSetSize.getFamily(), 0, userSetSize + 2));
                                MaltegoLAF.updateLookAndFeelDefaults();
                            }
                            for (Frame frame : frames = Frame.getFrames()) {
                                SwingUtilities.updateComponentTreeUI(frame);
                            }
                        }
                        catch (UnsupportedLookAndFeelException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                });
            } else {
                LOG.log(Level.INFO, "No LAF for {0}", System.getProperty("os.name"));
                OfficeLookAndFeelHelper helper = new OfficeLookAndFeelHelper();
                UIManager.getLookAndFeelDefaults().putDefaults(helper.getClassDefaults());
                UIManager.getLookAndFeelDefaults().putDefaults(helper.getComponentDefaults());
            }
            if (firstRefresh) {
                this.runInEDT(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            JFrame main = (JFrame)WindowManager.getDefault().getMainWindow();
                            JPanel orange = new JPanel(new BorderLayout()){

                                @Override
                                public void add(Component comp, Object constraints) {
                                    super.add(comp, constraints);
                                    if (constraints == "Center") {
                                        comp.setBackground(GRAY_76);
                                        if (comp instanceof JPanel) {
                                            JPanel panel = (JPanel)comp;
                                            panel.setBorder(BorderFactory.createEmptyBorder());
                                        }
                                    }
                                }
                            };
                            main.setContentPane(orange);
                        }
                        catch (Exception ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                });
                WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            WindowManager wm = WindowManager.getDefault();
                            JFrame main = (JFrame)wm.getMainWindow();
                            if (6 == main.getExtendedState()) {
                                OfficeRootPaneUI.updateMaximizedBounds(main);
                                if (main.getMaximizedBounds() != null) {
                                    main.setExtendedState(0);
                                    main.setExtendedState(6);
                                }
                            }
                            Set modes = wm.getModes();
                            for (Mode mode : modes) {
                                TopComponent[] tcs;
                                for (TopComponent tc : tcs = mode.getTopComponents()) {
                                    tc.putClientProperty((Object)"netbeans.winsys.tc.draganddrop_copy_disabled", (Object)Boolean.TRUE);
                                }
                            }
                        }
                        catch (Exception ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                });
                this.refresh(false);
                if (GraphicsUtil.useCustomLafFrameDecorations((boolean)true)) {
                    JFrame.setDefaultLookAndFeelDecorated(true);
                    JDialog.setDefaultLookAndFeelDecorated(true);
                }
            }
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private void overwriteFontSizesWithUserSetSizes() {
        Enumeration keys = UIManager.getLookAndFeelDefaults().keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Object value = UIManager.getLookAndFeelDefaults().get(key);
            if (value == null || !(value instanceof Font)) continue;
            FontUIResource font = (FontUIResource)value;
            UIManager.getLookAndFeelDefaults().put(key, this.getFontScaled(font));
        }
    }

    private void overwriteUIManagerDeveloperSysemColorsWithUIManagerLafSystemColors() {
        Enumeration keys = UIManager.getLookAndFeelDefaults().keys();
        while (keys.hasMoreElements()) {
            String keyString;
            String componentName;
            Object key = keys.nextElement();
            Object value = UIManager.getLookAndFeelDefaults().get(key);
            if (!(key instanceof String) || !"system colors".equals(componentName = MaltegoLAFDebugPanel.getComponentName((String)(keyString = (String)key), (Object)value))) continue;
            UIManager.put(key, value);
        }
    }

    private Font getFontScaled(Font font) {
        if (font != null) {
            font = FontUtils.scale((Font)font);
        }
        return font;
    }

    private void runInEDT(Runnable runnable) throws InvocationTargetException, InterruptedException {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeAndWait(runnable);
        }
    }

    static enum Laf {
        WINDOWS("windows", "com.bulenkov.darcula.DarculaLaf"),
        LINUX("linux", "com.bulenkov.darcula.DarculaLaf"),
        MAC("mac os x", "com.bulenkov.darcula.DarculaLaf"),
        DEFAULT("default", null);

        private String osName;
        private String lafName;

        private Laf(String osName, String lafName) {
            this.osName = osName;
            this.lafName = lafName;
        }

        public static Laf get(String osName) {
            for (Laf laf : EnumSet.allOf(Laf.class)) {
                if (osName.toLowerCase().indexOf(laf.getOsName().toLowerCase()) != 0) continue;
                return laf;
            }
            return DEFAULT;
        }

        public String getOsName() {
            return this.osName;
        }

        public String getLafName() {
            return this.lafName;
        }

        public LookAndFeel createLafInstance() throws ClassNotFoundException, IllegalAccessException, InstantiationException {
            if (this.lafName == null) {
                return null;
            }
            Class<?> lafClass = Class.forName(this.lafName);
            return (LookAndFeel)lafClass.newInstance();
        }

        public String toString() {
            return this.osName + ": " + this.lafName;
        }
    }
}

