/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.protocol.v2api.remote;

import com.paterva.maltego.transform.protocol.v2api.messaging.DiscoveryResponse;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

class MacroExpander {
    public static final String THIS = "${this}";
    private Map<String, String> _macros = new HashMap<String, String>();

    MacroExpander() {
    }

    public void add(String macroName, String value) {
        this._macros.put(macroName, value);
    }

    public void expand(DiscoveryResponse response) {
        if (response != null) {
            Object url;
            for (DiscoveryResponse.SeedServerDescriptor seed : response.getSeedServers()) {
                if (seed == null || (url = seed.getUrl()) == null) continue;
                seed.setUrl(this.expand((URL)url));
            }
            for (DiscoveryResponse.TransformApplicationDescriptor desc : response.getTransformApplications()) {
                if (desc == null || (url = desc.getUrl()) == null) continue;
                desc.setUrl(this.expand((String)url));
            }
        }
    }

    public URL expand(URL url) {
        String s = this.expand(url.toString());
        try {
            return new URL(s);
        }
        catch (MalformedURLException ex) {
            return url;
        }
    }

    public String expand(String s) {
        for (Map.Entry<String, String> entry : this._macros.entrySet()) {
            s = s.replace(entry.getKey(), entry.getValue());
        }
        return s;
    }
}

